/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import androidx.annotation.Nullable;
import com.google.firebase.firestore.core.Bound;
import com.google.firebase.firestore.core.Filter;
import com.google.firebase.firestore.core.OrderBy;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.ResourcePath;
import java.util.List;

public final class Target {
    public static final long NO_LIMIT = -1L;
    @Nullable
    private String memoizedCannonicalId;
    private final List<OrderBy> orderBy;
    private final List<Filter> filters;
    private final ResourcePath path;
    @Nullable
    private final String collectionGroup;
    private final long limit;
    @Nullable
    private final Bound startAt;
    @Nullable
    private final Bound endAt;

    public Target(ResourcePath path, @Nullable String collectionGroup, List<Filter> filters, List<OrderBy> orderBy, long limit, @Nullable Bound startAt, @Nullable Bound endAt) {
        this.path = path;
        this.collectionGroup = collectionGroup;
        this.orderBy = orderBy;
        this.filters = filters;
        this.limit = limit;
        this.startAt = startAt;
        this.endAt = endAt;
    }

    public ResourcePath getPath() {
        return this.path;
    }

    @Nullable
    public String getCollectionGroup() {
        return this.collectionGroup;
    }

    public boolean isDocumentQuery() {
        return DocumentKey.isDocumentKey(this.path) && this.collectionGroup == null && this.filters.isEmpty();
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public long getLimit() {
        return this.limit;
    }

    public boolean hasLimit() {
        return this.limit != -1L;
    }

    @Nullable
    public Bound getStartAt() {
        return this.startAt;
    }

    @Nullable
    public Bound getEndAt() {
        return this.endAt;
    }

    public List<OrderBy> getOrderBy() {
        return this.orderBy;
    }

    public String getCanonicalId() {
        if (this.memoizedCannonicalId != null) {
            return this.memoizedCannonicalId;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.getPath().canonicalString());
        if (this.collectionGroup != null) {
            builder.append("|cg:");
            builder.append(this.collectionGroup);
        }
        builder.append("|f:");
        for (Filter filter : this.getFilters()) {
            builder.append(filter.getCanonicalId());
        }
        builder.append("|ob:");
        for (OrderBy orderBy : this.getOrderBy()) {
            builder.append(orderBy.getField().canonicalString());
            builder.append(orderBy.getDirection().equals((Object)OrderBy.Direction.ASCENDING) ? "asc" : "desc");
        }
        if (this.hasLimit()) {
            builder.append("|l:");
            builder.append(this.getLimit());
        }
        if (this.startAt != null) {
            builder.append("|lb:");
            builder.append(this.startAt.canonicalString());
        }
        if (this.endAt != null) {
            builder.append("|ub:");
            builder.append(this.endAt.canonicalString());
        }
        this.memoizedCannonicalId = builder.toString();
        return this.memoizedCannonicalId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Target target = (Target)o;
        if (this.collectionGroup != null ? !this.collectionGroup.equals(target.collectionGroup) : target.collectionGroup != null) {
            return false;
        }
        if (this.limit != target.limit) {
            return false;
        }
        if (!this.orderBy.equals(target.orderBy)) {
            return false;
        }
        if (!this.filters.equals(target.filters)) {
            return false;
        }
        if (!this.path.equals(target.path)) {
            return false;
        }
        if (this.startAt != null ? !this.startAt.equals(target.startAt) : target.startAt != null) {
            return false;
        }
        return this.endAt != null ? this.endAt.equals(target.endAt) : target.endAt == null;
    }

    public int hashCode() {
        int result = this.orderBy.hashCode();
        result = 31 * result + (this.collectionGroup != null ? this.collectionGroup.hashCode() : 0);
        result = 31 * result + this.filters.hashCode();
        result = 31 * result + this.path.hashCode();
        result = 31 * result + (int)(this.limit ^ this.limit >>> 32);
        result = 31 * result + (this.startAt != null ? this.startAt.hashCode() : 0);
        result = 31 * result + (this.endAt != null ? this.endAt.hashCode() : 0);
        return result;
    }

    public String toString() {
        int i;
        StringBuilder builder = new StringBuilder();
        builder.append("Query(");
        builder.append(this.path.canonicalString());
        if (this.collectionGroup != null) {
            builder.append(" collectionGroup=");
            builder.append(this.collectionGroup);
        }
        if (!this.filters.isEmpty()) {
            builder.append(" where ");
            for (i = 0; i < this.filters.size(); ++i) {
                if (i > 0) {
                    builder.append(" and ");
                }
                builder.append(this.filters.get(i).toString());
            }
        }
        if (!this.orderBy.isEmpty()) {
            builder.append(" order by ");
            for (i = 0; i < this.orderBy.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(this.orderBy.get(i));
            }
        }
        builder.append(")");
        return builder.toString();
    }
}

