/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import com.google.firebase.Timestamp;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.core.Target;
import com.google.firebase.firestore.local.QueryPurpose;
import com.google.firebase.firestore.local.TargetData;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.MutableDocument;
import com.google.firebase.firestore.model.ObjectValue;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.MutationBatch;
import com.google.firebase.firestore.proto.MaybeDocument;
import com.google.firebase.firestore.proto.NoDocument;
import com.google.firebase.firestore.proto.Target;
import com.google.firebase.firestore.proto.UnknownDocument;
import com.google.firebase.firestore.proto.WriteBatch;
import com.google.firebase.firestore.remote.RemoteSerializer;
import com.google.firebase.firestore.util.Assert;
import com.google.firestore.bundle.BundledQuery;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.DocumentTransform;
import com.google.firestore.v1.Target;
import com.google.firestore.v1.Write;
import com.google.protobuf.ByteString;
import java.util.ArrayList;

public final class LocalSerializer {
    private final RemoteSerializer rpcSerializer;

    public LocalSerializer(RemoteSerializer rpcSerializer) {
        this.rpcSerializer = rpcSerializer;
    }

    MaybeDocument encodeMaybeDocument(MutableDocument document) {
        MaybeDocument.Builder builder = MaybeDocument.newBuilder();
        if (document.isNoDocument()) {
            builder.setNoDocument(this.encodeNoDocument(document));
        } else if (document.isFoundDocument()) {
            builder.setDocument(this.encodeDocument(document));
        } else if (document.isUnknownDocument()) {
            builder.setUnknownDocument(this.encodeUnknownDocument(document));
        } else {
            throw Assert.fail("Cannot encode invalid document %s", document);
        }
        builder.setHasCommittedMutations(document.hasCommittedMutations());
        return (MaybeDocument)builder.build();
    }

    MutableDocument decodeMaybeDocument(MaybeDocument proto) {
        switch (proto.getDocumentTypeCase()) {
            case DOCUMENT: {
                return this.decodeDocument(proto.getDocument(), proto.getHasCommittedMutations());
            }
            case NO_DOCUMENT: {
                return this.decodeNoDocument(proto.getNoDocument(), proto.getHasCommittedMutations());
            }
            case UNKNOWN_DOCUMENT: {
                return this.decodeUnknownDocument(proto.getUnknownDocument());
            }
        }
        throw Assert.fail("Unknown MaybeDocument %s", proto);
    }

    private Document encodeDocument(MutableDocument document) {
        Document.Builder builder = Document.newBuilder();
        builder.setName(this.rpcSerializer.encodeKey(document.getKey()));
        builder.putAllFields(document.getData().getFieldsMap());
        Timestamp updateTime = document.getVersion().getTimestamp();
        builder.setUpdateTime(this.rpcSerializer.encodeTimestamp(updateTime));
        return (Document)builder.build();
    }

    private MutableDocument decodeDocument(Document document, boolean hasCommittedMutations) {
        DocumentKey key = this.rpcSerializer.decodeKey(document.getName());
        SnapshotVersion version = this.rpcSerializer.decodeVersion(document.getUpdateTime());
        MutableDocument result = MutableDocument.newFoundDocument(key, version, ObjectValue.fromMap(document.getFieldsMap()));
        return hasCommittedMutations ? result.setHasCommittedMutations() : result;
    }

    private NoDocument encodeNoDocument(MutableDocument document) {
        NoDocument.Builder builder = NoDocument.newBuilder();
        builder.setName(this.rpcSerializer.encodeKey(document.getKey()));
        builder.setReadTime(this.rpcSerializer.encodeTimestamp(document.getVersion().getTimestamp()));
        return (NoDocument)builder.build();
    }

    private MutableDocument decodeNoDocument(NoDocument proto, boolean hasCommittedMutations) {
        DocumentKey key = this.rpcSerializer.decodeKey(proto.getName());
        SnapshotVersion version = this.rpcSerializer.decodeVersion(proto.getReadTime());
        MutableDocument result = MutableDocument.newNoDocument(key, version);
        return hasCommittedMutations ? result.setHasCommittedMutations() : result;
    }

    private UnknownDocument encodeUnknownDocument(MutableDocument document) {
        UnknownDocument.Builder builder = UnknownDocument.newBuilder();
        builder.setName(this.rpcSerializer.encodeKey(document.getKey()));
        builder.setVersion(this.rpcSerializer.encodeTimestamp(document.getVersion().getTimestamp()));
        return (UnknownDocument)builder.build();
    }

    private MutableDocument decodeUnknownDocument(UnknownDocument proto) {
        DocumentKey key = this.rpcSerializer.decodeKey(proto.getName());
        SnapshotVersion version = this.rpcSerializer.decodeVersion(proto.getVersion());
        return MutableDocument.newUnknownDocument(key, version);
    }

    WriteBatch encodeMutationBatch(MutationBatch batch) {
        WriteBatch.Builder result = WriteBatch.newBuilder();
        result.setBatchId(batch.getBatchId());
        result.setLocalWriteTime(this.rpcSerializer.encodeTimestamp(batch.getLocalWriteTime()));
        for (Mutation mutation : batch.getBaseMutations()) {
            result.addBaseWrites(this.rpcSerializer.encodeMutation(mutation));
        }
        for (Mutation mutation : batch.getMutations()) {
            result.addWrites(this.rpcSerializer.encodeMutation(mutation));
        }
        return (WriteBatch)result.build();
    }

    MutationBatch decodeMutationBatch(WriteBatch batch) {
        int batchId = batch.getBatchId();
        Timestamp localWriteTime = this.rpcSerializer.decodeTimestamp(batch.getLocalWriteTime());
        int baseMutationsCount = batch.getBaseWritesCount();
        ArrayList<Mutation> baseMutations = new ArrayList<Mutation>(baseMutationsCount);
        for (int i = 0; i < baseMutationsCount; ++i) {
            baseMutations.add(this.rpcSerializer.decodeMutation(batch.getBaseWrites(i)));
        }
        ArrayList<Mutation> mutations = new ArrayList<Mutation>(batch.getWritesCount());
        for (int i = 0; i < batch.getWritesCount(); ++i) {
            boolean hasTransform;
            Write currentMutation = batch.getWrites(i);
            boolean bl = hasTransform = i + 1 < batch.getWritesCount() && batch.getWrites(i + 1).hasTransform();
            if (hasTransform) {
                Assert.hardAssert(batch.getWrites(i).hasUpdate(), "TransformMutation should be preceded by a patch or set mutation", new Object[0]);
                Write.Builder newMutationBuilder = Write.newBuilder(currentMutation);
                Write transformMutation = batch.getWrites(i + 1);
                for (DocumentTransform.FieldTransform fieldTransform : transformMutation.getTransform().getFieldTransformsList()) {
                    newMutationBuilder.addUpdateTransforms(fieldTransform);
                }
                mutations.add(this.rpcSerializer.decodeMutation((Write)newMutationBuilder.build()));
                ++i;
                continue;
            }
            mutations.add(this.rpcSerializer.decodeMutation(currentMutation));
        }
        return new MutationBatch(batchId, localWriteTime, baseMutations, mutations);
    }

    com.google.firebase.firestore.proto.Target encodeTargetData(TargetData targetData) {
        Assert.hardAssert(QueryPurpose.LISTEN.equals((Object)targetData.getPurpose()), "Only queries with purpose %s may be stored, got %s", new Object[]{QueryPurpose.LISTEN, targetData.getPurpose()});
        Target.Builder result = com.google.firebase.firestore.proto.Target.newBuilder();
        result.setTargetId(targetData.getTargetId()).setLastListenSequenceNumber(targetData.getSequenceNumber()).setLastLimboFreeSnapshotVersion(this.rpcSerializer.encodeVersion(targetData.getLastLimboFreeSnapshotVersion())).setSnapshotVersion(this.rpcSerializer.encodeVersion(targetData.getSnapshotVersion())).setResumeToken(targetData.getResumeToken());
        Target target = targetData.getTarget();
        if (target.isDocumentQuery()) {
            result.setDocuments(this.rpcSerializer.encodeDocumentsTarget(target));
        } else {
            result.setQuery(this.rpcSerializer.encodeQueryTarget(target));
        }
        return (com.google.firebase.firestore.proto.Target)result.build();
    }

    TargetData decodeTargetData(com.google.firebase.firestore.proto.Target targetProto) {
        Target target;
        int targetId = targetProto.getTargetId();
        SnapshotVersion version = this.rpcSerializer.decodeVersion(targetProto.getSnapshotVersion());
        SnapshotVersion lastLimboFreeSnapshotVersion = this.rpcSerializer.decodeVersion(targetProto.getLastLimboFreeSnapshotVersion());
        ByteString resumeToken = targetProto.getResumeToken();
        long sequenceNumber = targetProto.getLastListenSequenceNumber();
        switch (targetProto.getTargetTypeCase()) {
            case DOCUMENTS: {
                target = this.rpcSerializer.decodeDocumentsTarget(targetProto.getDocuments());
                break;
            }
            case QUERY: {
                target = this.rpcSerializer.decodeQueryTarget(targetProto.getQuery());
                break;
            }
            default: {
                throw Assert.fail("Unknown targetType %d", new Object[]{targetProto.getTargetTypeCase()});
            }
        }
        return new TargetData(target, targetId, sequenceNumber, QueryPurpose.LISTEN, version, lastLimboFreeSnapshotVersion, resumeToken);
    }

    public BundledQuery encodeBundledQuery(com.google.firebase.firestore.bundle.BundledQuery bundledQuery) {
        Target.QueryTarget queryTarget = this.rpcSerializer.encodeQueryTarget(bundledQuery.getTarget());
        BundledQuery.Builder result = BundledQuery.newBuilder();
        result.setLimitType(bundledQuery.getLimitType().equals((Object)Query.LimitType.LIMIT_TO_FIRST) ? BundledQuery.LimitType.FIRST : BundledQuery.LimitType.LAST);
        result.setParent(queryTarget.getParent());
        result.setStructuredQuery(queryTarget.getStructuredQuery());
        return (BundledQuery)result.build();
    }

    public com.google.firebase.firestore.bundle.BundledQuery decodeBundledQuery(BundledQuery bundledQuery) {
        Query.LimitType limitType = bundledQuery.getLimitType().equals((Object)BundledQuery.LimitType.FIRST) ? Query.LimitType.LIMIT_TO_FIRST : Query.LimitType.LIMIT_TO_LAST;
        Target target = this.rpcSerializer.decodeQueryTarget(bundledQuery.getParent(), bundledQuery.getStructuredQuery());
        return new com.google.firebase.firestore.bundle.BundledQuery(target, limitType);
    }
}

