/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.util.Util;
import java.util.Comparator;

class DocumentReference {
    private final DocumentKey key;
    private final int targetOrBatchId;
    static final Comparator<DocumentReference> BY_KEY = (o1, o2) -> {
        int keyComp = o1.key.compareTo(o2.key);
        if (keyComp != 0) {
            return keyComp;
        }
        return Util.compareIntegers(o1.targetOrBatchId, o2.targetOrBatchId);
    };
    static final Comparator<DocumentReference> BY_TARGET = (o1, o2) -> {
        int targetComp = Util.compareIntegers(o1.targetOrBatchId, o2.targetOrBatchId);
        if (targetComp != 0) {
            return targetComp;
        }
        return o1.key.compareTo(o2.key);
    };

    public DocumentReference(DocumentKey key, int targetOrBatchId) {
        this.key = key;
        this.targetOrBatchId = targetOrBatchId;
    }

    DocumentKey getKey() {
        return this.key;
    }

    int getId() {
        return this.targetOrBatchId;
    }
}

