/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import com.google.firebase.firestore.core.ArrayContainsAnyFilter;
import com.google.firebase.firestore.core.ArrayContainsFilter;
import com.google.firebase.firestore.core.Filter;
import com.google.firebase.firestore.core.InFilter;
import com.google.firebase.firestore.core.KeyFieldFilter;
import com.google.firebase.firestore.core.KeyFieldInFilter;
import com.google.firebase.firestore.core.KeyFieldNotInFilter;
import com.google.firebase.firestore.core.NotInFilter;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.Values;
import com.google.firebase.firestore.util.Assert;
import com.google.firestore.v1.Value;
import java.util.Arrays;

public class FieldFilter
extends Filter {
    private final Filter.Operator operator;
    private final Value value;
    private final FieldPath field;

    protected FieldFilter(FieldPath field, Filter.Operator operator, Value value) {
        this.field = field;
        this.operator = operator;
        this.value = value;
    }

    public Filter.Operator getOperator() {
        return this.operator;
    }

    @Override
    public FieldPath getField() {
        return this.field;
    }

    public Value getValue() {
        return this.value;
    }

    public static FieldFilter create(FieldPath path, Filter.Operator operator, Value value) {
        if (path.isKeyField()) {
            if (operator == Filter.Operator.IN) {
                return new KeyFieldInFilter(path, value);
            }
            if (operator == Filter.Operator.NOT_IN) {
                return new KeyFieldNotInFilter(path, value);
            }
            Assert.hardAssert(operator != Filter.Operator.ARRAY_CONTAINS && operator != Filter.Operator.ARRAY_CONTAINS_ANY, operator.toString() + "queries don't make sense on document keys", new Object[0]);
            return new KeyFieldFilter(path, operator, value);
        }
        if (operator == Filter.Operator.ARRAY_CONTAINS) {
            return new ArrayContainsFilter(path, value);
        }
        if (operator == Filter.Operator.IN) {
            return new InFilter(path, value);
        }
        if (operator == Filter.Operator.ARRAY_CONTAINS_ANY) {
            return new ArrayContainsAnyFilter(path, value);
        }
        if (operator == Filter.Operator.NOT_IN) {
            return new NotInFilter(path, value);
        }
        return new FieldFilter(path, operator, value);
    }

    @Override
    public boolean matches(Document doc) {
        Value other = doc.getField(this.field);
        if (this.operator == Filter.Operator.NOT_EQUAL) {
            return other != null && this.matchesComparison(Values.compare(other, this.value));
        }
        return other != null && Values.typeOrder(other) == Values.typeOrder(this.value) && this.matchesComparison(Values.compare(other, this.value));
    }

    protected boolean matchesComparison(int comp) {
        switch (this.operator) {
            case LESS_THAN: {
                return comp < 0;
            }
            case LESS_THAN_OR_EQUAL: {
                return comp <= 0;
            }
            case EQUAL: {
                return comp == 0;
            }
            case NOT_EQUAL: {
                return comp != 0;
            }
            case GREATER_THAN: {
                return comp > 0;
            }
            case GREATER_THAN_OR_EQUAL: {
                return comp >= 0;
            }
        }
        throw Assert.fail("Unknown FieldFilter operator: %s", new Object[]{this.operator});
    }

    public boolean isInequality() {
        return Arrays.asList(Filter.Operator.LESS_THAN, Filter.Operator.LESS_THAN_OR_EQUAL, Filter.Operator.GREATER_THAN, Filter.Operator.GREATER_THAN_OR_EQUAL, Filter.Operator.NOT_EQUAL, Filter.Operator.NOT_IN).contains((Object)this.operator);
    }

    @Override
    public String getCanonicalId() {
        return this.getField().canonicalString() + this.getOperator().toString() + Values.canonicalId(this.getValue());
    }

    public String toString() {
        return this.field.canonicalString() + " " + (Object)((Object)this.operator) + " " + Values.canonicalId(this.value);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof FieldFilter)) {
            return false;
        }
        FieldFilter other = (FieldFilter)o;
        return this.operator == other.operator && this.field.equals(other.field) && this.value.equals(other.value);
    }

    public int hashCode() {
        int result = 37;
        result = 31 * result + this.operator.hashCode();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }
}

