/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.index;

import com.google.firebase.firestore.index.DirectionalIndexByteEncoder;
import com.google.firebase.firestore.index.OrderedCodeWriter;
import com.google.protobuf.ByteString;

public class IndexByteEncoder
extends DirectionalIndexByteEncoder {
    private final OrderedCodeWriter orderedCode = new OrderedCodeWriter();

    public void seed(byte[] encodedBytes) {
        this.orderedCode.seed(encodedBytes);
    }

    @Override
    public void writeBytes(ByteString val) {
        this.orderedCode.writeBytesAscending(val);
    }

    @Override
    public void writeString(String val) {
        this.orderedCode.writeUtf8Ascending(val);
    }

    @Override
    public void writeLong(long val) {
        this.orderedCode.writeSignedLongAscending(val);
    }

    @Override
    public void writeDouble(double val) {
        this.orderedCode.writeDoubleAscending(val);
    }

    public byte[] getEncodedBytes() {
        return this.orderedCode.encodedBytes();
    }

    public void reset() {
        this.orderedCode.reset();
    }
}

