/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.util;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.Continuation;
import com.google.cloud.datastore.core.number.NumberComparisonHelper;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;

public class Util {
    private static final int AUTO_ID_LENGTH = 20;
    private static final String AUTO_ID_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static final Random rand = new SecureRandom();
    private static final Comparator COMPARABLE_COMPARATOR = new Comparator<Comparable<?>>(){

        @Override
        public int compare(Comparable left, Comparable right) {
            return left.compareTo(right);
        }
    };
    private static final Continuation<Void, Void> VOID_ERROR_TRANSFORMER = task -> {
        if (task.isSuccessful()) {
            return (Void)task.getResult();
        }
        Exception e = Util.convertStatusException(task.getException());
        if (e instanceof FirebaseFirestoreException) {
            throw e;
        }
        throw new FirebaseFirestoreException(e.getMessage(), FirebaseFirestoreException.Code.UNKNOWN, e);
    };

    public static String autoId() {
        StringBuilder builder = new StringBuilder();
        int maxRandom = AUTO_ID_ALPHABET.length();
        for (int i = 0; i < 20; ++i) {
            builder.append(AUTO_ID_ALPHABET.charAt(rand.nextInt(maxRandom)));
        }
        return builder.toString();
    }

    public static int compareBooleans(boolean b1, boolean b2) {
        if (b1 == b2) {
            return 0;
        }
        if (b1) {
            return 1;
        }
        return -1;
    }

    public static int compareIntegers(int i1, int i2) {
        if (i1 < i2) {
            return -1;
        }
        if (i1 > i2) {
            return 1;
        }
        return 0;
    }

    public static int compareLongs(long i1, long i2) {
        return NumberComparisonHelper.compareLongs(i1, i2);
    }

    public static int compareDoubles(double i1, double i2) {
        return NumberComparisonHelper.firestoreCompareDoubles(i1, i2);
    }

    public static int compareMixed(double doubleValue, long longValue) {
        return NumberComparisonHelper.firestoreCompareDoubleWithLong(doubleValue, longValue);
    }

    public static <T extends Comparable<T>> Comparator<T> comparator() {
        return COMPARABLE_COMPARATOR;
    }

    public static FirebaseFirestoreException exceptionFromStatus(Status error) {
        StatusException statusException = error.asException();
        return new FirebaseFirestoreException(statusException.getMessage(), FirebaseFirestoreException.Code.fromValue(error.getCode().value()), (Throwable)statusException);
    }

    private static Exception convertStatusException(Exception e) {
        if (e instanceof StatusException) {
            StatusException statusException = (StatusException)e;
            return Util.exceptionFromStatus(statusException.getStatus());
        }
        if (e instanceof StatusRuntimeException) {
            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)e;
            return Util.exceptionFromStatus(statusRuntimeException.getStatus());
        }
        return e;
    }

    public static Exception convertThrowableToException(Throwable t) {
        if (t instanceof Exception) {
            return Util.convertStatusException((Exception)t);
        }
        return new Exception(t);
    }

    public static Continuation<Void, Void> voidErrorTransformer() {
        return VOID_ERROR_TRANSFORMER;
    }

    public static List<Object> collectUpdateArguments(int fieldPathOffset, Object field, Object val, Object ... fieldsAndValues) {
        if (fieldsAndValues.length % 2 == 1) {
            throw new IllegalArgumentException("Missing value in call to update().  There must be an even number of arguments that alternate between field names and values");
        }
        ArrayList<Object> argumentList = new ArrayList<Object>();
        argumentList.add(field);
        argumentList.add(val);
        Collections.addAll(argumentList, fieldsAndValues);
        for (int i = 0; i < argumentList.size(); i += 2) {
            Object fieldPath = argumentList.get(i);
            if (fieldPath instanceof String || fieldPath instanceof FieldPath) continue;
            throw new IllegalArgumentException("Excepted field name at argument position " + (i + fieldPathOffset + 1) + " but got " + fieldPath + " in call to update.  The arguments to update should alternate between field names and values");
        }
        return argumentList;
    }

    public static String toDebugString(ByteString bytes) {
        int size = bytes.size();
        StringBuilder result = new StringBuilder(2 * size);
        for (int i = 0; i < size; ++i) {
            int value = bytes.byteAt(i) & 0xFF;
            result.append(Character.forDigit(value >>> 4, 16));
            result.append(Character.forDigit(value & 0xF, 16));
        }
        return result.toString();
    }

    public static String typeName(@Nullable Object obj) {
        return obj == null ? "null" : obj.getClass().getName();
    }

    public static void crashMainThread(RuntimeException exception) {
        new Handler(Looper.getMainLooper()).post(() -> {
            throw exception;
        });
    }

    public static int compareByteStrings(ByteString left, ByteString right) {
        int size = Math.min(left.size(), right.size());
        for (int i = 0; i < size; ++i) {
            int otherByte;
            int thisByte = left.byteAt(i) & 0xFF;
            if (thisByte < (otherByte = right.byteAt(i) & 0xFF)) {
                return -1;
            }
            if (thisByte <= otherByte) continue;
            return 1;
        }
        return Util.compareIntegers(left.size(), right.size());
    }

    public static String repeatSequence(CharSequence sequence, int count, CharSequence delimiter) {
        if (count == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(sequence);
        for (int i = 1; i < count; ++i) {
            sb.append(delimiter);
            sb.append(sequence);
        }
        return sb.toString();
    }
}

