/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.core.FieldFilter;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class Filter {
    private final FieldPath field;
    private final FieldFilter.Operator operator;
    private final Object value;

    private Filter(@NonNull FieldPath field, FieldFilter.Operator operator, Object value) {
        this.field = field;
        this.operator = operator;
        this.value = value;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public FieldPath getField() {
        return this.field;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public FieldFilter.Operator getOperator() {
        return this.operator;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Object getValue() {
        return this.value;
    }

    @NonNull
    public static Filter equalTo(@NonNull String field, @Nullable Object value) {
        return Filter.equalTo(FieldPath.fromDotSeparatedPath(field), value);
    }

    @NonNull
    public static Filter equalTo(@NonNull FieldPath fieldPath, @Nullable Object value) {
        return new Filter(fieldPath, FieldFilter.Operator.EQUAL, value);
    }

    @NonNull
    public static Filter notEqualTo(@NonNull String field, @Nullable Object value) {
        return Filter.notEqualTo(FieldPath.fromDotSeparatedPath(field), value);
    }

    @NonNull
    public static Filter notEqualTo(@NonNull FieldPath fieldPath, @Nullable Object value) {
        return new Filter(fieldPath, FieldFilter.Operator.NOT_EQUAL, value);
    }

    @NonNull
    public static Filter greaterThan(@NonNull String field, @Nullable Object value) {
        return Filter.greaterThan(FieldPath.fromDotSeparatedPath(field), value);
    }

    @NonNull
    public static Filter greaterThan(@NonNull FieldPath fieldPath, @Nullable Object value) {
        return new Filter(fieldPath, FieldFilter.Operator.GREATER_THAN, value);
    }

    @NonNull
    public static Filter greaterThanOrEqualTo(@NonNull String field, @Nullable Object value) {
        return Filter.greaterThanOrEqualTo(FieldPath.fromDotSeparatedPath(field), value);
    }

    @NonNull
    public static Filter greaterThanOrEqualTo(@NonNull FieldPath fieldPath, @Nullable Object value) {
        return new Filter(fieldPath, FieldFilter.Operator.GREATER_THAN_OR_EQUAL, value);
    }

    @NonNull
    public static Filter lessThan(@NonNull String field, @Nullable Object value) {
        return Filter.lessThan(FieldPath.fromDotSeparatedPath(field), value);
    }

    @NonNull
    public static Filter lessThan(@NonNull FieldPath fieldPath, @Nullable Object value) {
        return new Filter(fieldPath, FieldFilter.Operator.LESS_THAN, value);
    }

    @NonNull
    public static Filter lessThanOrEqualTo(@NonNull String field, @Nullable Object value) {
        return Filter.lessThanOrEqualTo(FieldPath.fromDotSeparatedPath(field), value);
    }

    @NonNull
    public static Filter lessThanOrEqualTo(@NonNull FieldPath fieldPath, @Nullable Object value) {
        return new Filter(fieldPath, FieldFilter.Operator.LESS_THAN_OR_EQUAL, value);
    }

    @NonNull
    public static Filter arrayContains(@NonNull String field, @Nullable Object value) {
        return Filter.arrayContains(FieldPath.fromDotSeparatedPath(field), value);
    }

    @NonNull
    public static Filter arrayContains(@NonNull FieldPath fieldPath, @Nullable Object value) {
        return new Filter(fieldPath, FieldFilter.Operator.ARRAY_CONTAINS, value);
    }

    @NonNull
    public static Filter arrayContainsAny(@NonNull String field, @Nullable Object value) {
        return Filter.arrayContainsAny(FieldPath.fromDotSeparatedPath(field), value);
    }

    @NonNull
    public static Filter arrayContainsAny(@NonNull FieldPath fieldPath, @Nullable Object value) {
        return new Filter(fieldPath, FieldFilter.Operator.ARRAY_CONTAINS_ANY, value);
    }

    @NonNull
    public static Filter inArray(@NonNull String field, @Nullable Object value) {
        return Filter.inArray(FieldPath.fromDotSeparatedPath(field), value);
    }

    @NonNull
    public static Filter inArray(@NonNull FieldPath fieldPath, @Nullable Object value) {
        return new Filter(fieldPath, FieldFilter.Operator.IN, value);
    }

    @NonNull
    public static Filter notInArray(@NonNull String field, @Nullable Object value) {
        return Filter.notInArray(FieldPath.fromDotSeparatedPath(field), value);
    }

    @NonNull
    public static Filter notInArray(@NonNull FieldPath fieldPath, @Nullable Object value) {
        return new Filter(fieldPath, FieldFilter.Operator.NOT_IN, value);
    }
}

