/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.index;

import com.google.auto.value.AutoValue;
import com.google.firebase.firestore.index.AutoValue_IndexEntry;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.util.Util;

@AutoValue
public abstract class IndexEntry
implements Comparable<IndexEntry> {
    public static IndexEntry create(int indexId, DocumentKey documentKey, byte[] arrayValue, byte[] directionalValue) {
        return new AutoValue_IndexEntry(indexId, documentKey, arrayValue, directionalValue);
    }

    public abstract int getIndexId();

    public abstract DocumentKey getDocumentKey();

    public abstract byte[] getArrayValue();

    public abstract byte[] getDirectionalValue();

    @Override
    public int compareTo(IndexEntry other) {
        int cmp = Integer.compare(this.getIndexId(), other.getIndexId());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getDocumentKey().compareTo(other.getDocumentKey());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Util.compareByteArrays(this.getDirectionalValue(), other.getDirectionalValue());
        if (cmp != 0) {
            return cmp;
        }
        return Util.nullSafeCompare(this.getArrayValue(), other.getArrayValue(), Util::compareByteArrays);
    }
}

