/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.firestore.local.IndexManager;
import com.google.firebase.firestore.local.LocalDocumentsView;
import com.google.firebase.firestore.local.Persistence;
import com.google.firebase.firestore.local.RemoteDocumentCache;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldIndex;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.AsyncQueue;
import com.google.firebase.firestore.util.Logger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class IndexBackfiller {
    private static final String LOG_TAG = "IndexBackfiller";
    private static final long INITIAL_BACKFILL_DELAY_MS = TimeUnit.SECONDS.toMillis(15L);
    private static final long REGULAR_BACKFILL_DELAY_MS = TimeUnit.MINUTES.toMillis(1L);
    private static final int MAX_DOCUMENTS_TO_PROCESS = 50;
    private final Scheduler scheduler;
    private final Persistence persistence;
    private final RemoteDocumentCache remoteDocumentCache;
    private LocalDocumentsView localDocumentsView;
    private IndexManager indexManager;
    private int maxDocumentsToProcess = 50;

    public IndexBackfiller(Persistence persistence, AsyncQueue asyncQueue) {
        this.persistence = persistence;
        this.scheduler = new Scheduler(asyncQueue);
        this.remoteDocumentCache = persistence.getRemoteDocumentCache();
    }

    public void setLocalDocumentsView(LocalDocumentsView localDocumentsView) {
        this.localDocumentsView = localDocumentsView;
    }

    public void setIndexManager(IndexManager indexManager) {
        this.indexManager = indexManager;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public int backfill() {
        Assert.hardAssert(this.localDocumentsView != null, "setLocalDocumentsView() not called", new Object[0]);
        Assert.hardAssert(this.indexManager != null, "setIndexManager() not called", new Object[0]);
        return this.persistence.runTransaction("Backfill Indexes", () -> this.writeIndexEntries(this.localDocumentsView));
    }

    private int writeIndexEntries(LocalDocumentsView localDocumentsView) {
        int documentsRemaining;
        String collectionGroup;
        HashSet<String> processedCollectionGroups = new HashSet<String>();
        for (documentsRemaining = this.maxDocumentsToProcess; documentsRemaining > 0 && (collectionGroup = this.indexManager.getNextCollectionGroupToUpdate()) != null && !processedCollectionGroups.contains(collectionGroup); documentsRemaining -= this.writeEntriesForCollectionGroup(localDocumentsView, collectionGroup, documentsRemaining)) {
            Logger.debug(LOG_TAG, "Processing collection: %s", collectionGroup);
            processedCollectionGroups.add(collectionGroup);
        }
        return this.maxDocumentsToProcess - documentsRemaining;
    }

    private int writeEntriesForCollectionGroup(LocalDocumentsView localDocumentsView, String collectionGroup, int entriesRemainingUnderCap) {
        FieldIndex.IndexOffset existingOffset = this.getExistingOffset(this.indexManager.getFieldIndexes(collectionGroup));
        ImmutableSortedMap<DocumentKey, Document> documents = localDocumentsView.getDocuments(collectionGroup, existingOffset, entriesRemainingUnderCap);
        this.indexManager.updateIndexEntries(documents);
        FieldIndex.IndexOffset newOffset = this.getNewOffset(documents, existingOffset);
        this.indexManager.updateCollectionGroup(collectionGroup, newOffset);
        return documents.size();
    }

    private FieldIndex.IndexOffset getExistingOffset(Collection<FieldIndex> fieldIndexes) {
        FieldIndex.IndexOffset lowestOffset = null;
        for (FieldIndex fieldIndex : fieldIndexes) {
            if (lowestOffset != null && fieldIndex.getIndexState().getOffset().compareTo(lowestOffset) >= 0) continue;
            lowestOffset = fieldIndex.getIndexState().getOffset();
        }
        return lowestOffset == null ? FieldIndex.IndexOffset.NONE : lowestOffset;
    }

    private FieldIndex.IndexOffset getNewOffset(ImmutableSortedMap<DocumentKey, Document> documents, FieldIndex.IndexOffset currentOffset) {
        if (documents.isEmpty()) {
            return FieldIndex.IndexOffset.create(this.remoteDocumentCache.getLatestReadTime());
        }
        FieldIndex.IndexOffset latestOffset = currentOffset;
        Iterator it = documents.iterator();
        while (it.hasNext()) {
            FieldIndex.IndexOffset newOffset = FieldIndex.IndexOffset.fromDocument((Document)((Map.Entry)it.next()).getValue());
            if (newOffset.compareTo(latestOffset) <= 0) continue;
            latestOffset = newOffset;
        }
        return latestOffset;
    }

    @VisibleForTesting
    void setMaxDocumentsToProcess(int newMax) {
        this.maxDocumentsToProcess = newMax;
    }

    public class Scheduler
    implements com.google.firebase.firestore.local.Scheduler {
        private boolean hasRun = false;
        @Nullable
        private AsyncQueue.DelayedTask backfillTask;
        private final AsyncQueue asyncQueue;

        public Scheduler(AsyncQueue asyncQueue) {
            this.asyncQueue = asyncQueue;
        }

        @Override
        public void start() {
            Assert.hardAssert(Persistence.INDEXING_SUPPORT_ENABLED, "Indexing support not enabled", new Object[0]);
            this.scheduleBackfill();
        }

        @Override
        public void stop() {
            Assert.hardAssert(Persistence.INDEXING_SUPPORT_ENABLED, "Indexing support not enabled", new Object[0]);
            if (this.backfillTask != null) {
                this.backfillTask.cancel();
            }
        }

        private void scheduleBackfill() {
            long delay = this.hasRun ? REGULAR_BACKFILL_DELAY_MS : INITIAL_BACKFILL_DELAY_MS;
            this.backfillTask = this.asyncQueue.enqueueAfterDelay(AsyncQueue.TimerId.INDEX_BACKFILL, delay, () -> {
                int documentsProcessed = IndexBackfiller.this.backfill();
                Logger.debug(IndexBackfiller.LOG_TAG, "Documents written: %s", documentsProcessed);
                this.hasRun = true;
                this.scheduleBackfill();
            });
        }
    }
}

