/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import android.util.Pair;
import androidx.annotation.Nullable;
import com.google.firebase.firestore.local.DocumentOverlayCache;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.model.mutation.Mutation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class MemoryDocumentOverlayCache
implements DocumentOverlayCache {
    private final TreeMap<DocumentKey, Pair<Integer, Mutation>> overlays = new TreeMap();
    private final Map<Integer, Set<DocumentKey>> overlayByBatchId = new HashMap<Integer, Set<DocumentKey>>();

    @Override
    @Nullable
    public Mutation getOverlay(DocumentKey key) {
        Pair<Integer, Mutation> overlay = this.overlays.get(key);
        if (overlay != null) {
            return (Mutation)overlay.second;
        }
        return null;
    }

    private void saveOverlay(int largestBatchId, @Nullable Mutation mutation) {
        if (mutation == null) {
            return;
        }
        Pair<Integer, Mutation> existing = this.overlays.get(mutation.getKey());
        if (existing != null) {
            this.overlayByBatchId.get(existing.first).remove(mutation.getKey());
        }
        this.overlays.put(mutation.getKey(), (Pair<Integer, Mutation>)new Pair((Object)largestBatchId, (Object)mutation));
        if (this.overlayByBatchId.get(largestBatchId) == null) {
            this.overlayByBatchId.put(largestBatchId, new HashSet());
        }
        this.overlayByBatchId.get(largestBatchId).add(mutation.getKey());
    }

    @Override
    public void saveOverlays(int largestBatchId, Map<DocumentKey, Mutation> overlays) {
        for (Map.Entry<DocumentKey, Mutation> entry : overlays.entrySet()) {
            this.saveOverlay(largestBatchId, entry.getValue());
        }
    }

    @Override
    public void removeOverlaysForBatchId(int batchId) {
        if (this.overlayByBatchId.containsKey(batchId)) {
            Set<DocumentKey> keys = this.overlayByBatchId.get(batchId);
            this.overlayByBatchId.remove(batchId);
            for (DocumentKey key : keys) {
                this.overlays.remove(key);
            }
        }
    }

    @Override
    public Map<DocumentKey, Mutation> getOverlays(ResourcePath collection, int sinceBatchId) {
        Map.Entry entry;
        DocumentKey key;
        HashMap<DocumentKey, Mutation> result = new HashMap<DocumentKey, Mutation>();
        int immediateChildrenPathLength = collection.length() + 1;
        DocumentKey prefix = DocumentKey.fromPath((ResourcePath)((Object)collection.append("")));
        SortedMap<DocumentKey, Pair<Integer, Mutation>> view = this.overlays.tailMap(prefix);
        Iterator iterator = view.entrySet().iterator();
        while (iterator.hasNext() && collection.isPrefixOf((key = (DocumentKey)(entry = iterator.next()).getKey()).getPath())) {
            if (key.getPath().length() != immediateChildrenPathLength) continue;
            Pair batchIdToOverlay = (Pair)entry.getValue();
            if ((Integer)batchIdToOverlay.first <= sinceBatchId) continue;
            result.put((DocumentKey)entry.getKey(), (Mutation)batchIdToOverlay.second);
        }
        return result;
    }
}

