/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.database.collection.ImmutableSortedSet;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.core.Target;
import com.google.firebase.firestore.local.IndexManager;
import com.google.firebase.firestore.local.LocalDocumentsView;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldIndex;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Logger;
import com.google.firebase.firestore.util.Util;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class QueryEngine {
    private static final String LOG_TAG = "QueryEngine";
    private LocalDocumentsView localDocumentsView;
    private IndexManager indexManager;
    private boolean initialized;

    public void initialize(LocalDocumentsView localDocumentsView, IndexManager indexManager) {
        this.localDocumentsView = localDocumentsView;
        this.indexManager = indexManager;
        this.initialized = true;
    }

    public ImmutableSortedMap<DocumentKey, Document> getDocumentsMatchingQuery(Query query, SnapshotVersion lastLimboFreeSnapshotVersion, ImmutableSortedSet<DocumentKey> remoteKeys) {
        Assert.hardAssert(this.initialized, "initialize() not called", new Object[0]);
        ImmutableSortedMap<DocumentKey, Document> result = this.performQueryUsingIndex(query, query.toTarget());
        if (result != null) {
            return result;
        }
        result = this.performQueryUsingRemoteKeys(query, remoteKeys, lastLimboFreeSnapshotVersion);
        if (result != null) {
            return result;
        }
        return this.executeFullCollectionScan(query);
    }

    @Nullable
    private ImmutableSortedMap<DocumentKey, Document> performQueryUsingIndex(Query query, Target target) {
        if (query.matchesAllDocuments()) {
            return null;
        }
        FieldIndex fieldIndex = this.indexManager.getFieldIndex(query.toTarget());
        if (fieldIndex == null) {
            return null;
        }
        Set<DocumentKey> keys = this.indexManager.getDocumentsMatchingTarget(fieldIndex, target);
        ImmutableSortedMap<DocumentKey, Document> indexedDocuments = this.localDocumentsView.getDocuments(keys);
        return this.appendRemainingResults(Util.values(indexedDocuments), query, fieldIndex.getIndexState().getOffset());
    }

    @Nullable
    private ImmutableSortedMap<DocumentKey, Document> performQueryUsingRemoteKeys(Query query, ImmutableSortedSet<DocumentKey> remoteKeys, SnapshotVersion lastLimboFreeSnapshotVersion) {
        if (query.matchesAllDocuments()) {
            return null;
        }
        if (lastLimboFreeSnapshotVersion.equals(SnapshotVersion.NONE)) {
            return null;
        }
        ImmutableSortedMap<DocumentKey, Document> documents = this.localDocumentsView.getDocuments((Iterable<DocumentKey>)remoteKeys);
        ImmutableSortedSet<Document> previousResults = this.applyQuery(query, documents);
        if ((query.hasLimitToFirst() || query.hasLimitToLast()) && this.needsRefill(query.getLimitType(), previousResults, remoteKeys, lastLimboFreeSnapshotVersion)) {
            return null;
        }
        if (Logger.isDebugEnabled()) {
            Logger.debug(LOG_TAG, "Re-using previous result from %s to execute query: %s", lastLimboFreeSnapshotVersion.toString(), query.toString());
        }
        return this.appendRemainingResults((Iterable<Document>)previousResults, query, FieldIndex.IndexOffset.create(lastLimboFreeSnapshotVersion));
    }

    private ImmutableSortedSet<Document> applyQuery(Query query, ImmutableSortedMap<DocumentKey, Document> documents) {
        ImmutableSortedSet queryResults = new ImmutableSortedSet(Collections.emptyList(), query.comparator());
        for (Map.Entry entry : documents) {
            Document document = (Document)entry.getValue();
            if (!query.matches(document)) continue;
            queryResults = queryResults.insert((Object)document);
        }
        return queryResults;
    }

    private boolean needsRefill(Query.LimitType limitType, ImmutableSortedSet<Document> sortedPreviousResults, ImmutableSortedSet<DocumentKey> remoteKeys, SnapshotVersion limboFreeSnapshotVersion) {
        Document documentAtLimitEdge;
        if (remoteKeys.size() != sortedPreviousResults.size()) {
            return true;
        }
        Document document = documentAtLimitEdge = limitType == Query.LimitType.LIMIT_TO_FIRST ? (Document)sortedPreviousResults.getMaxEntry() : (Document)sortedPreviousResults.getMinEntry();
        if (documentAtLimitEdge == null) {
            return false;
        }
        return documentAtLimitEdge.hasPendingWrites() || documentAtLimitEdge.getVersion().compareTo(limboFreeSnapshotVersion) > 0;
    }

    private ImmutableSortedMap<DocumentKey, Document> executeFullCollectionScan(Query query) {
        if (Logger.isDebugEnabled()) {
            Logger.debug(LOG_TAG, "Using full collection scan to execute query: %s", query.toString());
        }
        return this.localDocumentsView.getDocumentsMatchingQuery(query, FieldIndex.IndexOffset.NONE);
    }

    private ImmutableSortedMap<DocumentKey, Document> appendRemainingResults(Iterable<Document> indexedResults, Query query, FieldIndex.IndexOffset offset) {
        ImmutableSortedMap remainingResults = this.localDocumentsView.getDocumentsMatchingQuery(query, offset);
        for (Document entry : indexedResults) {
            remainingResults = remainingResults.insert((Object)entry.getKey(), (Object)entry);
        }
        return remainingResults;
    }
}

