/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import androidx.annotation.Nullable;
import com.google.firebase.firestore.auth.User;
import com.google.firebase.firestore.local.DocumentOverlayCache;
import com.google.firebase.firestore.local.EncodedPath;
import com.google.firebase.firestore.local.LocalSerializer;
import com.google.firebase.firestore.local.SQLitePersistence;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.util.Assert;
import com.google.firestore.v1.Write;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.HashMap;
import java.util.Map;

public class SQLiteDocumentOverlayCache
implements DocumentOverlayCache {
    private final SQLitePersistence db;
    private final LocalSerializer serializer;
    private final String uid;

    public SQLiteDocumentOverlayCache(SQLitePersistence db, LocalSerializer serializer, User user) {
        this.db = db;
        this.serializer = serializer;
        this.uid = user.isAuthenticated() ? user.getUid() : "";
    }

    @Override
    @Nullable
    public Mutation getOverlay(DocumentKey key) {
        String collectionPath = EncodedPath.encode((ResourcePath)key.getPath().popLast());
        String documentId = key.getPath().getLastSegment();
        return (Mutation)this.db.query("SELECT overlay_mutation FROM document_overlays WHERE uid = ? AND collection_path = ? AND document_id = ?").binding(this.uid, collectionPath, documentId).firstValue(row -> {
            if (row == null) {
                return null;
            }
            try {
                Write mutation = Write.parseFrom(row.getBlob(0));
                return this.serializer.decodeMutation(mutation);
            }
            catch (InvalidProtocolBufferException e) {
                throw Assert.fail("Overlay failed to parse: %s", new Object[]{e});
            }
        });
    }

    private void saveOverlay(int largestBatchId, DocumentKey key, @Nullable Mutation mutation) {
        String group = key.getCollectionGroup();
        String collectionPath = EncodedPath.encode((ResourcePath)key.getPath().popLast());
        String documentId = key.getPath().getLastSegment();
        this.db.execute("INSERT OR REPLACE INTO document_overlays (uid, collection_group, collection_path, document_id, largest_batch_id, overlay_mutation) VALUES (?, ?, ?, ?, ?, ?)", this.uid, group, collectionPath, documentId, largestBatchId, this.serializer.encodeMutation(mutation).toByteArray());
    }

    @Override
    public void saveOverlays(int largestBatchId, Map<DocumentKey, Mutation> overlays) {
        for (Map.Entry<DocumentKey, Mutation> entry : overlays.entrySet()) {
            if (entry.getValue() == null) continue;
            this.saveOverlay(largestBatchId, entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void removeOverlaysForBatchId(int batchId) {
        this.db.execute("DELETE FROM document_overlays WHERE uid = ? AND largest_batch_id = ?", this.uid, batchId);
    }

    @Override
    public Map<DocumentKey, Mutation> getOverlays(ResourcePath collection, int sinceBatchId) {
        String collectionPath = EncodedPath.encode(collection);
        HashMap<DocumentKey, Mutation> result = new HashMap<DocumentKey, Mutation>();
        this.db.query("SELECT document_id, overlay_mutation FROM document_overlays WHERE uid = ? AND collection_path = ? AND largest_batch_id > ?").binding(this.uid, collectionPath, sinceBatchId).forEach(row -> {
            try {
                String documentId = row.getString(0);
                Write write = Write.parseFrom(row.getBlob(1));
                Mutation mutation = this.serializer.decodeMutation(write);
                result.put(DocumentKey.fromPath((ResourcePath)((Object)collection.append(documentId))), mutation);
            }
            catch (InvalidProtocolBufferException e) {
                throw Assert.fail("Overlay failed to parse: %s", new Object[]{e});
            }
        });
        return result;
    }
}

