/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import androidx.annotation.Nullable;
import com.google.firebase.Timestamp;
import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.firestore.auth.User;
import com.google.firebase.firestore.core.Bound;
import com.google.firebase.firestore.core.FieldFilter;
import com.google.firebase.firestore.core.Filter;
import com.google.firebase.firestore.core.Target;
import com.google.firebase.firestore.index.DirectionalIndexByteEncoder;
import com.google.firebase.firestore.index.FirestoreIndexValueWriter;
import com.google.firebase.firestore.index.IndexByteEncoder;
import com.google.firebase.firestore.index.IndexEntry;
import com.google.firebase.firestore.local.EncodedPath;
import com.google.firebase.firestore.local.IndexManager;
import com.google.firebase.firestore.local.LocalSerializer;
import com.google.firebase.firestore.local.MemoryIndexManager;
import com.google.firebase.firestore.local.Persistence;
import com.google.firebase.firestore.local.SQLitePersistence;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldIndex;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.model.TargetIndexMatcher;
import com.google.firebase.firestore.model.Values;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Logger;
import com.google.firebase.firestore.util.Util;
import com.google.firestore.admin.v1.Index;
import com.google.firestore.v1.Value;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

final class SQLiteIndexManager
implements IndexManager {
    private static final String TAG = SQLiteIndexManager.class.getSimpleName();
    private final SQLitePersistence db;
    private final LocalSerializer serializer;
    private final String uid;
    private final MemoryIndexManager.MemoryCollectionParentIndex collectionParentsCache = new MemoryIndexManager.MemoryCollectionParentIndex();
    private final Map<String, Map<Integer, FieldIndex>> memoizedIndexes = new HashMap<String, Map<Integer, FieldIndex>>();
    private final Queue<FieldIndex> nextIndexToUpdate = new PriorityQueue<FieldIndex>(10, (l, r) -> Long.compare(l.getIndexState().getSequenceNumber(), r.getIndexState().getSequenceNumber()));
    private boolean started = false;
    private int memoizedMaxIndexId = -1;
    private long memoizedMaxSequenceNumber = -1L;

    SQLiteIndexManager(SQLitePersistence persistence, LocalSerializer serializer, User user) {
        this.db = persistence;
        this.serializer = serializer;
        this.uid = user.isAuthenticated() ? user.getUid() : "";
    }

    @Override
    public void start() {
        if (!Persistence.INDEXING_SUPPORT_ENABLED) {
            this.started = true;
            return;
        }
        HashMap indexStates = new HashMap();
        this.db.query("SELECT index_id, sequence_number, read_time_seconds, read_time_nanos, document_key FROM index_state WHERE uid = ?").binding(this.uid).forEach(row -> {
            int indexId = row.getInt(0);
            long sequenceNumber = row.getLong(1);
            SnapshotVersion readTime = new SnapshotVersion(new Timestamp(row.getLong(2), row.getInt(3)));
            DocumentKey documentKey = DocumentKey.fromPath(EncodedPath.decodeResourcePath(row.getString(4)));
            indexStates.put(indexId, FieldIndex.IndexState.create(sequenceNumber, readTime, documentKey));
        });
        this.db.query("SELECT index_id, collection_group, index_proto FROM index_configuration").forEach(row -> {
            try {
                int indexId = row.getInt(0);
                String collectionGroup = row.getString(1);
                List<FieldIndex.Segment> segments = this.serializer.decodeFieldIndexSegments(Index.parseFrom(row.getBlob(2)));
                FieldIndex.IndexState indexState = indexStates.containsKey(indexId) ? (FieldIndex.IndexState)indexStates.get(indexId) : FieldIndex.INITIAL_STATE;
                FieldIndex fieldIndex = FieldIndex.create(indexId, collectionGroup, segments, indexState);
                this.memoizeIndex(fieldIndex);
            }
            catch (InvalidProtocolBufferException e) {
                throw Assert.fail("Failed to decode index: " + (Object)((Object)e), new Object[0]);
            }
        });
        this.started = true;
    }

    @Override
    public void addToCollectionParentIndex(ResourcePath collectionPath) {
        Assert.hardAssert(this.started, "IndexManager not started", new Object[0]);
        Assert.hardAssert(collectionPath.length() % 2 == 1, "Expected a collection path.", new Object[0]);
        if (this.collectionParentsCache.add(collectionPath)) {
            String collectionId = collectionPath.getLastSegment();
            ResourcePath parentPath = (ResourcePath)collectionPath.popLast();
            this.db.execute("INSERT OR REPLACE INTO collection_parents (collection_id, parent) VALUES (?, ?)", collectionId, EncodedPath.encode(parentPath));
        }
    }

    @Override
    public List<ResourcePath> getCollectionParents(String collectionId) {
        Assert.hardAssert(this.started, "IndexManager not started", new Object[0]);
        ArrayList<ResourcePath> parentPaths = new ArrayList<ResourcePath>();
        this.db.query("SELECT parent FROM collection_parents WHERE collection_id = ?").binding(collectionId).forEach(row -> parentPaths.add(EncodedPath.decodeResourcePath(row.getString(0))));
        return parentPaths;
    }

    @Override
    public void addFieldIndex(FieldIndex index) {
        Assert.hardAssert(this.started, "IndexManager not started", new Object[0]);
        int nextIndexId = this.memoizedMaxIndexId + 1;
        index = FieldIndex.create(nextIndexId, index.getCollectionGroup(), index.getSegments(), index.getIndexState());
        this.db.execute("INSERT INTO index_configuration (index_id, collection_group, index_proto) VALUES(?, ?, ?)", nextIndexId, index.getCollectionGroup(), this.encodeSegments(index));
        this.memoizeIndex(index);
    }

    @Override
    public void deleteFieldIndex(FieldIndex index) {
        this.db.execute("DELETE FROM index_configuration WHERE index_id = ?", index.getIndexId());
        this.db.execute("DELETE FROM index_entries WHERE index_id = ?", index.getIndexId());
        this.db.execute("DELETE FROM index_state WHERE index_id = ?", index.getIndexState());
        this.nextIndexToUpdate.remove(index);
        Map<Integer, FieldIndex> collectionIndices = this.memoizedIndexes.get(index.getCollectionGroup());
        if (collectionIndices != null) {
            collectionIndices.remove(index.getIndexId());
        }
    }

    @Override
    @Nullable
    public String getNextCollectionGroupToUpdate() {
        Assert.hardAssert(this.started, "IndexManager not started", new Object[0]);
        FieldIndex nextIndex = this.nextIndexToUpdate.peek();
        return nextIndex != null ? nextIndex.getCollectionGroup() : null;
    }

    @Override
    public void updateIndexEntries(ImmutableSortedMap<DocumentKey, Document> documents) {
        Assert.hardAssert(this.started, "IndexManager not started", new Object[0]);
        if (!Persistence.INDEXING_SUPPORT_ENABLED) {
            return;
        }
        for (Map.Entry entry : documents) {
            Collection<FieldIndex> fieldIndexes = this.getFieldIndexes(((DocumentKey)entry.getKey()).getCollectionGroup());
            for (FieldIndex fieldIndex : fieldIndexes) {
                SortedSet<IndexEntry> newEntries;
                SortedSet<IndexEntry> existingEntries = this.getExistingIndexEntries((DocumentKey)entry.getKey(), fieldIndex);
                if (existingEntries.equals(newEntries = this.computeIndexEntries((Document)entry.getValue(), fieldIndex))) continue;
                this.updateEntries((Document)entry.getValue(), existingEntries, newEntries);
            }
        }
    }

    private void updateEntries(Document document, SortedSet<IndexEntry> existingEntries, SortedSet<IndexEntry> newEntries) {
        Logger.debug(TAG, "Updating index entries for document '%s'", document.getKey());
        Util.diffCollections(existingEntries, newEntries, entry -> this.addIndexEntry(document, (IndexEntry)entry), entry -> this.deleteIndexEntry(document, (IndexEntry)entry));
    }

    @Override
    public Collection<FieldIndex> getFieldIndexes(String collectionGroup) {
        Assert.hardAssert(this.started, "IndexManager not started", new Object[0]);
        Map<Integer, FieldIndex> indexes = this.memoizedIndexes.get(collectionGroup);
        return indexes == null ? Collections.emptyList() : indexes.values();
    }

    @Override
    public Collection<FieldIndex> getFieldIndexes() {
        ArrayList<FieldIndex> allIndices = new ArrayList<FieldIndex>();
        for (Map<Integer, FieldIndex> indices : this.memoizedIndexes.values()) {
            allIndices.addAll(indices.values());
        }
        return allIndices;
    }

    private void memoizeIndex(FieldIndex fieldIndex) {
        FieldIndex existingIndex;
        Map<Integer, FieldIndex> existingIndexes = this.memoizedIndexes.get(fieldIndex.getCollectionGroup());
        if (existingIndexes == null) {
            existingIndexes = new HashMap<Integer, FieldIndex>();
            this.memoizedIndexes.put(fieldIndex.getCollectionGroup(), existingIndexes);
        }
        if ((existingIndex = existingIndexes.get(fieldIndex.getIndexId())) != null) {
            this.nextIndexToUpdate.remove(existingIndex);
        }
        existingIndexes.put(fieldIndex.getIndexId(), fieldIndex);
        this.nextIndexToUpdate.add(fieldIndex);
        this.memoizedMaxIndexId = Math.max(this.memoizedMaxIndexId, fieldIndex.getIndexId());
        this.memoizedMaxSequenceNumber = Math.max(this.memoizedMaxSequenceNumber, fieldIndex.getIndexState().getSequenceNumber());
    }

    private SortedSet<IndexEntry> computeIndexEntries(Document document, FieldIndex fieldIndex) {
        TreeSet<IndexEntry> result = new TreeSet<IndexEntry>();
        byte[] directionalValue = this.encodeDirectionalElements(fieldIndex, document);
        if (directionalValue == null) {
            return result;
        }
        FieldIndex.Segment arraySegment = fieldIndex.getArraySegment();
        if (arraySegment != null) {
            Value value = document.getField(arraySegment.getFieldPath());
            if (Values.isArray(value)) {
                for (Value arrayValue : value.getArrayValue().getValuesList()) {
                    result.add(IndexEntry.create(fieldIndex.getIndexId(), document.getKey(), this.encodeSingleElement(arrayValue), directionalValue));
                }
            }
        } else {
            result.add(IndexEntry.create(fieldIndex.getIndexId(), document.getKey(), new byte[0], directionalValue));
        }
        return result;
    }

    private void addIndexEntry(Document document, IndexEntry indexEntry) {
        this.db.execute("INSERT INTO index_entries (index_id, uid, array_value, directional_value, document_name) VALUES(?, ?, ?, ?, ?)", indexEntry.getIndexId(), this.uid, indexEntry.getArrayValue(), indexEntry.getDirectionalValue(), document.getKey().toString());
    }

    private void deleteIndexEntry(Document document, IndexEntry indexEntry) {
        this.db.execute("DELETE FROM index_entries WHERE index_id = ? AND uid = ? AND array_value = ? AND directional_value = ? AND document_name = ?", indexEntry.getIndexId(), this.uid, indexEntry.getArrayValue(), indexEntry.getDirectionalValue(), document.getKey().toString());
    }

    private SortedSet<IndexEntry> getExistingIndexEntries(DocumentKey documentKey, FieldIndex fieldIndex) {
        TreeSet<IndexEntry> results = new TreeSet<IndexEntry>();
        this.db.query("SELECT array_value, directional_value FROM index_entries WHERE index_id = ? AND document_name = ? AND uid = ?").binding(fieldIndex.getIndexId(), documentKey.toString(), this.uid).forEach(row -> results.add(IndexEntry.create(fieldIndex.getIndexId(), documentKey, row.getBlob(0), row.getBlob(1))));
        return results;
    }

    @Override
    public Set<DocumentKey> getDocumentsMatchingTarget(FieldIndex fieldIndex, Target target) {
        Assert.hardAssert(this.started, "IndexManager not started", new Object[0]);
        List<Value> arrayValues = target.getArrayValues(fieldIndex);
        List<Value> notInValues = target.getNotInValues(fieldIndex);
        Bound lowerBound = target.getLowerBound(fieldIndex);
        Bound upperBound = target.getUpperBound(fieldIndex);
        if (Logger.isDebugEnabled()) {
            Logger.debug(TAG, "Using index '%s' to execute '%s' (Arrays: %s, Lower bound: %s, Upper bound: %s)", fieldIndex, target, arrayValues, lowerBound, upperBound);
        }
        Object[] lowerBoundEncoded = this.encodeBound(fieldIndex, target, lowerBound);
        String lowerBoundOp = lowerBound != null && lowerBound.isInclusive() ? ">=" : ">";
        Object[] upperBoundEncoded = this.encodeBound(fieldIndex, target, upperBound);
        String upperBoundOp = upperBound != null && upperBound.isInclusive() ? "<=" : "<";
        Object[] notInEncoded = this.encodeValues(fieldIndex, target, notInValues);
        SQLitePersistence.Query query = this.generateQuery(target, fieldIndex.getIndexId(), arrayValues, lowerBoundEncoded, lowerBoundOp, upperBoundEncoded, upperBoundOp, notInEncoded);
        HashSet<DocumentKey> result = new HashSet<DocumentKey>();
        query.forEach(row -> result.add(DocumentKey.fromPath(ResourcePath.fromString(row.getString(0)))));
        Logger.debug(TAG, "Index scan returned %s documents", result.size());
        return result;
    }

    private SQLitePersistence.Query generateQuery(Target target, int indexId, @Nullable List<Value> arrayValues, @Nullable Object[] lowerBounds, String lowerBoundOp, @Nullable Object[] upperBounds, String upperBoundOp, @Nullable Object[] notIn) {
        int statementCount = (arrayValues != null ? arrayValues.size() : 1) * Math.max(lowerBounds != null ? lowerBounds.length : 1, upperBounds != null ? upperBounds.length : 1);
        StringBuilder statement = new StringBuilder();
        statement.append("SELECT document_name, directional_value FROM index_entries ");
        statement.append("WHERE index_id = ? AND uid = ? ");
        if (arrayValues != null) {
            statement.append("AND array_value = ? ");
        }
        if (lowerBounds != null) {
            statement.append("AND directional_value ").append(lowerBoundOp).append(" ? ");
        }
        if (upperBounds != null) {
            statement.append("AND directional_value ").append(upperBoundOp).append(" ? ");
        }
        StringBuilder sql = Util.repeatSequence(statement, statementCount, " UNION ");
        sql.append(" ORDER BY directional_value, document_name ");
        if (target.getLimit() != -1L) {
            sql.append("LIMIT ").append(target.getLimit()).append(" ");
        }
        if (notIn != null) {
            sql = new StringBuilder("SELECT document_name, directional_value FROM (").append((CharSequence)sql);
            sql.append(") WHERE directional_value NOT IN (");
            sql.append((CharSequence)Util.repeatSequence("?", notIn.length, ", "));
            sql.append(")");
        }
        Object[] bindArgs = this.fillBounds(statementCount, indexId, arrayValues, lowerBounds, upperBounds, notIn);
        return this.db.query(sql.toString()).binding(bindArgs);
    }

    private Object[] fillBounds(int statementCount, int indexId, @Nullable List<Value> arrayValues, @Nullable Object[] lowerBounds, @Nullable Object[] upperBounds, @Nullable Object[] notInValues) {
        int bindsPerStatement = 2 + (arrayValues != null ? 1 : 0) + (lowerBounds != null ? 1 : 0) + (upperBounds != null ? 1 : 0);
        int statementsPerArrayValue = statementCount / (arrayValues != null ? arrayValues.size() : 1);
        Object[] bindArgs = new Object[statementCount * bindsPerStatement + (notInValues != null ? notInValues.length : 0)];
        int offset = 0;
        for (int i = 0; i < statementCount; ++i) {
            bindArgs[offset++] = indexId;
            bindArgs[offset++] = this.uid;
            if (arrayValues != null) {
                bindArgs[offset++] = this.encodeSingleElement(arrayValues.get(i / statementsPerArrayValue));
            }
            if (lowerBounds != null) {
                bindArgs[offset++] = lowerBounds[i % statementsPerArrayValue];
            }
            if (upperBounds == null) continue;
            bindArgs[offset++] = upperBounds[i % statementsPerArrayValue];
        }
        if (notInValues != null) {
            for (Object notInValue : notInValues) {
                bindArgs[offset++] = notInValue;
            }
        }
        return bindArgs;
    }

    @Override
    @Nullable
    public FieldIndex getFieldIndex(Target target) {
        Assert.hardAssert(this.started, "IndexManager not started", new Object[0]);
        if (!Persistence.INDEXING_SUPPORT_ENABLED) {
            return null;
        }
        TargetIndexMatcher targetIndexMatcher = new TargetIndexMatcher(target);
        String collectionGroup = target.getCollectionGroup() != null ? target.getCollectionGroup() : target.getPath().getLastSegment();
        Collection<FieldIndex> collectionIndexes = this.getFieldIndexes(collectionGroup);
        if (collectionIndexes.isEmpty()) {
            return null;
        }
        ArrayList<FieldIndex> matchingIndexes = new ArrayList<FieldIndex>();
        for (FieldIndex fieldIndex : collectionIndexes) {
            boolean matches = targetIndexMatcher.servedByIndex(fieldIndex);
            if (!matches) continue;
            matchingIndexes.add(fieldIndex);
        }
        if (matchingIndexes.isEmpty()) {
            return null;
        }
        return (FieldIndex)Collections.max(matchingIndexes, (l, r) -> Integer.compare(l.getSegments().size(), r.getSegments().size()));
    }

    @Nullable
    private byte[] encodeDirectionalElements(FieldIndex fieldIndex, Document document) {
        IndexByteEncoder encoder = new IndexByteEncoder();
        for (FieldIndex.Segment segment : fieldIndex.getDirectionalSegments()) {
            Value field = document.getField(segment.getFieldPath());
            if (field == null) {
                return null;
            }
            DirectionalIndexByteEncoder directionalEncoder = encoder.forKind(segment.getKind());
            FirestoreIndexValueWriter.INSTANCE.writeIndexValue(field, directionalEncoder);
        }
        return encoder.getEncodedBytes();
    }

    private byte[] encodeSingleElement(Value value) {
        IndexByteEncoder encoder = new IndexByteEncoder();
        FirestoreIndexValueWriter.INSTANCE.writeIndexValue(value, encoder.forKind(FieldIndex.Segment.Kind.ASCENDING));
        return encoder.getEncodedBytes();
    }

    @Nullable
    private Object[] encodeValues(FieldIndex fieldIndex, Target target, @Nullable List<Value> bound) {
        if (bound == null) {
            return null;
        }
        List<IndexByteEncoder> encoders = new ArrayList<IndexByteEncoder>();
        encoders.add(new IndexByteEncoder());
        Iterator<Value> position = bound.iterator();
        for (FieldIndex.Segment segment : fieldIndex.getDirectionalSegments()) {
            Value value = position.next();
            for (IndexByteEncoder encoder : encoders) {
                if (this.isInFilter(target, segment.getFieldPath()) && Values.isArray(value)) {
                    encoders = this.expandIndexValues(encoders, segment, value);
                    continue;
                }
                DirectionalIndexByteEncoder directionalEncoder = encoder.forKind(segment.getKind());
                FirestoreIndexValueWriter.INSTANCE.writeIndexValue(value, directionalEncoder);
            }
        }
        return this.getEncodedBytes(encoders);
    }

    @Nullable
    private Object[] encodeBound(FieldIndex fieldIndex, Target target, @Nullable Bound bound) {
        if (bound == null) {
            return null;
        }
        return this.encodeValues(fieldIndex, target, bound.getPosition());
    }

    private Object[] getEncodedBytes(List<IndexByteEncoder> encoders) {
        Object[] result = new Object[encoders.size()];
        for (int i = 0; i < encoders.size(); ++i) {
            result[i] = encoders.get(i).getEncodedBytes();
        }
        return result;
    }

    private List<IndexByteEncoder> expandIndexValues(List<IndexByteEncoder> encoders, FieldIndex.Segment segment, Value value) {
        ArrayList<IndexByteEncoder> prefixes = new ArrayList<IndexByteEncoder>(encoders);
        ArrayList<IndexByteEncoder> results = new ArrayList<IndexByteEncoder>();
        for (Value arrayElement : value.getArrayValue().getValuesList()) {
            for (IndexByteEncoder prefix : prefixes) {
                IndexByteEncoder clonedEncoder = new IndexByteEncoder();
                clonedEncoder.seed(prefix.getEncodedBytes());
                FirestoreIndexValueWriter.INSTANCE.writeIndexValue(arrayElement, clonedEncoder.forKind(segment.getKind()));
                results.add(clonedEncoder);
            }
        }
        return results;
    }

    private boolean isInFilter(Target target, FieldPath fieldPath) {
        for (Filter filter : target.getFilters()) {
            if (!(filter instanceof FieldFilter) || !((FieldFilter)filter).getField().equals(fieldPath)) continue;
            FieldFilter.Operator operator = ((FieldFilter)filter).getOperator();
            return operator.equals((Object)FieldFilter.Operator.IN) || operator.equals((Object)FieldFilter.Operator.NOT_IN);
        }
        return false;
    }

    private byte[] encodeSegments(FieldIndex fieldIndex) {
        return this.serializer.encodeFieldIndexSegments(fieldIndex.getSegments()).toByteArray();
    }

    @Override
    public void updateCollectionGroup(String collectionGroup, FieldIndex.IndexOffset offset) {
        Assert.hardAssert(this.started, "IndexManager not started", new Object[0]);
        ++this.memoizedMaxSequenceNumber;
        for (FieldIndex fieldIndex : this.getFieldIndexes(collectionGroup)) {
            FieldIndex updatedIndex = FieldIndex.create(fieldIndex.getIndexId(), fieldIndex.getCollectionGroup(), fieldIndex.getSegments(), FieldIndex.IndexState.create(this.memoizedMaxSequenceNumber, offset));
            this.db.execute("REPLACE INTO index_state (index_id, uid,  sequence_number, read_time_seconds, read_time_nanos, document_key) VALUES(?, ?, ?, ?, ?, ?)", fieldIndex.getIndexId(), this.uid, this.memoizedMaxSequenceNumber, offset.getReadTime().getTimestamp().getSeconds(), offset.getReadTime().getTimestamp().getNanoseconds(), EncodedPath.encode(offset.getDocumentKey().getPath()));
            this.memoizeIndex(updatedIndex);
        }
    }
}

