/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.remote;

import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.firestore.auth.CredentialsProvider;
import com.google.firebase.firestore.auth.User;
import com.google.firebase.firestore.util.Logger;
import com.google.firebase.internal.api.FirebaseNoSignedInUserException;
import io.grpc.CallCredentials;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.concurrent.Executor;

final class FirestoreCallCredentials
extends CallCredentials {
    private static final String LOG_TAG = "FirestoreCallCredentials";
    private static final Metadata.Key<String> AUTHORIZATION_HEADER = Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> X_FIREBASE_APPCHECK = Metadata.Key.of((String)"x-firebase-appcheck", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final CredentialsProvider<User> authProvider;
    private final CredentialsProvider<String> appCheckProvider;

    FirestoreCallCredentials(CredentialsProvider<User> authProvider, CredentialsProvider<String> appCheckProvider) {
        this.authProvider = authProvider;
        this.appCheckProvider = appCheckProvider;
    }

    public void thisUsesUnstableApi() {
    }

    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor executor, CallCredentials.MetadataApplier metadataApplier) {
        Task<String> authTask = this.authProvider.getToken();
        Task<String> appCheckTask = this.appCheckProvider.getToken();
        Tasks.whenAll((Task[])new Task[]{authTask, appCheckTask}).addOnCompleteListener(executor, unused -> {
            Exception exception;
            String token;
            Metadata metadata = new Metadata();
            if (authTask.isSuccessful()) {
                token = (String)authTask.getResult();
                Logger.debug(LOG_TAG, "Successfully fetched auth token.", new Object[0]);
                if (token != null) {
                    metadata.put(AUTHORIZATION_HEADER, (Object)("Bearer " + token));
                }
            } else {
                exception = authTask.getException();
                if (exception instanceof FirebaseApiNotAvailableException) {
                    Logger.debug(LOG_TAG, "Firebase Auth API not available, not using authentication.", new Object[0]);
                } else if (exception instanceof FirebaseNoSignedInUserException) {
                    Logger.debug(LOG_TAG, "No user signed in, not using authentication.", new Object[0]);
                } else {
                    Logger.warn(LOG_TAG, "Failed to get auth token: %s.", exception);
                    metadataApplier.fail(Status.UNAUTHENTICATED.withCause((Throwable)exception));
                    return;
                }
            }
            if (appCheckTask.isSuccessful()) {
                token = (String)appCheckTask.getResult();
                if (token != null && !token.isEmpty()) {
                    Logger.debug(LOG_TAG, "Successfully fetched AppCheck token.", new Object[0]);
                    metadata.put(X_FIREBASE_APPCHECK, (Object)token);
                }
            } else {
                exception = appCheckTask.getException();
                if (exception instanceof FirebaseApiNotAvailableException) {
                    Logger.debug(LOG_TAG, "Firebase AppCheck API not available.", new Object[0]);
                } else {
                    Logger.warn(LOG_TAG, "Failed to get AppCheck token: %s.", exception);
                    metadataApplier.fail(Status.UNAUTHENTICATED.withCause((Throwable)exception));
                    return;
                }
            }
            metadataApplier.apply(metadata);
        });
    }
}

