/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.util;

import com.google.firebase.firestore.util.Executors;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;

public class BackgroundQueue
implements Executor {
    private Semaphore completedTasks = new Semaphore(0);
    private int pendingTaskCount = 0;

    @Override
    public void execute(Runnable task) {
        ++this.pendingTaskCount;
        Executors.BACKGROUND_EXECUTOR.execute(() -> {
            task.run();
            this.completedTasks.release();
        });
    }

    public void drain() throws InterruptedException {
        this.completedTasks.acquire(this.pendingTaskCount);
        this.pendingTaskCount = 0;
    }
}

