/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.appcheck.interop.InternalAppCheckTokenProvider;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.emulators.EmulatedServiceSettings;
import com.google.firebase.firestore.CollectionReference;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.EventListener;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.FirebaseFirestoreSettings;
import com.google.firebase.firestore.FirestoreMultiDbComponent;
import com.google.firebase.firestore.ListenerRegistration;
import com.google.firebase.firestore.LoadBundleTask;
import com.google.firebase.firestore.Transaction;
import com.google.firebase.firestore.UserDataReader;
import com.google.firebase.firestore.WriteBatch;
import com.google.firebase.firestore.auth.CredentialsProvider;
import com.google.firebase.firestore.auth.FirebaseAppCheckTokenProvider;
import com.google.firebase.firestore.auth.FirebaseAuthCredentialsProvider;
import com.google.firebase.firestore.auth.User;
import com.google.firebase.firestore.core.ActivityScope;
import com.google.firebase.firestore.core.AsyncEventListener;
import com.google.firebase.firestore.core.DatabaseInfo;
import com.google.firebase.firestore.core.FirestoreClient;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.core.Transaction;
import com.google.firebase.firestore.local.SQLitePersistence;
import com.google.firebase.firestore.model.DatabaseId;
import com.google.firebase.firestore.model.FieldIndex;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.remote.FirestoreChannel;
import com.google.firebase.firestore.remote.GrpcMetadataProvider;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.AsyncQueue;
import com.google.firebase.firestore.util.ByteBufferInputStream;
import com.google.firebase.firestore.util.Executors;
import com.google.firebase.firestore.util.Function;
import com.google.firebase.firestore.util.Logger;
import com.google.firebase.firestore.util.Preconditions;
import com.google.firebase.inject.Deferred;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FirebaseFirestore {
    private static final String TAG = "FirebaseFirestore";
    private final Context context;
    private final DatabaseId databaseId;
    private final String persistenceKey;
    private final CredentialsProvider<User> authProvider;
    private final CredentialsProvider<String> appCheckProvider;
    private final AsyncQueue asyncQueue;
    private final FirebaseApp firebaseApp;
    private final UserDataReader userDataReader;
    private final InstanceRegistry instanceRegistry;
    @Nullable
    private EmulatedServiceSettings emulatorSettings;
    private FirebaseFirestoreSettings settings;
    private volatile FirestoreClient client;
    private final GrpcMetadataProvider metadataProvider;

    @NonNull
    public static FirebaseFirestore getInstance() {
        FirebaseApp app = FirebaseApp.getInstance();
        if (app == null) {
            throw new IllegalStateException("You must call FirebaseApp.initializeApp first.");
        }
        return FirebaseFirestore.getInstance(app, "(default)");
    }

    @NonNull
    public static FirebaseFirestore getInstance(@NonNull FirebaseApp app) {
        return FirebaseFirestore.getInstance(app, "(default)");
    }

    @NonNull
    private static FirebaseFirestore getInstance(@NonNull FirebaseApp app, @NonNull String database) {
        Preconditions.checkNotNull(app, "Provided FirebaseApp must not be null.");
        FirestoreMultiDbComponent component = (FirestoreMultiDbComponent)app.get(FirestoreMultiDbComponent.class);
        Preconditions.checkNotNull(component, "Firestore component is not present.");
        return component.get(database);
    }

    @NonNull
    static FirebaseFirestore newInstance(@NonNull Context context, @NonNull FirebaseApp app, @NonNull Deferred<InternalAuthProvider> deferredAuthProvider, @NonNull Deferred<InternalAppCheckTokenProvider> deferredAppCheckTokenProvider, @NonNull String database, @NonNull InstanceRegistry instanceRegistry, @Nullable GrpcMetadataProvider metadataProvider) {
        String projectId = app.getOptions().getProjectId();
        if (projectId == null) {
            throw new IllegalArgumentException("FirebaseOptions.getProjectId() cannot be null");
        }
        DatabaseId databaseId = DatabaseId.forDatabase(projectId, database);
        AsyncQueue queue = new AsyncQueue();
        FirebaseAuthCredentialsProvider authProvider = new FirebaseAuthCredentialsProvider(deferredAuthProvider);
        FirebaseAppCheckTokenProvider appCheckProvider = new FirebaseAppCheckTokenProvider(deferredAppCheckTokenProvider);
        String persistenceKey = app.getName();
        FirebaseFirestore firestore = new FirebaseFirestore(context, databaseId, persistenceKey, authProvider, appCheckProvider, queue, app, instanceRegistry, metadataProvider);
        return firestore;
    }

    @VisibleForTesting
    FirebaseFirestore(Context context, DatabaseId databaseId, String persistenceKey, CredentialsProvider<User> authProvider, CredentialsProvider<String> appCheckProvider, AsyncQueue asyncQueue, @Nullable FirebaseApp firebaseApp, InstanceRegistry instanceRegistry, @Nullable GrpcMetadataProvider metadataProvider) {
        this.context = Preconditions.checkNotNull(context);
        this.databaseId = Preconditions.checkNotNull(Preconditions.checkNotNull(databaseId));
        this.userDataReader = new UserDataReader(databaseId);
        this.persistenceKey = Preconditions.checkNotNull(persistenceKey);
        this.authProvider = Preconditions.checkNotNull(authProvider);
        this.appCheckProvider = Preconditions.checkNotNull(appCheckProvider);
        this.asyncQueue = Preconditions.checkNotNull(asyncQueue);
        this.firebaseApp = firebaseApp;
        this.instanceRegistry = instanceRegistry;
        this.metadataProvider = metadataProvider;
        this.settings = new FirebaseFirestoreSettings.Builder().build();
    }

    @NonNull
    public FirebaseFirestoreSettings getFirestoreSettings() {
        return this.settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFirestoreSettings(@NonNull FirebaseFirestoreSettings settings) {
        settings = this.mergeEmulatorSettings(settings, this.emulatorSettings);
        DatabaseId databaseId = this.databaseId;
        synchronized (databaseId) {
            Preconditions.checkNotNull(settings, "Provided settings must not be null.");
            if (this.client != null && !this.settings.equals(settings)) {
                throw new IllegalStateException("FirebaseFirestore has already been started and its settings can no longer be changed. You can only call setFirestoreSettings() before calling any other methods on a FirebaseFirestore object.");
            }
            this.settings = settings;
        }
    }

    public void useEmulator(@NonNull String host, int port) {
        if (this.client != null) {
            throw new IllegalStateException("Cannot call useEmulator() after instance has already been initialized.");
        }
        this.emulatorSettings = new EmulatedServiceSettings(host, port);
        this.settings = this.mergeEmulatorSettings(this.settings, this.emulatorSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureClientConfigured() {
        if (this.client != null) {
            return;
        }
        DatabaseId databaseId = this.databaseId;
        synchronized (databaseId) {
            if (this.client != null) {
                return;
            }
            DatabaseInfo databaseInfo = new DatabaseInfo(this.databaseId, this.persistenceKey, this.settings.getHost(), this.settings.isSslEnabled());
            this.client = new FirestoreClient(this.context, databaseInfo, this.settings, this.authProvider, this.appCheckProvider, this.asyncQueue, this.metadataProvider);
        }
    }

    private FirebaseFirestoreSettings mergeEmulatorSettings(@NonNull FirebaseFirestoreSettings settings, @Nullable EmulatedServiceSettings emulatorSettings) {
        if (emulatorSettings == null) {
            return settings;
        }
        if (!"firestore.googleapis.com".equals(settings.getHost())) {
            Logger.warn(TAG, "Host has been set in FirebaseFirestoreSettings and useEmulator, emulator host will be used.", new Object[0]);
        }
        return new FirebaseFirestoreSettings.Builder(settings).setHost(emulatorSettings.getHost() + ":" + emulatorSettings.getPort()).setSslEnabled(false).build();
    }

    @NonNull
    public FirebaseApp getApp() {
        return this.firebaseApp;
    }

    @VisibleForTesting
    Task<Void> setIndexConfiguration(String json) {
        this.ensureClientConfigured();
        Preconditions.checkState(this.settings.isPersistenceEnabled(), "Cannot enable indexes when persistence is disabled");
        ArrayList<FieldIndex> parsedIndexes = new ArrayList<FieldIndex>();
        try {
            JSONObject jsonObject = new JSONObject(json);
            if (jsonObject.has("indexes")) {
                JSONArray indexes = jsonObject.getJSONArray("indexes");
                for (int i = 0; i < indexes.length(); ++i) {
                    JSONObject definition = indexes.getJSONObject(i);
                    String collectionGroup = definition.getString("collectionGroup");
                    ArrayList<FieldIndex.Segment> segments = new ArrayList<FieldIndex.Segment>();
                    JSONArray fields = definition.optJSONArray("fields");
                    for (int f = 0; fields != null && f < fields.length(); ++f) {
                        JSONObject field = fields.getJSONObject(f);
                        FieldPath fieldPath = FieldPath.fromServerFormat(field.getString("fieldPath"));
                        if ("CONTAINS".equals(field.optString("arrayConfig"))) {
                            segments.add(FieldIndex.Segment.create(fieldPath, FieldIndex.Segment.Kind.CONTAINS));
                            continue;
                        }
                        if ("ASCENDING".equals(field.optString("order"))) {
                            segments.add(FieldIndex.Segment.create(fieldPath, FieldIndex.Segment.Kind.ASCENDING));
                            continue;
                        }
                        segments.add(FieldIndex.Segment.create(fieldPath, FieldIndex.Segment.Kind.DESCENDING));
                    }
                    parsedIndexes.add(FieldIndex.create(-1, collectionGroup, segments, FieldIndex.INITIAL_STATE));
                }
            }
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Failed to parse index configuration", e);
        }
        return this.client.configureFieldIndexes(parsedIndexes);
    }

    @NonNull
    public CollectionReference collection(@NonNull String collectionPath) {
        Preconditions.checkNotNull(collectionPath, "Provided collection path must not be null.");
        this.ensureClientConfigured();
        return new CollectionReference(ResourcePath.fromString(collectionPath), this);
    }

    @NonNull
    public DocumentReference document(@NonNull String documentPath) {
        Preconditions.checkNotNull(documentPath, "Provided document path must not be null.");
        this.ensureClientConfigured();
        return DocumentReference.forPath(ResourcePath.fromString(documentPath), this);
    }

    @NonNull
    public com.google.firebase.firestore.Query collectionGroup(@NonNull String collectionId) {
        Preconditions.checkNotNull(collectionId, "Provided collection ID must not be null.");
        if (collectionId.contains("/")) {
            throw new IllegalArgumentException(String.format("Invalid collectionId '%s'. Collection IDs must not contain '/'.", collectionId));
        }
        this.ensureClientConfigured();
        return new com.google.firebase.firestore.Query(new Query(ResourcePath.EMPTY, collectionId), this);
    }

    private <ResultT> Task<ResultT> runTransaction(Transaction.Function<ResultT> updateFunction, Executor executor) {
        this.ensureClientConfigured();
        Function wrappedUpdateFunction = internalTransaction -> Tasks.call((Executor)executor, () -> updateFunction.apply(new com.google.firebase.firestore.Transaction((Transaction)internalTransaction, this)));
        return this.client.transaction(wrappedUpdateFunction);
    }

    @NonNull
    public <TResult> Task<TResult> runTransaction(@NonNull Transaction.Function<TResult> updateFunction) {
        Preconditions.checkNotNull(updateFunction, "Provided transaction update function must not be null.");
        return this.runTransaction(updateFunction, Transaction.getDefaultExecutor());
    }

    @NonNull
    public WriteBatch batch() {
        this.ensureClientConfigured();
        return new WriteBatch(this);
    }

    @NonNull
    public Task<Void> runBatch(@NonNull WriteBatch.Function batchFunction) {
        WriteBatch batch = this.batch();
        batchFunction.apply(batch);
        return batch.commit();
    }

    @NonNull
    public Task<Void> terminate() {
        this.instanceRegistry.remove(this.getDatabaseId().getDatabaseId());
        this.ensureClientConfigured();
        return this.client.terminate();
    }

    @NonNull
    public Task<Void> waitForPendingWrites() {
        return this.client.waitForPendingWrites();
    }

    @VisibleForTesting
    AsyncQueue getAsyncQueue() {
        return this.asyncQueue;
    }

    @NonNull
    public Task<Void> enableNetwork() {
        this.ensureClientConfigured();
        return this.client.enableNetwork();
    }

    @NonNull
    public Task<Void> disableNetwork() {
        this.ensureClientConfigured();
        return this.client.disableNetwork();
    }

    public static void setLoggingEnabled(boolean loggingEnabled) {
        if (loggingEnabled) {
            Logger.setLogLevel(Logger.Level.DEBUG);
        } else {
            Logger.setLogLevel(Logger.Level.WARN);
        }
    }

    @NonNull
    public Task<Void> clearPersistence() {
        TaskCompletionSource source = new TaskCompletionSource();
        this.asyncQueue.enqueueAndForgetEvenAfterShutdown(() -> {
            try {
                if (this.client != null && !this.client.isTerminated()) {
                    throw new FirebaseFirestoreException("Persistence cannot be cleared while the firestore instance is running.", FirebaseFirestoreException.Code.FAILED_PRECONDITION);
                }
                SQLitePersistence.clearPersistence(this.context, this.databaseId, this.persistenceKey);
                source.setResult(null);
            }
            catch (FirebaseFirestoreException e) {
                source.setException((Exception)((Object)e));
            }
        });
        return source.getTask();
    }

    @NonNull
    public ListenerRegistration addSnapshotsInSyncListener(@NonNull Runnable runnable) {
        return this.addSnapshotsInSyncListener(Executors.DEFAULT_CALLBACK_EXECUTOR, runnable);
    }

    @NonNull
    public ListenerRegistration addSnapshotsInSyncListener(@NonNull Activity activity, @NonNull Runnable runnable) {
        return this.addSnapshotsInSyncListener(Executors.DEFAULT_CALLBACK_EXECUTOR, activity, runnable);
    }

    @NonNull
    public ListenerRegistration addSnapshotsInSyncListener(@NonNull Executor executor, @NonNull Runnable runnable) {
        return this.addSnapshotsInSyncListener(executor, null, runnable);
    }

    @NonNull
    public LoadBundleTask loadBundle(@NonNull InputStream bundleData) {
        this.ensureClientConfigured();
        LoadBundleTask resultTask = new LoadBundleTask();
        this.client.loadBundle(bundleData, resultTask);
        return resultTask;
    }

    @NonNull
    public LoadBundleTask loadBundle(@NonNull byte[] bundleData) {
        return this.loadBundle(new ByteArrayInputStream(bundleData));
    }

    @NonNull
    public LoadBundleTask loadBundle(@NonNull ByteBuffer bundleData) {
        return this.loadBundle(new ByteBufferInputStream(bundleData));
    }

    @NonNull
    public Task<com.google.firebase.firestore.Query> getNamedQuery(@NonNull String name) {
        this.ensureClientConfigured();
        return this.client.getNamedQuery(name).continueWith(task -> {
            Query query = (Query)task.getResult();
            if (query != null) {
                return new com.google.firebase.firestore.Query(query, this);
            }
            return null;
        });
    }

    private ListenerRegistration addSnapshotsInSyncListener(Executor userExecutor, @Nullable Activity activity, @NonNull Runnable runnable) {
        this.ensureClientConfigured();
        EventListener<Void> eventListener = (v, error) -> {
            Assert.hardAssert(error == null, "snapshots-in-sync listeners should never get errors.", new Object[0]);
            runnable.run();
        };
        AsyncEventListener<Void> asyncListener = new AsyncEventListener<Void>(userExecutor, eventListener);
        this.client.addSnapshotsInSyncListener(asyncListener);
        return ActivityScope.bind(activity, () -> {
            asyncListener.mute();
            this.client.removeSnapshotsInSyncListener(asyncListener);
        });
    }

    FirestoreClient getClient() {
        return this.client;
    }

    DatabaseId getDatabaseId() {
        return this.databaseId;
    }

    UserDataReader getUserDataReader() {
        return this.userDataReader;
    }

    void validateReference(DocumentReference docRef) {
        Preconditions.checkNotNull(docRef, "Provided DocumentReference must not be null.");
        if (docRef.getFirestore() != this) {
            throw new IllegalArgumentException("Provided document reference is from a different Cloud Firestore instance.");
        }
    }

    @Keep
    static void setClientLanguage(@NonNull String languageToken) {
        FirestoreChannel.setClientLanguage(languageToken);
    }

    public static interface InstanceRegistry {
        public void remove(@NonNull String var1);
    }
}

