/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model.mutation;

import androidx.annotation.Nullable;
import com.google.firebase.Timestamp;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.MutableDocument;
import com.google.firebase.firestore.model.mutation.FieldMask;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.MutationResult;
import com.google.firebase.firestore.model.mutation.Precondition;
import com.google.firebase.firestore.util.Assert;

public final class DeleteMutation
extends Mutation {
    public DeleteMutation(DocumentKey key, Precondition precondition) {
        super(key, precondition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteMutation that = (DeleteMutation)o;
        return this.hasSameKeyAndPrecondition(that);
    }

    public int hashCode() {
        return this.keyAndPreconditionHashCode();
    }

    public String toString() {
        return "DeleteMutation{" + this.keyAndPreconditionToString() + "}";
    }

    @Override
    public void applyToRemoteDocument(MutableDocument document, MutationResult mutationResult) {
        this.verifyKeyMatches(document);
        Assert.hardAssert(mutationResult.getTransformResults().isEmpty(), "Transform results received by DeleteMutation.", new Object[0]);
        document.convertToNoDocument(mutationResult.getVersion()).setHasCommittedMutations();
    }

    @Override
    @Nullable
    public FieldMask applyToLocalView(MutableDocument document, @Nullable FieldMask previousMask, Timestamp localWriteTime) {
        this.verifyKeyMatches(document);
        if (this.getPrecondition().isValidFor(document)) {
            document.convertToNoDocument(document.getVersion()).setHasLocalMutations();
            return null;
        }
        return previousMask;
    }
}

