/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import androidx.annotation.Nullable;
import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.firestore.core.Target;
import com.google.firebase.firestore.local.IndexManager;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldIndex;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

class MemoryIndexManager
implements IndexManager {
    private final MemoryCollectionParentIndex collectionParentsIndex = new MemoryCollectionParentIndex();

    @Override
    public void start() {
    }

    @Override
    public void addToCollectionParentIndex(ResourcePath collectionPath) {
        this.collectionParentsIndex.add(collectionPath);
    }

    @Override
    public List<ResourcePath> getCollectionParents(String collectionId) {
        return this.collectionParentsIndex.getEntries(collectionId);
    }

    @Override
    public void addFieldIndex(FieldIndex index) {
    }

    @Override
    public void deleteFieldIndex(FieldIndex index) {
    }

    @Override
    @Nullable
    public FieldIndex getFieldIndex(Target target) {
        return null;
    }

    @Override
    @Nullable
    public List<DocumentKey> getDocumentsMatchingTarget(Target target) {
        return null;
    }

    @Override
    @Nullable
    public String getNextCollectionGroupToUpdate() {
        return null;
    }

    @Override
    public void updateCollectionGroup(String collectionGroup, FieldIndex.IndexOffset offset) {
    }

    @Override
    public Collection<FieldIndex> getFieldIndexes(String collectionGroup) {
        return Collections.emptyList();
    }

    @Override
    public Collection<FieldIndex> getFieldIndexes() {
        return Collections.emptyList();
    }

    @Override
    public FieldIndex.IndexOffset getMinOffset(Target target) {
        return FieldIndex.IndexOffset.NONE;
    }

    @Override
    public FieldIndex.IndexOffset getMinOffset(String collectionGroup) {
        return FieldIndex.IndexOffset.NONE;
    }

    @Override
    public void updateIndexEntries(ImmutableSortedMap<DocumentKey, Document> documents) {
    }

    static class MemoryCollectionParentIndex {
        private final HashMap<String, HashSet<ResourcePath>> index = new HashMap();

        MemoryCollectionParentIndex() {
        }

        boolean add(ResourcePath collectionPath) {
            Assert.hardAssert(collectionPath.length() % 2 == 1, "Expected a collection path.", new Object[0]);
            String collectionId = collectionPath.getLastSegment();
            ResourcePath parentPath = (ResourcePath)collectionPath.popLast();
            HashSet<ResourcePath> existingParents = this.index.get(collectionId);
            if (existingParents == null) {
                existingParents = new HashSet();
                this.index.put(collectionId, existingParents);
            }
            return existingParents.add(parentPath);
        }

        List<ResourcePath> getEntries(String collectionId) {
            HashSet<ResourcePath> existingParents = this.index.get(collectionId);
            return existingParents != null ? new ArrayList<ResourcePath>(existingParents) : Collections.emptyList();
        }
    }
}

