/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteProgram;
import android.database.sqlite.SQLiteStatement;
import android.database.sqlite.SQLiteTransactionListener;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.auth.User;
import com.google.firebase.firestore.local.BundleCache;
import com.google.firebase.firestore.local.DocumentOverlayCache;
import com.google.firebase.firestore.local.IndexManager;
import com.google.firebase.firestore.local.LocalSerializer;
import com.google.firebase.firestore.local.LruGarbageCollector;
import com.google.firebase.firestore.local.MutationQueue;
import com.google.firebase.firestore.local.OverlayMigrationManager;
import com.google.firebase.firestore.local.Persistence;
import com.google.firebase.firestore.local.RemoteDocumentCache;
import com.google.firebase.firestore.local.SQLiteBundleCache;
import com.google.firebase.firestore.local.SQLiteDocumentOverlayCache;
import com.google.firebase.firestore.local.SQLiteIndexManager;
import com.google.firebase.firestore.local.SQLiteLruReferenceDelegate;
import com.google.firebase.firestore.local.SQLiteMutationQueue;
import com.google.firebase.firestore.local.SQLiteOverlayMigrationManager;
import com.google.firebase.firestore.local.SQLiteRemoteDocumentCache;
import com.google.firebase.firestore.local.SQLiteSchema;
import com.google.firebase.firestore.local.SQLiteTargetCache;
import com.google.firebase.firestore.model.DatabaseId;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Consumer;
import com.google.firebase.firestore.util.FileUtil;
import com.google.firebase.firestore.util.Function;
import com.google.firebase.firestore.util.Logger;
import com.google.firebase.firestore.util.Supplier;
import com.google.firebase.firestore.util.Util;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class SQLitePersistence
extends Persistence {
    public static final int MAX_ARGS = 900;
    private final OpenHelper opener;
    private final LocalSerializer serializer;
    private final SQLiteTargetCache targetCache;
    private final SQLiteBundleCache bundleCache;
    private final SQLiteRemoteDocumentCache remoteDocumentCache;
    private final SQLiteLruReferenceDelegate referenceDelegate;
    private final SQLiteTransactionListener transactionListener = new SQLiteTransactionListener(){

        public void onBegin() {
            SQLitePersistence.this.referenceDelegate.onTransactionStarted();
        }

        public void onCommit() {
            SQLitePersistence.this.referenceDelegate.onTransactionCommitted();
        }

        public void onRollback() {
        }
    };
    private SQLiteDatabase db;
    private boolean started;

    @VisibleForTesting
    public static String databaseName(String persistenceKey, DatabaseId databaseId) {
        try {
            return "firestore." + URLEncoder.encode(persistenceKey, "utf-8") + "." + URLEncoder.encode(databaseId.getProjectId(), "utf-8") + "." + URLEncoder.encode(databaseId.getDatabaseId(), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public SQLitePersistence(Context context, String persistenceKey, DatabaseId databaseId, LocalSerializer serializer, LruGarbageCollector.Params params) {
        this(serializer, params, new OpenHelper(context, serializer, SQLitePersistence.databaseName(persistenceKey, databaseId)));
    }

    public SQLitePersistence(LocalSerializer serializer, LruGarbageCollector.Params params, OpenHelper openHelper) {
        this.opener = openHelper;
        this.serializer = serializer;
        this.targetCache = new SQLiteTargetCache(this, this.serializer);
        this.bundleCache = new SQLiteBundleCache(this, this.serializer);
        this.remoteDocumentCache = new SQLiteRemoteDocumentCache(this, this.serializer);
        this.referenceDelegate = new SQLiteLruReferenceDelegate(this, params);
    }

    @Override
    public void start() {
        Assert.hardAssert(!this.started, "SQLitePersistence double-started!", new Object[0]);
        this.started = true;
        try {
            this.db = this.opener.getWritableDatabase();
        }
        catch (SQLiteDatabaseLockedException e) {
            throw new RuntimeException("Failed to gain exclusive lock to the Cloud Firestore client's offline persistence. This generally means you are using Cloud Firestore from multiple processes in your app. Keep in mind that multi-process Android apps execute the code in your Application class in all processes, so you may need to avoid initializing Cloud Firestore in your Application class. If you are intentionally using Cloud Firestore from multiple processes, you can only enable offline persistence (that is, call setPersistenceEnabled(true)) in one of them.", e);
        }
        this.targetCache.start();
        this.referenceDelegate.start(this.targetCache.getHighestListenSequenceNumber());
    }

    @Override
    public void shutdown() {
        Assert.hardAssert(this.started, "SQLitePersistence shutdown without start!", new Object[0]);
        this.started = false;
        this.db.close();
        this.db = null;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public SQLiteLruReferenceDelegate getReferenceDelegate() {
        return this.referenceDelegate;
    }

    @Override
    MutationQueue getMutationQueue(User user, IndexManager indexManager) {
        return new SQLiteMutationQueue(this, this.serializer, user, indexManager);
    }

    @Override
    SQLiteTargetCache getTargetCache() {
        return this.targetCache;
    }

    @Override
    IndexManager getIndexManager(User user) {
        return new SQLiteIndexManager(this, this.serializer, user);
    }

    @Override
    BundleCache getBundleCache() {
        return this.bundleCache;
    }

    @Override
    DocumentOverlayCache getDocumentOverlay(User user) {
        return new SQLiteDocumentOverlayCache(this, this.serializer, user);
    }

    @Override
    OverlayMigrationManager getOverlayMigrationManager() {
        return new SQLiteOverlayMigrationManager(this);
    }

    @Override
    RemoteDocumentCache getRemoteDocumentCache() {
        return this.remoteDocumentCache;
    }

    @Override
    void runTransaction(String action, Runnable operation) {
        Logger.debug(TAG, "Starting transaction: %s", action);
        this.db.beginTransactionWithListener(this.transactionListener);
        try {
            operation.run();
            this.db.setTransactionSuccessful();
        }
        finally {
            this.db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T> T runTransaction(String action, Supplier<T> operation) {
        Logger.debug(TAG, "Starting transaction: %s", action);
        T value = null;
        this.db.beginTransactionWithListener(this.transactionListener);
        try {
            value = operation.get();
            this.db.setTransactionSuccessful();
        }
        finally {
            this.db.endTransaction();
        }
        return value;
    }

    public static void clearPersistence(Context context, DatabaseId databaseId, String persistenceKey) throws FirebaseFirestoreException {
        String databaseName = SQLitePersistence.databaseName(persistenceKey, databaseId);
        String sqLitePath = context.getDatabasePath(databaseName).getPath();
        String journalPath = sqLitePath + "-journal";
        String walPath = sqLitePath + "-wal";
        File sqLiteFile = new File(sqLitePath);
        File journalFile = new File(journalPath);
        File walFile = new File(walPath);
        try {
            FileUtil.delete(sqLiteFile);
            FileUtil.delete(journalFile);
            FileUtil.delete(walFile);
        }
        catch (IOException e) {
            throw new FirebaseFirestoreException("Failed to clear persistence." + e, FirebaseFirestoreException.Code.UNKNOWN);
        }
    }

    long getByteSize() {
        return this.getPageCount() * this.getPageSize();
    }

    private long getPageSize() {
        return (Long)this.query("PRAGMA page_size").firstValue(row -> row.getLong(0));
    }

    private long getPageCount() {
        return (Long)this.query("PRAGMA page_count").firstValue(row -> row.getLong(0));
    }

    void execute(String sql, Object ... args) {
        this.db.execSQL(sql, args);
    }

    SQLiteStatement prepare(String sql) {
        return this.db.compileStatement(sql);
    }

    int execute(SQLiteStatement statement, Object ... args) {
        statement.clearBindings();
        SQLitePersistence.bind((SQLiteProgram)statement, args);
        return statement.executeUpdateDelete();
    }

    Query query(String sql) {
        return new Query(this.db, sql);
    }

    private static void bind(SQLiteProgram program, Object[] bindArgs) {
        for (int i = 0; i < bindArgs.length; ++i) {
            Object arg = bindArgs[i];
            if (arg == null) {
                program.bindNull(i + 1);
                continue;
            }
            if (arg instanceof String) {
                program.bindString(i + 1, (String)arg);
                continue;
            }
            if (arg instanceof Integer) {
                program.bindLong(i + 1, (long)((Integer)arg).intValue());
                continue;
            }
            if (arg instanceof Long) {
                program.bindLong(i + 1, ((Long)arg).longValue());
                continue;
            }
            if (arg instanceof Double) {
                program.bindDouble(i + 1, ((Double)arg).doubleValue());
                continue;
            }
            if (arg instanceof byte[]) {
                program.bindBlob(i + 1, (byte[])arg);
                continue;
            }
            throw Assert.fail("Unknown argument %s of type %s", arg, arg.getClass());
        }
    }

    static class LongQuery {
        private final SQLitePersistence db;
        private final String head;
        private final String tail;
        private final List<Object> argsHead;
        private int subqueriesPerformed = 0;
        private final Iterator<Object> argsIter;
        private static final int LIMIT = 900;

        LongQuery(SQLitePersistence db, String head, List<Object> allArgs, String tail) {
            this.db = db;
            this.head = head;
            this.argsHead = Collections.emptyList();
            this.tail = tail;
            this.argsIter = allArgs.iterator();
        }

        LongQuery(SQLitePersistence db, String head, List<Object> argsHead, List<Object> allArgs, String tail) {
            this.db = db;
            this.head = head;
            this.argsHead = argsHead;
            this.tail = tail;
            this.argsIter = allArgs.iterator();
        }

        boolean hasMoreSubqueries() {
            return this.argsIter.hasNext();
        }

        private Object[] getNextSubqueryArgs() {
            ArrayList<Object> subqueryArgs = new ArrayList<Object>(this.argsHead);
            for (int i = 0; this.argsIter.hasNext() && i < 900 - this.argsHead.size(); ++i) {
                subqueryArgs.add(this.argsIter.next());
            }
            return subqueryArgs.toArray();
        }

        Query performNextSubquery() {
            ++this.subqueriesPerformed;
            Object[] subqueryArgs = this.getNextSubqueryArgs();
            return this.db.query(this.head + Util.repeatSequence("?", subqueryArgs.length, ", ") + this.tail).binding(subqueryArgs);
        }

        void executeNextSubquery() {
            ++this.subqueriesPerformed;
            Object[] subqueryArgs = this.getNextSubqueryArgs();
            this.db.execute(this.head + Util.repeatSequence("?", subqueryArgs.length, ", ") + this.tail, subqueryArgs);
        }

        int getSubqueriesPerformed() {
            return this.subqueriesPerformed;
        }
    }

    static class Query {
        private final SQLiteDatabase db;
        private final String sql;
        private SQLiteDatabase.CursorFactory cursorFactory;

        Query(SQLiteDatabase db, String sql) {
            this.db = db;
            this.sql = sql;
        }

        Query binding(Object ... args) {
            this.cursorFactory = (db1, masterQuery, editTable, query) -> {
                SQLitePersistence.bind((SQLiteProgram)query, args);
                return new SQLiteCursor(masterQuery, editTable, query);
            };
            return this;
        }

        int forEach(Consumer<Cursor> consumer) {
            int rowsProcessed = 0;
            try (Cursor cursor = this.startQuery();){
                while (cursor.moveToNext()) {
                    ++rowsProcessed;
                    consumer.accept(cursor);
                }
            }
            return rowsProcessed;
        }

        int first(Consumer<Cursor> consumer) {
            try (Cursor cursor = this.startQuery();){
                if (cursor.moveToFirst()) {
                    consumer.accept(cursor);
                    int n = 1;
                    return n;
                }
                int n = 0;
                return n;
            }
        }

        @Nullable
        <T> T firstValue(Function<Cursor, T> function) {
            try (Cursor cursor = this.startQuery();){
                if (cursor.moveToFirst()) {
                    T t = function.apply(cursor);
                    return t;
                }
                T t = null;
                return t;
            }
        }

        boolean isEmpty() {
            try (Cursor cursor = this.startQuery();){
                boolean bl = !cursor.moveToFirst();
                return bl;
            }
        }

        private Cursor startQuery() {
            if (this.cursorFactory != null) {
                return this.db.rawQueryWithFactory(this.cursorFactory, this.sql, null, null);
            }
            return this.db.rawQuery(this.sql, null);
        }
    }

    @VisibleForTesting
    static class OpenHelper
    extends SQLiteOpenHelper {
        private final LocalSerializer serializer;
        private boolean configured;

        private OpenHelper(Context context, LocalSerializer serializer, String databaseName) {
            this(context, serializer, databaseName, 16);
        }

        @VisibleForTesting
        OpenHelper(Context context, LocalSerializer serializer, String databaseName, int schemaVersion) {
            super(context, databaseName, null, schemaVersion);
            this.serializer = serializer;
        }

        public void onConfigure(SQLiteDatabase db) {
            this.configured = true;
            Cursor cursor = db.rawQuery("PRAGMA locking_mode = EXCLUSIVE", new String[0]);
            cursor.close();
        }

        private void ensureConfigured(SQLiteDatabase db) {
            if (!this.configured) {
                this.onConfigure(db);
            }
        }

        public void onCreate(SQLiteDatabase db) {
            this.ensureConfigured(db);
            SQLiteSchema schema = new SQLiteSchema(db, this.serializer);
            schema.runSchemaUpgrades(0);
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            this.ensureConfigured(db);
            SQLiteSchema schema = new SQLiteSchema(db, this.serializer);
            schema.runSchemaUpgrades(oldVersion);
        }

        public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            this.ensureConfigured(db);
        }

        public void onOpen(SQLiteDatabase db) {
            this.ensureConfigured(db);
        }
    }
}

