/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model;

import com.google.firebase.firestore.model.BasePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class FieldPath
extends BasePath<FieldPath> {
    public static final FieldPath KEY_PATH = FieldPath.fromSingleSegment("__name__");
    public static final FieldPath EMPTY_PATH = new FieldPath(Collections.emptyList());

    private FieldPath(List<String> segments) {
        super(segments);
    }

    public static FieldPath fromSingleSegment(String fieldName) {
        return new FieldPath(Collections.singletonList(fieldName));
    }

    public static FieldPath fromSegments(List<String> segments) {
        return segments.isEmpty() ? EMPTY_PATH : new FieldPath(segments);
    }

    @Override
    FieldPath createPathWithSegments(List<String> segments) {
        return new FieldPath(segments);
    }

    public static FieldPath fromServerFormat(String path) {
        ArrayList<String> res = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        boolean inBackticks = false;
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '\\') {
                if (i + 1 == path.length()) {
                    throw new IllegalArgumentException("Trailing escape character is not allowed");
                }
                builder.append(path.charAt(++i));
                continue;
            }
            if (c == '.') {
                if (!inBackticks) {
                    String elem = builder.toString();
                    if (elem.isEmpty()) {
                        throw new IllegalArgumentException("Invalid field path (" + path + "). Paths must not be empty, begin with '.', end with '.', or contain '..'");
                    }
                    builder = new StringBuilder();
                    res.add(elem);
                    continue;
                }
                builder.append(c);
                continue;
            }
            if (c == '`') {
                inBackticks = !inBackticks;
                continue;
            }
            builder.append(c);
        }
        String lastElem = builder.toString();
        if (lastElem.isEmpty()) {
            throw new IllegalArgumentException("Invalid field path (" + path + "). Paths must not be empty, begin with '.', end with '.', or contain '..'");
        }
        res.add(lastElem);
        return new FieldPath(res);
    }

    private static boolean isValidIdentifier(String identifier) {
        if (identifier.isEmpty()) {
            return false;
        }
        char first = identifier.charAt(0);
        if (!(first == '_' || first >= 'a' && first <= 'z' || first >= 'A' && first <= 'Z')) {
            return false;
        }
        for (int i = 1; i < identifier.length(); ++i) {
            char c = identifier.charAt(i);
            if (c == '_' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    @Override
    public String canonicalString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.segments.size(); ++i) {
            if (i > 0) {
                builder.append(".");
            }
            String escaped = (String)this.segments.get(i);
            if (!FieldPath.isValidIdentifier(escaped = escaped.replace("\\", "\\\\").replace("`", "\\`"))) {
                escaped = '`' + escaped + '`';
            }
            builder.append(escaped);
        }
        return builder.toString();
    }

    public boolean isKeyField() {
        return this.equals(KEY_PATH);
    }
}

