/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import androidx.annotation.NonNull;
import com.google.firebase.firestore.MemoryGarbageCollectorSettings;

public final class MemoryLruGcSettings
implements MemoryGarbageCollectorSettings {
    private long sizeBytes;

    private MemoryLruGcSettings(long size) {
        this.sizeBytes = size;
    }

    @NonNull
    public static Builder newBuilder() {
        return new Builder();
    }

    public long getSizeBytes() {
        return this.sizeBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoryLruGcSettings that = (MemoryLruGcSettings)o;
        return this.sizeBytes == that.sizeBytes;
    }

    public int hashCode() {
        return (int)(this.sizeBytes ^ this.sizeBytes >>> 32);
    }

    @NonNull
    public String toString() {
        return "MemoryLruGcSettings{cacheSize=" + this.getSizeBytes() + "}";
    }

    public static class Builder {
        private long sizeBytes = 0x6400000L;

        private Builder() {
        }

        @NonNull
        public MemoryLruGcSettings build() {
            return new MemoryLruGcSettings(this.sizeBytes);
        }

        public void setSizeBytes(long size) {
            this.sizeBytes = size;
        }
    }
}

