/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model;

import androidx.annotation.Nullable;
import com.google.firebase.firestore.core.FieldFilter;
import com.google.firebase.firestore.core.Filter;
import com.google.firebase.firestore.core.OrderBy;
import com.google.firebase.firestore.core.Target;
import com.google.firebase.firestore.model.FieldIndex;
import com.google.firebase.firestore.util.Assert;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class TargetIndexMatcher {
    private final String collectionId;
    @Nullable
    private FieldFilter inequalityFilter;
    private final List<FieldFilter> equalityFilters;
    private final List<OrderBy> orderBys;

    public TargetIndexMatcher(Target target) {
        this.collectionId = target.getCollectionGroup() != null ? target.getCollectionGroup() : target.getPath().getLastSegment();
        this.orderBys = target.getOrderBy();
        this.inequalityFilter = null;
        this.equalityFilters = new ArrayList<FieldFilter>();
        for (Filter filter : target.getFilters()) {
            FieldFilter fieldFilter = (FieldFilter)filter;
            if (fieldFilter.isInequality()) {
                Assert.hardAssert(this.inequalityFilter == null || this.inequalityFilter.getField().equals(fieldFilter.getField()), "Only a single inequality is supported", new Object[0]);
                this.inequalityFilter = fieldFilter;
                continue;
            }
            this.equalityFilters.add(fieldFilter);
        }
    }

    public boolean servedByIndex(FieldIndex index) {
        FieldIndex.Segment segment;
        int segmentIndex;
        Assert.hardAssert(index.getCollectionGroup().equals(this.collectionId), "Collection IDs do not match", new Object[0]);
        FieldIndex.Segment arraySegment = index.getArraySegment();
        if (arraySegment != null && !this.hasMatchingEqualityFilter(arraySegment)) {
            return false;
        }
        Iterator<OrderBy> orderBys = this.orderBys.iterator();
        List<FieldIndex.Segment> segments = index.getDirectionalSegments();
        HashSet<String> equalitySegments = new HashSet<String>();
        for (segmentIndex = 0; segmentIndex < segments.size() && this.hasMatchingEqualityFilter(segments.get(segmentIndex)); ++segmentIndex) {
            equalitySegments.add(segments.get(segmentIndex).getFieldPath().canonicalString());
        }
        if (segmentIndex == segments.size()) {
            return true;
        }
        if (this.inequalityFilter != null) {
            if (!(equalitySegments.contains(this.inequalityFilter.getField().canonicalString()) || this.matchesFilter(this.inequalityFilter, segment = segments.get(segmentIndex)) && this.matchesOrderBy(orderBys.next(), segment))) {
                return false;
            }
            ++segmentIndex;
        }
        while (segmentIndex < segments.size()) {
            segment = segments.get(segmentIndex);
            if (!orderBys.hasNext() || !this.matchesOrderBy(orderBys.next(), segment)) {
                return false;
            }
            ++segmentIndex;
        }
        return true;
    }

    private boolean hasMatchingEqualityFilter(FieldIndex.Segment segment) {
        for (FieldFilter filter : this.equalityFilters) {
            if (!this.matchesFilter(filter, segment)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesFilter(@Nullable FieldFilter filter, FieldIndex.Segment segment) {
        if (filter == null || !filter.getField().equals(segment.getFieldPath())) {
            return false;
        }
        boolean isArrayOperator = filter.getOperator().equals((Object)FieldFilter.Operator.ARRAY_CONTAINS) || filter.getOperator().equals((Object)FieldFilter.Operator.ARRAY_CONTAINS_ANY);
        return segment.getKind().equals((Object)FieldIndex.Segment.Kind.CONTAINS) == isArrayOperator;
    }

    private boolean matchesOrderBy(OrderBy orderBy, FieldIndex.Segment segment) {
        if (!orderBy.getField().equals(segment.getFieldPath())) {
            return false;
        }
        return segment.getKind().equals((Object)FieldIndex.Segment.Kind.ASCENDING) && orderBy.getDirection().equals((Object)OrderBy.Direction.ASCENDING) || segment.getKind().equals((Object)FieldIndex.Segment.Kind.DESCENDING) && orderBy.getDirection().equals((Object)OrderBy.Direction.DESCENDING);
    }
}

