/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.remote;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.firestore.remote.ConnectivityMonitor;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Consumer;
import com.google.firebase.firestore.util.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public final class AndroidConnectivityMonitor
implements ConnectivityMonitor {
    private static final String LOG_TAG = "AndroidConnectivityMonitor";
    private final Context context;
    @Nullable
    private final ConnectivityManager connectivityManager;
    @Nullable
    private Runnable unregisterRunnable;
    private final List<Consumer<ConnectivityMonitor.NetworkStatus>> callbacks = new ArrayList<Consumer<ConnectivityMonitor.NetworkStatus>>();

    public AndroidConnectivityMonitor(Context context) {
        Assert.hardAssert(context != null, "Context must be non-null", new Object[0]);
        this.context = context;
        this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.configureBackgroundStateListener();
        this.configureNetworkMonitoring();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCallback(Consumer<ConnectivityMonitor.NetworkStatus> callback) {
        List<Consumer<ConnectivityMonitor.NetworkStatus>> list = this.callbacks;
        synchronized (list) {
            this.callbacks.add(callback);
        }
    }

    @Override
    public void shutdown() {
        if (this.unregisterRunnable != null) {
            this.unregisterRunnable.run();
            this.unregisterRunnable = null;
        }
    }

    private void configureNetworkMonitoring() {
        if (Build.VERSION.SDK_INT >= 24 && this.connectivityManager != null) {
            DefaultNetworkCallback defaultNetworkCallback = new DefaultNetworkCallback();
            this.connectivityManager.registerDefaultNetworkCallback((ConnectivityManager.NetworkCallback)defaultNetworkCallback);
            this.unregisterRunnable = () -> this.connectivityManager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)defaultNetworkCallback);
        } else {
            NetworkReceiver networkReceiver = new NetworkReceiver();
            IntentFilter networkIntentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            this.context.registerReceiver((BroadcastReceiver)networkReceiver, networkIntentFilter);
            this.unregisterRunnable = () -> this.context.unregisterReceiver((BroadcastReceiver)networkReceiver);
        }
    }

    private void configureBackgroundStateListener() {
        Application application = (Application)this.context.getApplicationContext();
        final AtomicBoolean inBackground = new AtomicBoolean();
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(@NonNull Activity activity, Bundle savedInstanceState) {
                if (inBackground.compareAndSet(true, false)) {
                    AndroidConnectivityMonitor.this.raiseForegroundNotification();
                }
            }

            public void onActivityStarted(@NonNull Activity activity) {
                if (inBackground.compareAndSet(true, false)) {
                    AndroidConnectivityMonitor.this.raiseForegroundNotification();
                }
            }

            public void onActivityResumed(@NonNull Activity activity) {
                if (inBackground.compareAndSet(true, false)) {
                    AndroidConnectivityMonitor.this.raiseForegroundNotification();
                }
            }

            public void onActivityPaused(@NonNull Activity activity) {
            }

            public void onActivityStopped(@NonNull Activity activity) {
            }

            public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
            }

            public void onActivityDestroyed(@NonNull Activity activity) {
            }
        });
        application.registerComponentCallbacks((ComponentCallbacks)new ComponentCallbacks2(){

            public void onTrimMemory(int level) {
                if (level == 20) {
                    inBackground.set(true);
                }
            }

            public void onConfigurationChanged(@NonNull Configuration newConfig) {
            }

            public void onLowMemory() {
            }
        });
    }

    public void raiseForegroundNotification() {
        Logger.debug(LOG_TAG, "App has entered the foreground.", new Object[0]);
        if (this.isConnected()) {
            this.raiseCallbacks(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void raiseCallbacks(boolean connected) {
        List<Consumer<ConnectivityMonitor.NetworkStatus>> list = this.callbacks;
        synchronized (list) {
            for (Consumer<ConnectivityMonitor.NetworkStatus> callback : this.callbacks) {
                callback.accept(connected ? ConnectivityMonitor.NetworkStatus.REACHABLE : ConnectivityMonitor.NetworkStatus.UNREACHABLE);
            }
        }
    }

    private boolean isConnected() {
        ConnectivityManager conn = (ConnectivityManager)this.context.getSystemService("connectivity");
        NetworkInfo networkInfo = conn.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    @TargetApi(value=24)
    private class DefaultNetworkCallback
    extends ConnectivityManager.NetworkCallback {
        private DefaultNetworkCallback() {
        }

        public void onAvailable(Network network) {
            AndroidConnectivityMonitor.this.raiseCallbacks(true);
        }

        public void onLost(Network network) {
            AndroidConnectivityMonitor.this.raiseCallbacks(false);
        }
    }

    private class NetworkReceiver
    extends BroadcastReceiver {
        private boolean wasConnected = false;

        private NetworkReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            boolean isConnected = AndroidConnectivityMonitor.this.isConnected();
            if (AndroidConnectivityMonitor.this.isConnected() && !this.wasConnected) {
                AndroidConnectivityMonitor.this.raiseCallbacks(true);
            } else if (!isConnected && this.wasConnected) {
                AndroidConnectivityMonitor.this.raiseCallbacks(false);
            }
            this.wasConnected = isConnected;
        }
    }
}

