/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.installations.lint;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Dependencies;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.Variant;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\f"}, d2={"Lcom/google/firebase/installations/lint/IncompatibleIidVersionDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "()V", "beforeCheckEachProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "isCompatibleVersion", "", "coordinates", "Lcom/android/builder/model/MavenCoordinates;", "Issues", "customer-lint-checks"})
public final class IncompatibleIidVersionDetector
extends Detector {
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue INCOMPATIBLE_IID_VERSION;
    public static final Issues Issues;

    public void beforeCheckEachProject(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!context.getProject().isGradleProject()) {
            return;
        }
        AndroidProject androidProject = context.getProject().getGradleProjectModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)androidProject, (String)"context.project.gradleProjectModel");
        Iterator iterator = androidProject.getVariants().iterator();
        while (iterator.hasNext()) {
            Variant variant;
            Variant variant2 = variant = (Variant)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)variant2, (String)"variant");
            AndroidArtifact androidArtifact = variant2.getMainArtifact();
            Intrinsics.checkExpressionValueIsNotNull((Object)androidArtifact, (String)"variant.mainArtifact");
            Dependencies dependencies = androidArtifact.getDependencies();
            Intrinsics.checkExpressionValueIsNotNull((Object)dependencies, (String)"variant.mainArtifact.dependencies");
            Iterator iterator2 = dependencies.getLibraries().iterator();
            while (iterator2.hasNext()) {
                MavenCoordinates coordinates;
                AndroidLibrary lib;
                AndroidLibrary androidLibrary = lib = (AndroidLibrary)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)androidLibrary, (String)"lib");
                MavenCoordinates mavenCoordinates = coordinates = androidLibrary.getResolvedCoordinates();
                Intrinsics.checkExpressionValueIsNotNull((Object)mavenCoordinates, (String)"coordinates");
                if (!Intrinsics.areEqual((Object)mavenCoordinates.getGroupId(), (Object)"com.google.firebase") || !Intrinsics.areEqual((Object)coordinates.getArtifactId(), (Object)"firebase-iid") || this.isCompatibleVersion(coordinates)) continue;
                Location location = Location.Companion.create(context.file);
                StringBuilder stringBuilder = new StringBuilder().append("Incompatible IID version found in variant ").append(variant.getName()).append(": ");
                String string = lib.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lib.name");
                Context.report$default((Context)context, (Issue)INCOMPATIBLE_IID_VERSION, (Location)location, (String)stringBuilder.append(StringsKt.removeSuffix((String)string, (CharSequence)"@aar")).append(".\n").append("To resolve this issue, consider updating the build file to the latest firebase-iid version.").toString(), null, (int)8, null);
            }
        }
    }

    private final boolean isCompatibleVersion(MavenCoordinates coordinates) {
        Collection $receiver$iv;
        String string = coordinates.getVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"coordinates.version");
        Object object = new char[]{'.'};
        boolean bl = false;
        int n = 3;
        Collection collection = $receiver$iv = (Collection)StringsKt.split$default((CharSequence)string, (char[])object, (boolean)bl, (int)n, (int)2, null);
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        int n2 = 20;
        String[] versionComponents = stringArray;
        object = versionComponents[0];
        int n3 = Integer.parseInt((String)object);
        if (n2 > n3) {
            return false;
        }
        n2 = 21;
        object = versionComponents[0];
        n3 = Integer.parseInt((String)object);
        if (n2 <= n3) {
            return true;
        }
        n2 = 1;
        object = versionComponents[1];
        n3 = Integer.parseInt((String)object);
        return n2 <= n3;
    }

    static {
        Issues = new Issues(null);
        IMPLEMENTATION = new Implementation(IncompatibleIidVersionDetector.class, EnumSet.noneOf(Scope.class));
        INCOMPATIBLE_IID_VERSION = Issue.Companion.create("IncompatibleIidVersion", "FirebaseInstanceId version is not compatible with FirebaseInstallations", "\n           These versions of FirebaseInstanceId and FirebaseInstallations can not be used in parallel.\n           Please update your Firebase Instance ID to a version 20.1.1 or later.\n            ", Category.INTEROPERABILITY, 1, Severity.ERROR, IMPLEMENTATION);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/google/firebase/installations/lint/IncompatibleIidVersionDetector$Issues;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "INCOMPATIBLE_IID_VERSION", "Lcom/android/tools/lint/detector/api/Issue;", "customer-lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

