/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.messaging.zza;
import com.google.firebase.messaging.zzc;
import java.util.Map;

public final class RemoteMessage
extends com.google.android.gms.common.internal.safeparcel.zza {
    public static final Parcelable.Creator<RemoteMessage> CREATOR = new zzc();
    final int mVersionCode;
    Bundle zzahb;
    private Map<String, String> zzabb;
    private Notification zzcjr;

    RemoteMessage(int n, Bundle bundle) {
        this.mVersionCode = n;
        this.zzahb = bundle;
    }

    RemoteMessage(Bundle bundle) {
        this(1, bundle);
    }

    void zzL(Intent intent) {
        intent.putExtras(this.zzahb);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzc.zza(this, parcel, n);
    }

    public String getFrom() {
        return this.zzahb.getString("from");
    }

    public String getTo() {
        return this.zzahb.getString("google.to");
    }

    public Map<String, String> getData() {
        if (this.zzabb == null) {
            this.zzabb = new ArrayMap();
            for (String string : this.zzahb.keySet()) {
                Object object = this.zzahb.get(string);
                if (!(object instanceof String)) continue;
                String string2 = (String)object;
                if (string.startsWith("google.") || string.startsWith("gcm.") || string.equals("from") || string.equals("message_type") || string.equals("collapse_key")) continue;
                this.zzabb.put(string, string2);
            }
        }
        return this.zzabb;
    }

    public String getCollapseKey() {
        return this.zzahb.getString("collapse_key");
    }

    public String getMessageId() {
        String string = this.zzahb.getString("google.message_id");
        if (string == null) {
            string = this.zzahb.getString("message_id");
        }
        return string;
    }

    public String getMessageType() {
        return this.zzahb.getString("message_type");
    }

    public long getSentTime() {
        Object object = this.zzahb.get("google.sent_time");
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(19 + String.valueOf(string).length()).append("Invalid sent time: ").append(string).toString());
            }
        }
        return 0L;
    }

    public int getTtl() {
        Object object = this.zzahb.get("google.ttl");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(13 + String.valueOf(string).length()).append("Invalid TTL: ").append(string).toString());
            }
        }
        return 0;
    }

    public Notification getNotification() {
        if (this.zzcjr == null && zza.zzE(this.zzahb)) {
            this.zzcjr = new Notification(this.zzahb);
        }
        return this.zzcjr;
    }

    public static class Notification {
        private final String zzalD;
        private final String zzcjs;
        private final String[] zzcjt;
        private final String zzFU;
        private final String zzcju;
        private final String[] zzcjv;
        private final String zzcjw;
        private final String zzcjx;
        private final String mTag;
        private final String zzaPp;
        private final String zzcjy;

        private Notification(Bundle bundle) {
            this.zzalD = zza.zzf(bundle, "gcm.n.title");
            this.zzcjs = zza.zzh(bundle, "gcm.n.title");
            this.zzcjt = this.zzj(bundle, "gcm.n.title");
            this.zzFU = zza.zzf(bundle, "gcm.n.body");
            this.zzcju = zza.zzh(bundle, "gcm.n.body");
            this.zzcjv = this.zzj(bundle, "gcm.n.body");
            this.zzcjw = zza.zzf(bundle, "gcm.n.icon");
            this.zzcjx = zza.zzU(bundle);
            this.mTag = zza.zzf(bundle, "gcm.n.tag");
            this.zzaPp = zza.zzf(bundle, "gcm.n.color");
            this.zzcjy = zza.zzf(bundle, "gcm.n.click_action");
        }

        private String[] zzj(Bundle bundle, String string) {
            Object[] objectArray = zza.zzi(bundle, string);
            if (objectArray == null) {
                return null;
            }
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = String.valueOf(objectArray[i]);
            }
            return stringArray;
        }

        public String getTitle() {
            return this.zzalD;
        }

        public String getTitleLocalizationKey() {
            return this.zzcjs;
        }

        public String[] getTitleLocalizationArgs() {
            return this.zzcjt;
        }

        public String getBody() {
            return this.zzFU;
        }

        public String getBodyLocalizationKey() {
            return this.zzcju;
        }

        public String[] getBodyLocalizationArgs() {
            return this.zzcjv;
        }

        public String getIcon() {
            return this.zzcjw;
        }

        public String getSound() {
            return this.zzcjx;
        }

        public String getTag() {
            return this.mTag;
        }

        public String getColor() {
            return this.zzaPp;
        }

        public String getClickAction() {
            return this.zzcjy;
        }
    }

    public static class Builder {
        private final Bundle zzahb = new Bundle();
        private final Map<String, String> zzabb = new ArrayMap();

        public Builder(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                String string2 = String.valueOf(string);
                throw new IllegalArgumentException(string2.length() != 0 ? "Invalid to: ".concat(string2) : new String("Invalid to: "));
            }
            this.zzahb.putString("google.to", string);
        }

        public RemoteMessage build() {
            Bundle bundle = new Bundle();
            for (Map.Entry<String, String> entry : this.zzabb.entrySet()) {
                bundle.putString(entry.getKey(), entry.getValue());
            }
            bundle.putAll(this.zzahb);
            String string = FirebaseInstanceId.getInstance().getToken();
            if (string != null) {
                this.zzahb.putString("from", string);
            } else {
                this.zzahb.remove("from");
            }
            return new RemoteMessage(bundle);
        }

        public Builder addData(String string, String string2) {
            this.zzabb.put(string, string2);
            return this;
        }

        public Builder setData(Map<String, String> map) {
            this.zzabb.clear();
            this.zzabb.putAll(map);
            return this;
        }

        public Builder clearData() {
            this.zzabb.clear();
            return this;
        }

        public Builder setMessageId(String string) {
            this.zzahb.putString("google.message_id", string);
            return this;
        }

        public Builder setMessageType(String string) {
            this.zzahb.putString("message_type", string);
            return this;
        }

        public Builder setTtl(int n) {
            this.zzahb.putString("google.ttl", String.valueOf(n));
            return this;
        }

        public Builder setCollapseKey(String string) {
            this.zzahb.putString("collapse_key", string);
            return this;
        }
    }
}

