/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.messaging.RemoteMessage;
import java.util.regex.Pattern;

public class FirebaseMessaging {
    public static final String INSTANCE_ID_SCOPE = "FCM";
    private static final Pattern zzolx = Pattern.compile("[a-zA-Z0-9-_.~%]{1,900}");
    private static FirebaseMessaging zzoly;
    private final FirebaseInstanceId zzolz;

    public static synchronized FirebaseMessaging getInstance() {
        if (zzoly == null) {
            zzoly = new FirebaseMessaging(FirebaseInstanceId.getInstance());
        }
        return zzoly;
    }

    private FirebaseMessaging(FirebaseInstanceId firebaseInstanceId) {
        this.zzolz = firebaseInstanceId;
    }

    public boolean isAutoInitEnabled() {
        return this.zzolz.zzclk();
    }

    public void setAutoInitEnabled(boolean bl) {
        this.zzolz.zzcz(bl);
    }

    public void subscribeToTopic(String string2) {
        if (string2 != null && string2.startsWith("/topics/")) {
            Log.w((String)"FirebaseMessaging", (String)"Format /topics/topic-name is deprecated. Only 'topic-name' should be used in subscribeToTopic.");
            string2 = string2.substring(8);
        }
        if (string2 == null || !zzolx.matcher(string2).matches()) {
            String string3 = string2;
            throw new IllegalArgumentException(new StringBuilder(78 + String.valueOf(string3).length()).append("Invalid topic name: ").append(string3).append(" does not match the allowed format [a-zA-Z0-9-_.~%]{1,900}").toString());
        }
        String string4 = String.valueOf("S!");
        String string5 = String.valueOf(string2);
        this.zzolz.zzrl(string5.length() != 0 ? string4.concat(string5) : new String(string4));
    }

    public void unsubscribeFromTopic(String string2) {
        if (string2 != null && string2.startsWith("/topics/")) {
            Log.w((String)"FirebaseMessaging", (String)"Format /topics/topic-name is deprecated. Only 'topic-name' should be used in unsubscribeFromTopic.");
            string2 = string2.substring(8);
        }
        if (string2 == null || !zzolx.matcher(string2).matches()) {
            String string3 = string2;
            throw new IllegalArgumentException(new StringBuilder(78 + String.valueOf(string3).length()).append("Invalid topic name: ").append(string3).append(" does not match the allowed format [a-zA-Z0-9-_.~%]{1,900}").toString());
        }
        String string4 = String.valueOf("U!");
        String string5 = String.valueOf(string2);
        this.zzolz.zzrl(string5.length() != 0 ? string4.concat(string5) : new String(string4));
    }

    public void send(RemoteMessage remoteMessage) {
        if (TextUtils.isEmpty((CharSequence)remoteMessage.getTo())) {
            throw new IllegalArgumentException("Missing 'to'");
        }
        Context context = FirebaseApp.getInstance().getApplicationContext();
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        Intent intent2 = new Intent();
        intent2.setPackage("com.google.example.invalidpackage");
        intent.putExtra("app", (Parcelable)PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent2, (int)0));
        intent.setPackage("com.google.android.gms");
        Intent intent3 = intent;
        RemoteMessage remoteMessage2 = remoteMessage;
        intent3.putExtras(remoteMessage2.mBundle);
        context.sendOrderedBroadcast(intent, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
    }
}

