/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.Process;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.firebase.iid.zzav;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.R;
import java.util.Arrays;
import java.util.MissingFormatArgumentException;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONException;

final class zza {
    private static final AtomicInteger zzdn = new AtomicInteger((int)SystemClock.elapsedRealtime());
    private final Context zzx;
    private Bundle zzdo;

    public zza(Context context) {
        this.zzx = context.getApplicationContext();
    }

    static boolean zzf(Bundle bundle) {
        return "1".equals(zza.zza(bundle, "gcm.n.e")) || zza.zza(bundle, "gcm.n.icon") != null;
    }

    static String zza(Bundle bundle, String string2) {
        String string3 = bundle.getString(string2);
        if (string3 == null) {
            string3 = bundle.getString(string2.replace("gcm.n.", "gcm.notification."));
        }
        return string3;
    }

    static String zzb(Bundle bundle, String string2) {
        String string3 = String.valueOf(string2);
        String string4 = String.valueOf("_loc_key");
        return zza.zza(bundle, string4.length() != 0 ? string3.concat(string4) : new String(string3));
    }

    static Object[] zzc(Bundle bundle, String string2) {
        String string3 = String.valueOf(string2);
        String string4 = String.valueOf("_loc_args");
        String string5 = zza.zza(bundle, string4.length() != 0 ? string3.concat(string4) : new String(string3));
        if (TextUtils.isEmpty((CharSequence)string5)) {
            return null;
        }
        try {
            JSONArray jSONArray = new JSONArray(string5);
            Object[] objectArray = new String[jSONArray.length()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = jSONArray.opt(i);
            }
            return objectArray;
        }
        catch (JSONException jSONException) {
            String string6 = String.valueOf(string2);
            String string7 = String.valueOf("_loc_args");
            String string8 = string7.length() != 0 ? string6.concat(string7) : new String(string6);
            String string9 = string8.substring(6);
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(41 + String.valueOf(string9).length() + String.valueOf(string5).length()).append("Malformed ").append(string9).append(": ").append(string5).append("  Default value will be used.").toString());
            return null;
        }
    }

    @Nullable
    static Uri zzg(@NonNull Bundle bundle) {
        String string2 = zza.zza(bundle, "gcm.n.link_android");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = zza.zza(bundle, "gcm.n.link");
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return Uri.parse((String)string2);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    final boolean zzh(Bundle var1_1) {
        block37: {
            block42: {
                block40: {
                    block41: {
                        block38: {
                            block39: {
                                block36: {
                                    if ("1".equals(zza.zza(var1_1, "gcm.n.noui"))) {
                                        return true;
                                    }
                                    var3_2 = this;
                                    if (((KeyguardManager)var3_2.zzx.getSystemService("keyguard")).inKeyguardRestrictedInputMode()) ** GOTO lbl-1000
                                    if (!PlatformVersion.isAtLeastLollipop()) {
                                        SystemClock.sleep((long)10L);
                                    }
                                    var5_3 = Process.myPid();
                                    var7_5 = ((ActivityManager)var3_2.zzx.getSystemService("activity")).getRunningAppProcesses();
                                    if (var7_5 != null) {
                                        for (ActivityManager.RunningAppProcessInfo var9_9 : var7_5) {
                                            if (var9_9.pid != var5_3) continue;
                                            v0 = var9_9.importance == 100;
                                            break;
                                        }
                                    } else lbl-1000:
                                    // 3 sources

                                    {
                                        v0 = false;
                                    }
                                    if (v0) {
                                        return false;
                                    }
                                    var3_2 = this;
                                    var4_10 /* !! */  = var1_1;
                                    var5_4 /* !! */  = var3_2.zzd(var4_10 /* !! */ , "gcm.n.title");
                                    if (TextUtils.isEmpty((CharSequence)var5_4 /* !! */ )) {
                                        var5_4 /* !! */  = var3_2.zzx.getApplicationInfo().loadLabel(var3_2.zzx.getPackageManager());
                                    }
                                    var6_11 = var3_2.zzd(var4_10 /* !! */ , "gcm.n.body");
                                    var14_12 = zza.zza(var4_10 /* !! */ , "gcm.n.icon");
                                    var13_13 = var3_2;
                                    if (TextUtils.isEmpty((CharSequence)var14_12)) ** GOTO lbl37
                                    var15_14 /* !! */  = var13_13.zzx.getResources();
                                    var16_16 = var15_14 /* !! */ .getIdentifier(var14_12, "drawable", var13_13.zzx.getPackageName());
                                    if (var16_16 != 0 && var13_13.zzb(var16_16)) {
                                        v1 = var16_16;
                                    } else {
                                        var16_16 = var15_14 /* !! */ .getIdentifier(var14_12, "mipmap", var13_13.zzx.getPackageName());
                                        if (var16_16 != 0 && var13_13.zzb(var16_16)) {
                                            v1 = var16_16;
                                        } else {
                                            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(61 + String.valueOf(var14_12).length()).append("Icon resource ").append(var14_12).append(" not found. Notification will use default icon.").toString());
lbl37:
                                            // 2 sources

                                            if ((var15_15 = var13_13.zzas().getInt("com.google.firebase.messaging.default_notification_icon", 0)) == 0 || !var13_13.zzb(var15_15)) {
                                                var15_15 = var13_13.zzx.getApplicationInfo().icon;
                                            }
                                            if (var15_15 == 0 || !var13_13.zzb(var15_15)) {
                                                var15_15 = 17301651;
                                            }
                                            v1 = var15_15;
                                        }
                                    }
                                    var7_6 = v1;
                                    var8_8 = var3_2.zzl(zza.zza(var4_10 /* !! */ , "gcm.n.color"));
                                    var14_12 = zza.zzi(var4_10 /* !! */ );
                                    var13_13 = var3_2;
                                    if (TextUtils.isEmpty((CharSequence)var14_12)) {
                                        v2 = null;
                                    } else if (!"default".equals(var14_12) && var13_13.zzx.getResources().getIdentifier(var14_12, "raw", var13_13.zzx.getPackageName()) != 0) {
                                        var17_21 = var13_13.zzx.getPackageName();
                                        v2 = Uri.parse((String)new StringBuilder(24 + String.valueOf(var17_21).length() + String.valueOf(var14_12).length()).append("android.resource://").append((String)var17_21).append("/raw/").append(var14_12).toString());
                                    } else {
                                        v2 = RingtoneManager.getDefaultUri((int)2);
                                    }
                                    var9_9 = v2;
                                    var14_12 = var4_10 /* !! */ ;
                                    var13_13 = var3_2;
                                    var19_22 = var14_12;
                                    var18_23 = var13_13;
                                    var20_24 = zza.zza((Bundle)var19_22, "gcm.n.click_action");
                                    if (!TextUtils.isEmpty((CharSequence)var20_24)) {
                                        var21_25 = new Intent(var20_24);
                                        var21_25.setPackage(var18_23.zzx.getPackageName());
                                        var21_25.setFlags(0x10000000);
                                        v3 = var21_25;
                                    } else {
                                        var21_25 = zza.zzg((Bundle)var19_22);
                                        if (var21_25 != null) {
                                            var22_26 = new Intent("android.intent.action.VIEW");
                                            var22_26.setPackage(var18_23.zzx.getPackageName());
                                            var22_26.setData(var21_25);
                                            v3 = var22_26;
                                        } else {
                                            var23_27 = var18_23.zzx.getPackageManager().getLaunchIntentForPackage(var18_23.zzx.getPackageName());
                                            if (var23_27 == null) {
                                                Log.w((String)"FirebaseMessaging", (String)"No activity found to launch app");
                                            }
                                            v3 = var15_14 /* !! */  = var23_27;
                                        }
                                    }
                                    if (v3 == null) {
                                        v4 = null;
                                    } else {
                                        var15_14 /* !! */ .addFlags(0x4000000);
                                        var14_12 = new Bundle((Bundle)var14_12);
                                        FirebaseMessagingService.zzj((Bundle)var14_12);
                                        var15_14 /* !! */ .putExtras((Bundle)var14_12);
                                        for (Object var17_21 : var14_12.keySet()) {
                                            if (!var17_21.startsWith("gcm.n.") && !var17_21.startsWith("gcm.notification.")) continue;
                                            var15_14 /* !! */ .removeExtra((String)var17_21);
                                        }
                                        v4 = PendingIntent.getActivity((Context)var13_13.zzx, (int)zza.zzdn.incrementAndGet(), (Intent)var15_14 /* !! */ , (int)0x40000000);
                                    }
                                    var10_28 = v4;
                                    var11_29 = null;
                                    var13_13 = var4_10 /* !! */ ;
                                    if (var13_13 == null ? false : "1".equals(var13_13.getString("google.c.a.e"))) {
                                        var15_14 /* !! */  = var10_28;
                                        var14_12 = var4_10 /* !! */ ;
                                        var13_13 = var3_2;
                                        var16_18 = new Intent("com.google.firebase.messaging.NOTIFICATION_OPEN");
                                        zza.zza(var16_18, (Bundle)var14_12);
                                        var16_18.putExtra("pending_intent", (Parcelable)var15_14 /* !! */ );
                                        var10_28 = zzav.zza((Context)var13_13.zzx, (int)zza.zzdn.incrementAndGet(), (Intent)var16_18, (int)0x40000000);
                                        var14_12 = var4_10 /* !! */ ;
                                        var13_13 = var3_2;
                                        var15_14 /* !! */  = new Intent("com.google.firebase.messaging.NOTIFICATION_DISMISS");
                                        zza.zza((Intent)var15_14 /* !! */ , (Bundle)var14_12);
                                        var11_29 = zzav.zza((Context)var13_13.zzx, (int)zza.zzdn.incrementAndGet(), (Intent)var15_14 /* !! */ , (int)0x40000000);
                                    }
                                    var14_12 = zza.zza(var4_10 /* !! */ , "gcm.n.android_channel_id");
                                    var13_13 = var3_2;
                                    if (PlatformVersion.isAtLeastO() && var13_13.zzx.getApplicationInfo().targetSdkVersion >= 26) break block36;
                                    v5 = null;
                                    break block37;
                                }
                                var15_14 /* !! */  = (NotificationManager)var13_13.zzx.getSystemService(NotificationManager.class);
                                if (TextUtils.isEmpty((CharSequence)var14_12)) break block38;
                                if (var15_14 /* !! */ .getNotificationChannel(var14_12) == null) break block39;
                                v5 = var14_12;
                                break block37;
                            }
                            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(122 + String.valueOf(var14_12).length()).append("Notification Channel requested (").append(var14_12).append(") has not been created by the app. Manifest configuration, or default, value will be used.").toString());
                        }
                        if (TextUtils.isEmpty((CharSequence)(var16_19 = var13_13.zzas().getString("com.google.firebase.messaging.default_notification_channel_id")))) break block40;
                        if (var15_14 /* !! */ .getNotificationChannel(var16_19) == null) break block41;
                        v5 = var16_19;
                        break block37;
                    }
                    Log.w((String)"FirebaseMessaging", (String)"Notification Channel set in AndroidManifest.xml has not been created by the app. Default value will be used.");
                    break block42;
                }
                Log.w((String)"FirebaseMessaging", (String)"Missing Default Notification Channel metadata in AndroidManifest. Default value will be used.");
            }
            if (var15_14 /* !! */ .getNotificationChannel("fcm_fallback_notification_channel") == null) {
                var15_14 /* !! */ .createNotificationChannel(new NotificationChannel("fcm_fallback_notification_channel", (CharSequence)var13_13.zzx.getString(R.string.fcm_fallback_notification_channel_label), 3));
            }
            v5 = "fcm_fallback_notification_channel";
        }
        var12_30 = v5;
        var21_25 = var12_30;
        var20_24 = var11_29;
        var19_22 = var10_28;
        var18_23 = var9_9;
        var17_21 = var8_8;
        var16_20 = var7_6;
        var15_14 /* !! */  = var6_11;
        var14_12 = var5_4 /* !! */ ;
        var13_13 = var3_2;
        var22_26 = new NotificationCompat.Builder(var13_13.zzx).setAutoCancel(true).setSmallIcon(var16_20);
        if (!TextUtils.isEmpty((CharSequence)var14_12)) {
            var22_26.setContentTitle((CharSequence)var14_12);
        }
        if (!TextUtils.isEmpty((CharSequence)var15_14 /* !! */ )) {
            var22_26.setContentText((CharSequence)var15_14 /* !! */ );
            var22_26.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)var15_14 /* !! */ ));
        }
        if (var17_21 != null) {
            var22_26.setColor(var17_21.intValue());
        }
        if (var18_23 != null) {
            var22_26.setSound((Uri)var18_23);
        }
        if (var19_22 != null) {
            var22_26.setContentIntent((PendingIntent)var19_22);
        }
        if (var20_24 != null) {
            var22_26.setDeleteIntent((PendingIntent)var20_24);
        }
        if (var21_25 != null) {
            var22_26.setChannelId((String)var21_25);
        }
        var2_31 = var22_26.build();
        var5_4 /* !! */  = var2_31;
        var4_10 /* !! */  = zza.zza(var1_1, "gcm.n.tag");
        var3_2 = this;
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)"Showing notification");
        }
        var6_11 = (NotificationManager)var3_2.zzx.getSystemService("notification");
        if (TextUtils.isEmpty((CharSequence)var4_10 /* !! */ )) {
            var7_7 = SystemClock.uptimeMillis();
            var4_10 /* !! */  = new StringBuilder(37).append("FCM-Notification:").append(var7_7).toString();
        }
        var6_11.notify((String)var4_10 /* !! */ , 0, (Notification)var5_4 /* !! */ );
        return true;
    }

    private final String zzd(Bundle bundle, String string2) {
        String string3 = zza.zza(bundle, string2);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            return string3;
        }
        String string4 = zza.zzb(bundle, string2);
        if (TextUtils.isEmpty((CharSequence)string4)) {
            return null;
        }
        Resources resources = this.zzx.getResources();
        int n = resources.getIdentifier(string4, "string", this.zzx.getPackageName());
        if (n == 0) {
            String string5 = String.valueOf(string2);
            String string6 = String.valueOf("_loc_key");
            String string7 = string6.length() != 0 ? string5.concat(string6) : new String(string5);
            String string8 = string7.substring(6);
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(49 + String.valueOf(string8).length() + String.valueOf(string4).length()).append(string8).append(" resource not found: ").append(string4).append(" Default value will be used.").toString());
            return null;
        }
        Object[] objectArray = zza.zzc(bundle, string2);
        if (objectArray == null) {
            return resources.getString(n);
        }
        try {
            return resources.getString(n, objectArray);
        }
        catch (MissingFormatArgumentException missingFormatArgumentException) {
            String string9 = Arrays.toString(objectArray);
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(58 + String.valueOf(string4).length() + String.valueOf(string9).length()).append("Missing format argument for ").append(string4).append(": ").append(string9).append(" Default value will be used.").toString(), (Throwable)missingFormatArgumentException);
            return null;
        }
    }

    @TargetApi(value=26)
    private final boolean zzb(int n) {
        if (Build.VERSION.SDK_INT != 26) {
            return true;
        }
        try {
            if (this.zzx.getResources().getDrawable(n, null) instanceof AdaptiveIconDrawable) {
                Log.e((String)"FirebaseMessaging", (String)new StringBuilder(77).append("Adaptive icons cannot be used in notifications. Ignoring icon id: ").append(n).toString());
                return false;
            }
            return true;
        }
        catch (Resources.NotFoundException notFoundException) {
            return false;
        }
    }

    private final Integer zzl(String string2) {
        int n;
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                return Color.parseColor((String)string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(54 + String.valueOf(string2).length()).append("Color ").append(string2).append(" not valid. Notification will use default color.").toString());
            }
        }
        if ((n = this.zzas().getInt("com.google.firebase.messaging.default_notification_color", 0)) != 0) {
            try {
                return ContextCompat.getColor((Context)this.zzx, (int)n);
            }
            catch (Resources.NotFoundException notFoundException) {
                Log.w((String)"FirebaseMessaging", (String)"Cannot find the color resource referenced in AndroidManifest.");
            }
        }
        return null;
    }

    static String zzi(Bundle bundle) {
        String string2 = zza.zza(bundle, "gcm.n.sound2");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = zza.zza(bundle, "gcm.n.sound");
        }
        return string2;
    }

    private static void zza(Intent intent, Bundle bundle) {
        for (String string2 : bundle.keySet()) {
            if (!string2.startsWith("google.c.a.") && !string2.equals("from")) continue;
            intent.putExtra(string2, bundle.getString(string2));
        }
    }

    private final Bundle zzas() {
        if (this.zzdo != null) {
            return this.zzdo;
        }
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = this.zzx.getPackageManager().getApplicationInfo(this.zzx.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        if (applicationInfo != null && applicationInfo.metaData != null) {
            this.zzdo = applicationInfo.metaData;
            return this.zzdo;
        }
        return Bundle.EMPTY;
    }
}

