/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_messaging;

import android.annotation.TargetApi;
import android.content.res.Resources;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase_messaging.zzac;
import org.json.JSONArray;
import org.json.JSONException;

public final class zzq {
    final String zzeo;
    private final Bundle zzcl;

    public zzq(String string, Bundle bundle) {
        this.zzeo = (String)Preconditions.checkNotNull((Object)string);
        this.zzcl = (Bundle)Preconditions.checkNotNull((Object)bundle);
    }

    public final String[] zzn(String string) {
        Object[] objectArray = this.zzo(string);
        if (objectArray == null) {
            return null;
        }
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = String.valueOf(objectArray[i]);
        }
        return stringArray;
    }

    public final String getString(String string) {
        return zzac.zza(this.zzcl, string);
    }

    private final Object[] zzo(String string) {
        String string2 = String.valueOf(string);
        String string3 = String.valueOf("_loc_args");
        String string4 = zzac.zza(this.zzcl, string3.length() != 0 ? string2.concat(string3) : new String(string2));
        if (TextUtils.isEmpty((CharSequence)string4)) {
            return null;
        }
        try {
            JSONArray jSONArray = new JSONArray(string4);
            Object[] objectArray = new String[jSONArray.length()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = jSONArray.opt(i);
            }
            return objectArray;
        }
        catch (JSONException jSONException) {
            String string5 = String.valueOf(string);
            String string6 = String.valueOf("_loc_args");
            String string7 = (string6.length() != 0 ? string5.concat(string6) : new String(string5)).substring(6);
            Log.w((String)this.zzeo, (String)new StringBuilder(41 + String.valueOf(string7).length() + String.valueOf(string4).length()).append("Malformed ").append(string7).append(": ").append(string4).append("  Default value will be used.").toString());
            return null;
        }
    }

    public final String zzp(String string) {
        String string2 = String.valueOf(string);
        String string3 = String.valueOf("_loc_key");
        return zzac.zza(this.zzcl, string3.length() != 0 ? string2.concat(string3) : new String(string2));
    }

    public final String zzav() {
        return this.zza("gcm.n.sound2", "gcm.n.sound");
    }

    @TargetApi(value=26)
    final boolean zza(Resources resources, int n) {
        if (Build.VERSION.SDK_INT != 26) {
            return true;
        }
        try {
            if (resources.getDrawable(n, null) instanceof AdaptiveIconDrawable) {
                Log.e((String)this.zzeo, (String)new StringBuilder(77).append("Adaptive icons cannot be used in notifications. Ignoring icon id: ").append(n).toString());
                return false;
            }
            return true;
        }
        catch (Resources.NotFoundException notFoundException) {
            Log.e((String)this.zzeo, (String)new StringBuilder(66).append("Couldn't find resource ").append(n).append(", treating it as an invalid icon").toString());
            return false;
        }
    }

    @Nullable
    private final String zza(String ... stringArray) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray2[i];
            String string2 = this.getString(string);
            if (TextUtils.isEmpty((CharSequence)string2)) continue;
            return string2;
        }
        return null;
    }

    @Nullable
    public final Uri zzaw() {
        String string = this.zza("gcm.n.link_android", "gcm.n.link");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return Uri.parse((String)string);
    }
}

