/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.TargetApi;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import androidx.core.content.ContextCompat;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.firebase.messaging.zzc;
import java.util.Arrays;
import java.util.MissingFormatArgumentException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONArray;
import org.json.JSONException;

public final class zza {
    private static final AtomicInteger zza = new AtomicInteger((int)SystemClock.elapsedRealtime());
    private final Context zzb;
    private final String zzc;
    @GuardedBy(value="this")
    private Bundle zzd;

    public zza(Context context, String string) {
        this.zzb = context;
        this.zzc = string;
    }

    public final zzc zza(Bundle bundle) {
        String string;
        Integer n;
        PendingIntent pendingIntent;
        PendingIntent pendingIntent2;
        Object object;
        Object object2;
        Uri uri;
        Uri uri2;
        Object object3;
        Uri uri3;
        Bundle bundle2 = bundle;
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.zzb, this.zzc(com.google.firebase.messaging.zza.zza(bundle2, "gcm.n.android_channel_id")));
        builder.setAutoCancel(true);
        builder.setContentTitle(this.zze(bundle));
        String string2 = this.zzd(bundle, "gcm.n.body");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            builder.setContentText((CharSequence)string2);
            builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)string2));
        }
        int n2 = this.zza(com.google.firebase.messaging.zza.zza(bundle, "gcm.n.icon"));
        builder.setSmallIcon(n2);
        bundle2 = bundle;
        zza zza2 = this;
        String string3 = com.google.firebase.messaging.zza.zzc(bundle2);
        if (TextUtils.isEmpty((CharSequence)string3)) {
            uri3 = null;
        } else if (!"default".equals(string3) && zza2.zzb.getResources().getIdentifier(string3, "raw", zza2.zzc) != 0) {
            object3 = zza2.zzc;
            uri3 = Uri.parse((String)new StringBuilder(24 + String.valueOf(object3).length() + String.valueOf(string3).length()).append("android.resource://").append((String)object3).append("/raw/").append(string3).toString());
        } else {
            uri3 = uri2 = RingtoneManager.getDefaultUri((int)2);
        }
        if (uri3 != null) {
            builder.setSound(uri2);
        }
        bundle2 = bundle;
        zza2 = this;
        Object object4 = bundle2;
        zza zza3 = zza2;
        Object object5 = com.google.firebase.messaging.zza.zza((Bundle)object4, "gcm.n.click_action");
        if (!TextUtils.isEmpty((CharSequence)object5)) {
            uri = new Intent((String)object5);
            uri.setPackage(zza3.zzc);
            uri.setFlags(0x10000000);
            object2 = uri;
        } else {
            uri = com.google.firebase.messaging.zza.zzd((Bundle)object4);
            if (uri != null) {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setPackage(zza3.zzc);
                intent.setData(uri);
                object2 = intent;
            } else {
                Intent intent = zza3.zzb.getPackageManager().getLaunchIntentForPackage(zza3.zzc);
                if (intent == null) {
                    Log.w((String)"FirebaseMessaging", (String)"No activity found to launch app");
                }
                object2 = string3 = intent;
            }
        }
        if (object2 == null) {
            object = null;
        } else {
            string3.addFlags(0x4000000);
            Bundle bundle3 = new Bundle(bundle2);
            object4 = bundle3.keySet().iterator();
            while (object4.hasNext()) {
                object5 = (String)object4.next();
                if (object5 == null || !((String)object5).startsWith("google.c.")) continue;
                object4.remove();
            }
            string3.putExtras(bundle3);
            for (String string4 : bundle3.keySet()) {
                if (!string4.startsWith("gcm.n.") && !string4.startsWith("gcm.notification.")) continue;
                string3.removeExtra(string4);
            }
            object3 = PendingIntent.getActivity((Context)zza2.zzb, (int)zza.incrementAndGet(), (Intent)string3, (int)0x40000000);
            if (com.google.firebase.messaging.zza.zzf(bundle2)) {
                object5 = object3;
                object4 = bundle2;
                zza3 = zza2;
                uri = new Intent("com.google.firebase.messaging.NOTIFICATION_OPEN");
                com.google.firebase.messaging.zza.zza((Intent)uri, (Bundle)object4);
                uri.putExtra("pending_intent", (Parcelable)object5);
                object3 = zza3.zza(zza.incrementAndGet(), (Intent)uri);
            }
            object = object3;
        }
        builder.setContentIntent(object);
        bundle2 = bundle;
        zza2 = this;
        if (!com.google.firebase.messaging.zza.zzf(bundle2)) {
            pendingIntent2 = null;
        } else {
            string3 = new Intent("com.google.firebase.messaging.NOTIFICATION_DISMISS");
            com.google.firebase.messaging.zza.zza((Intent)string3, bundle2);
            pendingIntent2 = pendingIntent = zza2.zza(zza.incrementAndGet(), (Intent)string3);
        }
        if (pendingIntent2 != null) {
            builder.setDeleteIntent(pendingIntent);
        }
        if ((n = this.zzb(com.google.firebase.messaging.zza.zza(bundle, "gcm.n.color"))) != null) {
            builder.setColor(n.intValue());
        }
        if (!TextUtils.isEmpty((CharSequence)(string3 = com.google.firebase.messaging.zza.zza(bundle, "gcm.n.tag")))) {
            string = string3;
        } else {
            long l = SystemClock.uptimeMillis();
            string = new StringBuilder(37).append("FCM-Notification:").append(l).toString();
        }
        return new zzc(builder, string, 0);
    }

    @NonNull
    private final CharSequence zze(Bundle bundle) {
        String string = this.zzd(bundle, "gcm.n.title");
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        try {
            return this.zzb(0).loadLabel(this.zzb.getPackageManager());
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string2 = String.valueOf((Object)nameNotFoundException);
            Log.e((String)"FirebaseMessaging", (String)new StringBuilder(35 + String.valueOf(string2).length()).append("Couldn't get own application info: ").append(string2).toString());
            return "";
        }
    }

    public static boolean zzb(Bundle bundle) {
        return "1".equals(com.google.firebase.messaging.zza.zza(bundle, "gcm.n.e")) || com.google.firebase.messaging.zza.zza(bundle, "gcm.n.icon") != null;
    }

    public static String zza(Bundle bundle, String string) {
        String string2 = bundle.getString(string);
        if (string2 == null) {
            string2 = bundle.getString(string.replace("gcm.n.", "gcm.notification."));
        }
        return string2;
    }

    public static Object[] zzb(Bundle bundle, String string) {
        String string2 = String.valueOf(string);
        String string3 = String.valueOf("_loc_args");
        String string4 = com.google.firebase.messaging.zza.zza(bundle, string3.length() != 0 ? string2.concat(string3) : new String(string2));
        if (TextUtils.isEmpty((CharSequence)string4)) {
            return null;
        }
        try {
            JSONArray jSONArray = new JSONArray(string4);
            Object[] objectArray = new String[jSONArray.length()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = jSONArray.opt(i);
            }
            return objectArray;
        }
        catch (JSONException jSONException) {
            String string5 = String.valueOf(string);
            String string6 = String.valueOf("_loc_args");
            String string7 = string6.length() != 0 ? string5.concat(string6) : new String(string5);
            String string8 = string7.substring(6);
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(41 + String.valueOf(string8).length() + String.valueOf(string4).length()).append("Malformed ").append(string8).append(": ").append(string4).append("  Default value will be used.").toString());
            return null;
        }
    }

    private final String zzd(Bundle bundle, String string) {
        String string2 = com.google.firebase.messaging.zza.zza(bundle, string);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        return this.zze(bundle, string);
    }

    public static String zzc(Bundle bundle, String string) {
        String string2 = String.valueOf(string);
        String string3 = String.valueOf("_loc_key");
        return com.google.firebase.messaging.zza.zza(bundle, string3.length() != 0 ? string2.concat(string3) : new String(string2));
    }

    private final String zze(Bundle bundle, String string) {
        String string2 = com.google.firebase.messaging.zza.zzc(bundle, string);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        Resources resources = this.zzb.getResources();
        int n = resources.getIdentifier(string2, "string", this.zzc);
        if (n == 0) {
            String string3 = String.valueOf(string);
            String string4 = String.valueOf("_loc_key");
            String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            String string6 = string5.substring(6);
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(49 + String.valueOf(string6).length() + String.valueOf(string).length()).append(string6).append(" resource not found: ").append(string).append(" Default value will be used.").toString());
            return null;
        }
        Object[] objectArray = com.google.firebase.messaging.zza.zzb(bundle, string);
        if (objectArray == null) {
            return resources.getString(n);
        }
        try {
            return resources.getString(n, objectArray);
        }
        catch (MissingFormatArgumentException missingFormatArgumentException) {
            String string7 = Arrays.toString(objectArray);
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(58 + String.valueOf(string).length() + String.valueOf(string7).length()).append("Missing format argument for ").append(string).append(": ").append(string7).append(" Default value will be used.").toString(), (Throwable)missingFormatArgumentException);
            return null;
        }
    }

    @TargetApi(value=26)
    private final boolean zza(int n) {
        if (Build.VERSION.SDK_INT != 26) {
            return true;
        }
        Resources resources = this.zzb.getResources();
        try {
            if (resources.getDrawable(n, null) instanceof AdaptiveIconDrawable) {
                Log.e((String)"FirebaseMessaging", (String)new StringBuilder(77).append("Adaptive icons cannot be used in notifications. Ignoring icon id: ").append(n).toString());
                return false;
            }
            return true;
        }
        catch (Resources.NotFoundException notFoundException) {
            Log.e((String)"FirebaseMessaging", (String)new StringBuilder(66).append("Couldn't find resource ").append(n).append(", treating it as an invalid icon").toString());
            return false;
        }
    }

    private final int zza(String string) {
        int n;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            Resources resources = this.zzb.getResources();
            int n2 = resources.getIdentifier(string, "drawable", this.zzc);
            if (n2 != 0 && this.zza(n2)) {
                return n2;
            }
            n2 = resources.getIdentifier(string, "mipmap", this.zzc);
            if (n2 != 0 && this.zza(n2)) {
                return n2;
            }
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(61 + String.valueOf(string).length()).append("Icon resource ").append(string).append(" not found. Notification will use default icon.").toString());
        }
        if ((n = this.zza().getInt("com.google.firebase.messaging.default_notification_icon", 0)) == 0 || !this.zza(n)) {
            try {
                n = this.zzb((int)0).icon;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                String string2 = String.valueOf((Object)nameNotFoundException);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(35 + String.valueOf(string2).length()).append("Couldn't get own application info: ").append(string2).toString());
            }
        }
        if (n == 0 || !this.zza(n)) {
            n = 17301651;
        }
        return n;
    }

    private final Integer zzb(String string) {
        int n;
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                return Color.parseColor((String)string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(54 + String.valueOf(string).length()).append("Color ").append(string).append(" not valid. Notification will use default color.").toString());
            }
        }
        if ((n = this.zza().getInt("com.google.firebase.messaging.default_notification_color", 0)) != 0) {
            try {
                return ContextCompat.getColor((Context)this.zzb, (int)n);
            }
            catch (Resources.NotFoundException notFoundException) {
                Log.w((String)"FirebaseMessaging", (String)"Cannot find the color resource referenced in AndroidManifest.");
            }
        }
        return null;
    }

    public static String zzc(Bundle bundle) {
        String string = com.google.firebase.messaging.zza.zza(bundle, "gcm.n.sound2");
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = com.google.firebase.messaging.zza.zza(bundle, "gcm.n.sound");
        }
        return string;
    }

    @Nullable
    static Uri zzd(@NonNull Bundle bundle) {
        String string = com.google.firebase.messaging.zza.zza(bundle, "gcm.n.link_android");
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = com.google.firebase.messaging.zza.zza(bundle, "gcm.n.link");
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return Uri.parse((String)string);
        }
        return null;
    }

    private final synchronized Bundle zza() {
        if (this.zzd != null) {
            return this.zzd;
        }
        try {
            ApplicationInfo applicationInfo = this.zzb(128);
            if (applicationInfo != null && applicationInfo.metaData != null) {
                this.zzd = applicationInfo.metaData;
                return this.zzd;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(35 + String.valueOf(string).length()).append("Couldn't get own application info: ").append(string).toString());
        }
        return Bundle.EMPTY;
    }

    @TargetApi(value=26)
    private final String zzc(String string) {
        String string2;
        if (!PlatformVersion.isAtLeastO()) {
            return null;
        }
        int n = 0;
        try {
            n = this.zzb((int)0).targetSdkVersion;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        if (n < 26) {
            return null;
        }
        NotificationManager notificationManager = (NotificationManager)this.zzb.getSystemService(NotificationManager.class);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (notificationManager.getNotificationChannel(string) != null) {
                return string;
            }
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(122 + String.valueOf(string).length()).append("Notification Channel requested (").append(string).append(") has not been created by the app. Manifest configuration, or default, value will be used.").toString());
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = this.zza().getString("com.google.firebase.messaging.default_notification_channel_id")))) {
            if (notificationManager.getNotificationChannel(string2) != null) {
                return string2;
            }
            Log.w((String)"FirebaseMessaging", (String)"Notification Channel set in AndroidManifest.xml has not been created by the app. Default value will be used.");
        } else {
            Log.w((String)"FirebaseMessaging", (String)"Missing Default Notification Channel metadata in AndroidManifest. Default value will be used.");
        }
        if (notificationManager.getNotificationChannel("fcm_fallback_notification_channel") == null) {
            int n2 = this.zzb.getResources().getIdentifier("fcm_fallback_notification_channel_label", "string", this.zzc);
            notificationManager.createNotificationChannel(new NotificationChannel("fcm_fallback_notification_channel", (CharSequence)this.zzb.getString(n2), 3));
        }
        return "fcm_fallback_notification_channel";
    }

    private final ApplicationInfo zzb(int n) throws PackageManager.NameNotFoundException {
        return this.zzb.getPackageManager().getApplicationInfo(this.zzc, n);
    }

    private static void zza(Intent intent, Bundle bundle) {
        for (String string : bundle.keySet()) {
            if (!string.startsWith("google.c.a.") && !string.equals("from")) continue;
            intent.putExtra(string, bundle.getString(string));
        }
    }

    private final PendingIntent zza(int n, Intent intent) {
        return PendingIntent.getBroadcast((Context)this.zzb, (int)n, (Intent)new Intent("com.google.firebase.MESSAGING_EVENT").setComponent(new ComponentName(this.zzb, "com.google.firebase.iid.FirebaseInstanceIdReceiver")).putExtra("wrapped_intent", (Parcelable)intent), (int)0x40000000);
    }

    private static boolean zzf(Bundle bundle) {
        return bundle != null && "1".equals(bundle.getString("google.c.a.e"));
    }
}

