/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.TargetApi;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import androidx.core.content.ContextCompat;
import com.google.firebase.messaging.NotificationParams;
import java.util.concurrent.atomic.AtomicInteger;

public final class CommonNotificationBuilder {
    public static final String METADATA_DEFAULT_COLOR = "com.google.firebase.messaging.default_notification_color";
    public static final String METADATA_DEFAULT_ICON = "com.google.firebase.messaging.default_notification_icon";
    public static final String METADATA_DEFAULT_CHANNEL_ID = "com.google.firebase.messaging.default_notification_channel_id";
    public static final String FCM_FALLBACK_NOTIFICATION_CHANNEL = "fcm_fallback_notification_channel";
    public static final String FCM_FALLBACK_NOTIFICATION_CHANNEL_LABEL = "fcm_fallback_notification_channel_label";
    private static final AtomicInteger requestCodeProvider = new AtomicInteger((int)SystemClock.elapsedRealtime());

    private CommonNotificationBuilder() {
    }

    static DisplayNotificationInfo createNotificationInfo(Context context, NotificationParams notificationParams) {
        Bundle bundle = CommonNotificationBuilder.getManifestMetadata(context.getPackageManager(), context.getPackageName());
        return CommonNotificationBuilder.createNotificationInfo(context, context.getPackageName(), notificationParams, CommonNotificationBuilder.getOrCreateChannel(context, notificationParams.getNotificationChannelId(), bundle), context.getResources(), context.getPackageManager(), bundle);
    }

    public static DisplayNotificationInfo createNotificationInfo(Context context, String string, NotificationParams notificationParams, String string2, Resources resources, PackageManager packageManager, Bundle bundle) {
        int[] nArray;
        long[] lArray;
        Long l;
        Integer n;
        Integer n2;
        Integer n3;
        boolean bl;
        Integer n4;
        String string3;
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context, string2);
        String string4 = notificationParams.getPossiblyLocalizedString(resources, string, "gcm.n.title");
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            builder.setContentTitle((CharSequence)string4);
        }
        if (!TextUtils.isEmpty((CharSequence)(string3 = notificationParams.getPossiblyLocalizedString(resources, string, "gcm.n.body")))) {
            builder.setContentText((CharSequence)string3);
            builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)string3));
        }
        int n5 = CommonNotificationBuilder.getSmallIcon(packageManager, resources, string, notificationParams.getString("gcm.n.icon"), bundle);
        builder.setSmallIcon(n5);
        Uri uri = CommonNotificationBuilder.getSound(string, notificationParams, resources);
        if (uri != null) {
            builder.setSound(uri);
        }
        builder.setContentIntent(CommonNotificationBuilder.createContentIntent(context, notificationParams, string, packageManager));
        PendingIntent pendingIntent = CommonNotificationBuilder.createDeleteIntent(context, notificationParams);
        if (pendingIntent != null) {
            builder.setDeleteIntent(pendingIntent);
        }
        if ((n4 = CommonNotificationBuilder.getColor(context, notificationParams.getString("gcm.n.color"), bundle)) != null) {
            builder.setColor(n4.intValue());
        }
        builder.setAutoCancel(!(bl = notificationParams.getBoolean("gcm.n.sticky")));
        boolean bl2 = notificationParams.getBoolean("gcm.n.local_only");
        builder.setLocalOnly(bl2);
        String string5 = notificationParams.getString("gcm.n.ticker");
        if (string5 != null) {
            builder.setTicker((CharSequence)string5);
        }
        if ((n3 = notificationParams.getNotificationPriority()) != null) {
            builder.setPriority(n3.intValue());
        }
        if ((n2 = notificationParams.getVisibility()) != null) {
            builder.setVisibility(n2.intValue());
        }
        if ((n = notificationParams.getNotificationCount()) != null) {
            builder.setNumber(n.intValue());
        }
        if ((l = notificationParams.getLong("gcm.n.event_time")) != null) {
            builder.setShowWhen(true);
            builder.setWhen(l.longValue());
        }
        if ((lArray = notificationParams.getVibrateTimings()) != null) {
            builder.setVibrate(lArray);
        }
        if ((nArray = notificationParams.getLightSettings()) != null) {
            builder.setLights(nArray[0], nArray[1], nArray[2]);
        }
        builder.setDefaults(CommonNotificationBuilder.getConsolidatedDefaults(notificationParams));
        return new DisplayNotificationInfo(builder, CommonNotificationBuilder.getTag(notificationParams), 0);
    }

    private static int getConsolidatedDefaults(NotificationParams notificationParams) {
        int n = 0;
        if (notificationParams.getBoolean("gcm.n.default_sound")) {
            n = 1;
        }
        if (notificationParams.getBoolean("gcm.n.default_vibrate_timings")) {
            n |= 2;
        }
        if (notificationParams.getBoolean("gcm.n.default_light_settings")) {
            n |= 4;
        }
        return n;
    }

    @TargetApi(value=26)
    private static boolean isValidIcon(Resources resources, int n) {
        if (Build.VERSION.SDK_INT != 26) {
            return true;
        }
        try {
            if (resources.getDrawable(n, null) instanceof AdaptiveIconDrawable) {
                Log.e((String)"FirebaseMessaging", (String)new StringBuilder(77).append("Adaptive icons cannot be used in notifications. Ignoring icon id: ").append(n).toString());
                return false;
            }
            return true;
        }
        catch (Resources.NotFoundException notFoundException) {
            Log.e((String)"FirebaseMessaging", (String)new StringBuilder(66).append("Couldn't find resource ").append(n).append(", treating it as an invalid icon").toString());
            return false;
        }
    }

    private static int getSmallIcon(PackageManager packageManager, Resources resources, String string, String string2, Bundle bundle) {
        int n;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            n = resources.getIdentifier(string2, "drawable", string);
            if (n != 0 && CommonNotificationBuilder.isValidIcon(resources, n)) {
                return n;
            }
            n = resources.getIdentifier(string2, "mipmap", string);
            if (n != 0 && CommonNotificationBuilder.isValidIcon(resources, n)) {
                return n;
            }
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(61 + String.valueOf(string2).length()).append("Icon resource ").append(string2).append(" not found. Notification will use default icon.").toString());
        }
        if ((n = bundle.getInt(METADATA_DEFAULT_ICON, 0)) == 0 || !CommonNotificationBuilder.isValidIcon(resources, n)) {
            try {
                n = packageManager.getApplicationInfo((String)string, (int)0).icon;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                String string3 = String.valueOf((Object)nameNotFoundException);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(35 + String.valueOf(string3).length()).append("Couldn't get own application info: ").append(string3).toString());
            }
        }
        if (n == 0 || !CommonNotificationBuilder.isValidIcon(resources, n)) {
            n = 17301651;
        }
        return n;
    }

    private static Integer getColor(Context context, String string, Bundle bundle) {
        int n;
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                return Color.parseColor((String)string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(56 + String.valueOf(string).length()).append("Color is invalid: ").append(string).append(". Notification will use default color.").toString());
            }
        }
        if ((n = bundle.getInt(METADATA_DEFAULT_COLOR, 0)) != 0) {
            try {
                return ContextCompat.getColor((Context)context, (int)n);
            }
            catch (Resources.NotFoundException notFoundException) {
                Log.w((String)"FirebaseMessaging", (String)"Cannot find the color resource referenced in AndroidManifest.");
            }
        }
        return null;
    }

    private static Uri getSound(String string, NotificationParams notificationParams, Resources resources) {
        String string2 = notificationParams.getSoundResourceName();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        if (!"default".equals(string2) && resources.getIdentifier(string2, "raw", string) != 0) {
            return Uri.parse((String)new StringBuilder(24 + String.valueOf(string).length() + String.valueOf(string2).length()).append("android.resource://").append(string).append("/raw/").append(string2).toString());
        }
        return RingtoneManager.getDefaultUri((int)2);
    }

    @Nullable
    private static PendingIntent createContentIntent(Context context, NotificationParams notificationParams, String string, PackageManager packageManager) {
        Intent intent = CommonNotificationBuilder.createTargetIntent(string, notificationParams, packageManager);
        if (intent == null) {
            return null;
        }
        intent.addFlags(0x4000000);
        intent.putExtras(notificationParams.paramsWithReservedKeysRemoved());
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)CommonNotificationBuilder.generatePendingIntentRequestCode(), (Intent)intent, (int)0x40000000);
        if (CommonNotificationBuilder.shouldUploadMetrics(notificationParams)) {
            pendingIntent = CommonNotificationBuilder.wrapContentIntent(context, notificationParams, pendingIntent);
        }
        return pendingIntent;
    }

    private static Intent createTargetIntent(String string, NotificationParams notificationParams, PackageManager packageManager) {
        String string2 = notificationParams.getString("gcm.n.click_action");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            Intent intent = new Intent(string2);
            intent.setPackage(string);
            intent.setFlags(0x10000000);
            return intent;
        }
        Uri uri = notificationParams.getLink();
        if (uri != null) {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setPackage(string);
            intent.setData(uri);
            return intent;
        }
        Intent intent = packageManager.getLaunchIntentForPackage(string);
        if (intent == null) {
            Log.w((String)"FirebaseMessaging", (String)"No activity found to launch app");
        }
        return intent;
    }

    private static Bundle getManifestMetadata(PackageManager packageManager, String string) {
        try {
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(string, 128);
            if (applicationInfo != null && applicationInfo.metaData != null) {
                return applicationInfo.metaData;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string2 = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(35 + String.valueOf(string2).length()).append("Couldn't get own application info: ").append(string2).toString());
        }
        return Bundle.EMPTY;
    }

    @TargetApi(value=26)
    private static String getOrCreateChannel(Context context, String string, Bundle bundle) {
        String string2;
        if (Build.VERSION.SDK_INT < 26) {
            return null;
        }
        try {
            if (context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)0).targetSdkVersion < 26) {
                return null;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        NotificationManager notificationManager = (NotificationManager)context.getSystemService(NotificationManager.class);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (notificationManager.getNotificationChannel(string) != null) {
                return string;
            }
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(122 + String.valueOf(string).length()).append("Notification Channel requested (").append(string).append(") has not been created by the app. Manifest configuration, or default, value will be used.").toString());
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = bundle.getString(METADATA_DEFAULT_CHANNEL_ID)))) {
            if (notificationManager.getNotificationChannel(string2) != null) {
                return string2;
            }
            Log.w((String)"FirebaseMessaging", (String)"Notification Channel set in AndroidManifest.xml has not been created by the app. Default value will be used.");
        } else {
            Log.w((String)"FirebaseMessaging", (String)"Missing Default Notification Channel metadata in AndroidManifest. Default value will be used.");
        }
        if (notificationManager.getNotificationChannel(FCM_FALLBACK_NOTIFICATION_CHANNEL) == null) {
            int n = context.getResources().getIdentifier(FCM_FALLBACK_NOTIFICATION_CHANNEL_LABEL, "string", context.getPackageName());
            notificationManager.createNotificationChannel(new NotificationChannel(FCM_FALLBACK_NOTIFICATION_CHANNEL, (CharSequence)context.getString(n), 3));
        }
        return FCM_FALLBACK_NOTIFICATION_CHANNEL;
    }

    private static int generatePendingIntentRequestCode() {
        return requestCodeProvider.incrementAndGet();
    }

    private static PendingIntent wrapContentIntent(Context context, NotificationParams notificationParams, PendingIntent pendingIntent) {
        Intent intent = new Intent("com.google.firebase.messaging.NOTIFICATION_OPEN").putExtras(notificationParams.paramsForAnalyticsIntent()).putExtra("pending_intent", (Parcelable)pendingIntent);
        return CommonNotificationBuilder.createMessagingPendingIntent(context, intent);
    }

    @Nullable
    private static PendingIntent createDeleteIntent(Context context, NotificationParams notificationParams) {
        if (!CommonNotificationBuilder.shouldUploadMetrics(notificationParams)) {
            return null;
        }
        Intent intent = new Intent("com.google.firebase.messaging.NOTIFICATION_DISMISS").putExtras(notificationParams.paramsForAnalyticsIntent());
        return CommonNotificationBuilder.createMessagingPendingIntent(context, intent);
    }

    private static PendingIntent createMessagingPendingIntent(Context context, Intent intent) {
        return PendingIntent.getBroadcast((Context)context, (int)CommonNotificationBuilder.generatePendingIntentRequestCode(), (Intent)new Intent("com.google.firebase.MESSAGING_EVENT").setComponent(new ComponentName(context, "com.google.firebase.iid.FirebaseInstanceIdReceiver")).putExtra("wrapped_intent", (Parcelable)intent), (int)0x40000000);
    }

    static boolean shouldUploadMetrics(@NonNull NotificationParams notificationParams) {
        return notificationParams.getBoolean("google.c.a.e");
    }

    private static String getTag(NotificationParams notificationParams) {
        String string = notificationParams.getString("gcm.n.tag");
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        long l = SystemClock.uptimeMillis();
        return new StringBuilder(37).append("FCM-Notification:").append(l).toString();
    }

    public static class DisplayNotificationInfo {
        public final NotificationCompat.Builder notificationBuilder;
        public final String tag;
        public final int id;

        DisplayNotificationInfo(NotificationCompat.Builder builder, String string, int n) {
            this.notificationBuilder = builder;
            this.tag = string;
            this.id = n;
        }
    }
}

