/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.res.Resources;
import android.graphics.Color;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Arrays;
import java.util.MissingFormatArgumentException;
import org.json.JSONArray;
import org.json.JSONException;

public class NotificationParams {
    @NonNull
    private final Bundle data;

    public NotificationParams(@NonNull Bundle bundle) {
        if (bundle == null) {
            throw new NullPointerException("data");
        }
        this.data = new Bundle(bundle);
    }

    @Nullable
    Integer getNotificationCount() {
        Integer n = this.getInteger("gcm.n.notification_count");
        if (n == null) {
            return null;
        }
        if (n < 0) {
            String string = String.valueOf(n);
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(67 + String.valueOf(string).length()).append("notificationCount is invalid: ").append(string).append(". Skipping setting notificationCount.").toString());
            return null;
        }
        return n;
    }

    @Nullable
    Integer getNotificationPriority() {
        Integer n = this.getInteger("gcm.n.notification_priority");
        if (n == null) {
            return null;
        }
        if (n < -2 || n > 2) {
            String string = String.valueOf(n);
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(72 + String.valueOf(string).length()).append("notificationPriority is invalid ").append(string).append(". Skipping setting notificationPriority.").toString());
            return null;
        }
        return n;
    }

    Integer getVisibility() {
        Integer n = this.getInteger("gcm.n.visibility");
        if (n == null) {
            return null;
        }
        if (n < -1 || n > 1) {
            String string = String.valueOf(n);
            Log.w((String)"NotificationParams", (String)new StringBuilder(53 + String.valueOf(string).length()).append("visibility is invalid: ").append(string).append(". Skipping setting visibility.").toString());
            return null;
        }
        return n;
    }

    public String getString(String string) {
        return this.data.getString(this.normalizePrefix(string));
    }

    private String normalizePrefix(String string) {
        String string2;
        if (!this.data.containsKey(string) && string.startsWith("gcm.n.") && this.data.containsKey(string2 = NotificationParams.keyWithOldPrefix(string))) {
            return string2;
        }
        return string;
    }

    public boolean getBoolean(String string) {
        String string2 = this.getString(string);
        return "1".equals(string2) || Boolean.parseBoolean(string2);
    }

    public Integer getInteger(String string) {
        String string2 = this.getString(string);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                String string3 = NotificationParams.userFriendlyKey(string);
                Log.w((String)"NotificationParams", (String)new StringBuilder(38 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Couldn't parse value of ").append(string3).append("(").append(string2).append(") into an int").toString());
            }
        }
        return null;
    }

    public Long getLong(String string) {
        String string2 = this.getString(string);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                String string3 = NotificationParams.userFriendlyKey(string);
                Log.w((String)"NotificationParams", (String)new StringBuilder(38 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Couldn't parse value of ").append(string3).append("(").append(string2).append(") into a long").toString());
            }
        }
        return null;
    }

    @Nullable
    public String getLocalizationResourceForKey(String string) {
        String string2 = String.valueOf(string);
        String string3 = String.valueOf("_loc_key");
        return this.getString(string3.length() != 0 ? string2.concat(string3) : new String(string2));
    }

    @Nullable
    public Object[] getLocalizationArgsForKey(String string) {
        String string2 = String.valueOf(string);
        String string3 = String.valueOf("_loc_args");
        JSONArray jSONArray = this.getJSONArray(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        if (jSONArray == null) {
            return null;
        }
        Object[] objectArray = new String[jSONArray.length()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = jSONArray.optString(i);
        }
        return objectArray;
    }

    @Nullable
    public JSONArray getJSONArray(String string) {
        String string2 = this.getString(string);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                return new JSONArray(string2);
            }
            catch (JSONException jSONException) {
                String string3 = NotificationParams.userFriendlyKey(string);
                Log.w((String)"NotificationParams", (String)new StringBuilder(50 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Malformed JSON for key ").append(string3).append(": ").append(string2).append(", falling back to default").toString());
            }
        }
        return null;
    }

    private static String userFriendlyKey(String string) {
        if (string.startsWith("gcm.n.")) {
            return string.substring(6);
        }
        return string;
    }

    @Nullable
    public Uri getLink() {
        String string = this.getString("gcm.n.link_android");
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = this.getString("gcm.n.link");
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return Uri.parse((String)string);
        }
        return null;
    }

    @Nullable
    public String getSoundResourceName() {
        String string = this.getString("gcm.n.sound2");
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = this.getString("gcm.n.sound");
        }
        return string;
    }

    @Nullable
    public long[] getVibrateTimings() {
        JSONArray jSONArray = this.getJSONArray("gcm.n.vibrate_timings");
        if (jSONArray == null) {
            return null;
        }
        try {
            if (jSONArray.length() <= 1) {
                throw new JSONException("vibrateTimings have invalid length");
            }
            long[] lArray = new long[jSONArray.length()];
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = jSONArray.optLong(i);
            }
            return lArray;
        }
        catch (NumberFormatException | JSONException throwable) {
            String string = String.valueOf(jSONArray);
            Log.w((String)"NotificationParams", (String)new StringBuilder(74 + String.valueOf(string).length()).append("User defined vibrateTimings is invalid: ").append(string).append(". Skipping setting vibrateTimings.").toString());
            return null;
        }
    }

    @Nullable
    int[] getLightSettings() {
        JSONArray jSONArray = this.getJSONArray("gcm.n.light_settings");
        if (jSONArray == null) {
            return null;
        }
        int[] nArray = new int[3];
        try {
            if (jSONArray.length() != 3) {
                throw new JSONException("lightSettings don't have all three fields");
            }
            nArray[0] = NotificationParams.getLightColor(jSONArray.optString(0));
            nArray[1] = jSONArray.optInt(1);
            nArray[2] = jSONArray.optInt(2);
            return nArray;
        }
        catch (JSONException jSONException) {
            String string = String.valueOf(jSONArray);
            Log.w((String)"NotificationParams", (String)new StringBuilder(58 + String.valueOf(string).length()).append("LightSettings is invalid: ").append(string).append(". Skipping setting LightSettings").toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = String.valueOf(jSONArray);
            String string2 = illegalArgumentException.getMessage();
            Log.w((String)"NotificationParams", (String)new StringBuilder(60 + String.valueOf(string).length() + String.valueOf(string2).length()).append("LightSettings is invalid: ").append(string).append(". ").append(string2).append(". Skipping setting LightSettings").toString());
        }
        return null;
    }

    public Bundle paramsWithReservedKeysRemoved() {
        Bundle bundle = new Bundle(this.data);
        for (String string : this.data.keySet()) {
            if (!NotificationParams.isReservedKey(string)) continue;
            bundle.remove(string);
        }
        return bundle;
    }

    public Bundle paramsForAnalyticsIntent() {
        Bundle bundle = new Bundle(this.data);
        for (String string : this.data.keySet()) {
            if (NotificationParams.isAnalyticsKey(string)) continue;
            bundle.remove(string);
        }
        return bundle;
    }

    @Nullable
    public String getLocalizedString(Resources resources, String string, String string2) {
        String string3 = this.getLocalizationResourceForKey(string2);
        if (TextUtils.isEmpty((CharSequence)string3)) {
            return null;
        }
        int n = resources.getIdentifier(string3, "string", string);
        if (n == 0) {
            String string4 = String.valueOf(string2);
            String string5 = String.valueOf("_loc_key");
            String string6 = NotificationParams.userFriendlyKey(string5.length() != 0 ? string4.concat(string5) : new String(string4));
            Log.w((String)"NotificationParams", (String)new StringBuilder(49 + String.valueOf(string6).length() + String.valueOf(string2).length()).append(string6).append(" resource not found: ").append(string2).append(" Default value will be used.").toString());
            return null;
        }
        Object[] objectArray = this.getLocalizationArgsForKey(string2);
        if (objectArray == null) {
            return resources.getString(n);
        }
        try {
            return resources.getString(n, objectArray);
        }
        catch (MissingFormatArgumentException missingFormatArgumentException) {
            String string7 = NotificationParams.userFriendlyKey(string2);
            String string8 = Arrays.toString(objectArray);
            Log.w((String)"NotificationParams", (String)new StringBuilder(58 + String.valueOf(string7).length() + String.valueOf(string8).length()).append("Missing format argument for ").append(string7).append(": ").append(string8).append(" Default value will be used.").toString(), (Throwable)missingFormatArgumentException);
            return null;
        }
    }

    public String getPossiblyLocalizedString(Resources resources, String string, String string2) {
        String string3 = this.getString(string2);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            return string3;
        }
        return this.getLocalizedString(resources, string, string2);
    }

    public boolean hasImage() {
        return !TextUtils.isEmpty((CharSequence)this.getString("gcm.n.image"));
    }

    public String getNotificationChannelId() {
        return this.getString("gcm.n.android_channel_id");
    }

    private static boolean isAnalyticsKey(String string) {
        return string.startsWith("google.c.a.") || string.equals("from");
    }

    private static boolean isReservedKey(String string) {
        return string.startsWith("google.c.") || string.startsWith("gcm.n.") || string.startsWith("gcm.notification.");
    }

    private static int getLightColor(String string) {
        int n = Color.parseColor((String)string);
        if (n == -16777216) {
            throw new IllegalArgumentException("Transparent color is invalid");
        }
        return n;
    }

    public boolean isNotification() {
        return this.getBoolean("gcm.n.e");
    }

    public static boolean isNotification(Bundle bundle) {
        return "1".equals(bundle.getString("gcm.n.e")) || "1".equals(bundle.getString(NotificationParams.keyWithOldPrefix("gcm.n.e")));
    }

    private static String keyWithOldPrefix(String string) {
        if (!string.startsWith("gcm.n.")) {
            return string;
        }
        return string.replace("gcm.n.", "gcm.notification.");
    }
}

