/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.firebase.messaging.SharedPreferencesQueue$$Lambda$0;
import java.util.ArrayDeque;
import java.util.concurrent.Executor;

final class SharedPreferencesQueue {
    private final SharedPreferences sharedPreferences;
    private final String queueName;
    private final String itemSeparator;
    @GuardedBy(value="internalQueue")
    private final ArrayDeque<String> internalQueue = new ArrayDeque();
    private final Executor syncExecutor;
    @GuardedBy(value="internalQueue")
    private boolean bulkOperation = false;

    private SharedPreferencesQueue(SharedPreferences sharedPreferences, String string, String string2, Executor executor) {
        this.sharedPreferences = sharedPreferences;
        this.queueName = string;
        this.itemSeparator = string2;
        this.syncExecutor = executor;
    }

    @WorkerThread
    static SharedPreferencesQueue createInstance(SharedPreferences sharedPreferences, String string, String string2, Executor executor) {
        SharedPreferencesQueue sharedPreferencesQueue = new SharedPreferencesQueue(sharedPreferences, string, string2, executor);
        sharedPreferencesQueue.initQueue();
        return sharedPreferencesQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private final void initQueue() {
        ArrayDeque<String> arrayDeque = this.internalQueue;
        synchronized (arrayDeque) {
            this.internalQueue.clear();
            String string = this.sharedPreferences.getString(this.queueName, "");
            if (TextUtils.isEmpty((CharSequence)string) || !string.contains(this.itemSeparator)) {
                return;
            }
            String[] stringArray = string.split(this.itemSeparator, -1);
            if (stringArray.length == 0) {
                Log.e((String)"FirebaseMessaging", (String)"Corrupted queue. Please check the queue contents and item separator provided");
            }
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray2[i];
                if (TextUtils.isEmpty((CharSequence)string2)) continue;
                this.internalQueue.add(string2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean add(@NonNull String string) {
        if (TextUtils.isEmpty((CharSequence)string) || string.contains(this.itemSeparator)) {
            return false;
        }
        ArrayDeque<String> arrayDeque = this.internalQueue;
        synchronized (arrayDeque) {
            return this.checkAndSyncState(this.internalQueue.add(string));
        }
    }

    @GuardedBy(value="internalQueue")
    private final boolean checkAndSyncState(boolean bl) {
        if (bl && !this.bulkOperation) {
            this.syncStateAsync();
        }
        return bl;
    }

    private final void syncStateAsync() {
        this.syncExecutor.execute(new SharedPreferencesQueue$$Lambda$0(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private final void syncState() {
        ArrayDeque<String> arrayDeque = this.internalQueue;
        synchronized (arrayDeque) {
            this.sharedPreferences.edit().putString(this.queueName, this.serialize()).commit();
            return;
        }
    }

    @GuardedBy(value="internalQueue")
    @NonNull
    public final String serialize() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.internalQueue) {
            stringBuilder.append(string).append(this.itemSeparator);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean remove(@Nullable Object object) {
        ArrayDeque<String> arrayDeque = this.internalQueue;
        synchronized (arrayDeque) {
            return this.checkAndSyncState(this.internalQueue.remove(object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String peek() {
        ArrayDeque<String> arrayDeque = this.internalQueue;
        synchronized (arrayDeque) {
            return this.internalQueue.peek();
        }
    }

    final /* synthetic */ void bridge$lambda$0$SharedPreferencesQueue() {
        this.syncState();
    }
}

