/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.firebase.messaging.SharedPreferencesQueue;
import com.google.firebase.messaging.TopicOperation;
import java.lang.ref.WeakReference;
import java.util.concurrent.Executor;

final class TopicsStore {
    @GuardedBy(value="TopicsStore.class")
    private static WeakReference<TopicsStore> topicsStoreWeakReference;
    private final SharedPreferences sharedPreferences;
    private SharedPreferencesQueue topicOperationsQueue;
    private final Executor syncExecutor;

    private TopicsStore(SharedPreferences sharedPreferences, Executor executor) {
        this.syncExecutor = executor;
        this.sharedPreferences = sharedPreferences;
    }

    @WorkerThread
    private final synchronized void initStore() {
        this.topicOperationsQueue = SharedPreferencesQueue.createInstance(this.sharedPreferences, "topic_operation_queue", ",", this.syncExecutor);
    }

    @WorkerThread
    public static synchronized TopicsStore getInstance(Context context, Executor executor) {
        TopicsStore topicsStore = null;
        if (topicsStoreWeakReference != null) {
            topicsStore = (TopicsStore)topicsStoreWeakReference.get();
        }
        if (topicsStore == null) {
            SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.android.gms.appid", 0);
            topicsStore = new TopicsStore(sharedPreferences, executor);
            topicsStore.initStore();
            topicsStoreWeakReference = new WeakReference<TopicsStore>(topicsStore);
        }
        return topicsStore;
    }

    @Nullable
    final synchronized TopicOperation getNextTopicOperation() {
        return TopicOperation.from(this.topicOperationsQueue.peek());
    }

    final synchronized boolean addTopicOperation(TopicOperation topicOperation) {
        return this.topicOperationsQueue.add(topicOperation.serialize());
    }

    final synchronized boolean removeTopicOperation(TopicOperation topicOperation) {
        return this.topicOperationsQueue.remove(topicOperation.serialize());
    }
}

