/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Intent;
import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.encoders.EncodingException;
import com.google.firebase.encoders.ObjectEncoder;
import com.google.firebase.encoders.ObjectEncoderContext;
import com.google.firebase.messaging.MessagingAnalytics;
import java.io.IOException;

@KeepForSdk
final class FirelogAnalyticsEvent {
    private final String eventType;
    private final Intent intent;

    FirelogAnalyticsEvent(@NonNull String string, @NonNull Intent intent) {
        this.eventType = Preconditions.checkNotEmpty((String)string, (Object)"evenType must be non-null");
        this.intent = (Intent)Preconditions.checkNotNull((Object)intent, (Object)"intent must be non-null");
    }

    @NonNull
    final Intent getIntent() {
        return this.intent;
    }

    @NonNull
    final String getEventType() {
        return this.eventType;
    }

    static final class FirelogAnalyticsEventWrapperEncoder
    implements ObjectEncoder<FirelogAnalyticsEventWrapper> {
        FirelogAnalyticsEventWrapperEncoder() {
        }

        public final void encode(FirelogAnalyticsEventWrapper firelogAnalyticsEventWrapper, ObjectEncoderContext objectEncoderContext) throws EncodingException, IOException {
            objectEncoderContext.add("messaging_client_event", (Object)firelogAnalyticsEventWrapper.getFirelogAnalyticsEvent());
        }
    }

    static final class FirelogAnalyticsEventWrapper {
        private final FirelogAnalyticsEvent firelogAnalyticsEvent;

        FirelogAnalyticsEventWrapper(@NonNull FirelogAnalyticsEvent firelogAnalyticsEvent) {
            this.firelogAnalyticsEvent = (FirelogAnalyticsEvent)Preconditions.checkNotNull((Object)firelogAnalyticsEvent);
        }

        @NonNull
        final FirelogAnalyticsEvent getFirelogAnalyticsEvent() {
            return this.firelogAnalyticsEvent;
        }
    }

    static class FirelogAnalyticsEventEncoder
    implements ObjectEncoder<FirelogAnalyticsEvent> {
        FirelogAnalyticsEventEncoder() {
        }

        public void encode(FirelogAnalyticsEvent firelogAnalyticsEvent, ObjectEncoderContext objectEncoderContext) throws EncodingException, IOException {
            String string;
            String string2;
            String string3;
            Intent intent = firelogAnalyticsEvent.getIntent();
            objectEncoderContext.add("ttl", MessagingAnalytics.getTtl(intent));
            objectEncoderContext.add("event", (Object)firelogAnalyticsEvent.getEventType());
            objectEncoderContext.add("instanceId", (Object)MessagingAnalytics.getInstanceId());
            objectEncoderContext.add("priority", MessagingAnalytics.getPriority(intent));
            objectEncoderContext.add("packageName", (Object)MessagingAnalytics.getPackageName());
            objectEncoderContext.add("sdkPlatform", (Object)"ANDROID");
            objectEncoderContext.add("messageType", (Object)MessagingAnalytics.getMessageTypeForFirelog(intent));
            String string4 = MessagingAnalytics.getMessageId(intent);
            if (string4 != null) {
                objectEncoderContext.add("messageId", (Object)string4);
            }
            if ((string3 = MessagingAnalytics.getTopic(intent)) != null) {
                objectEncoderContext.add("topic", (Object)string3);
            }
            if ((string2 = MessagingAnalytics.getCollapseKey(intent)) != null) {
                objectEncoderContext.add("collapseKey", (Object)string2);
            }
            if (MessagingAnalytics.getMessageLabel(intent) != null) {
                objectEncoderContext.add("analyticsLabel", (Object)MessagingAnalytics.getMessageLabel(intent));
            }
            if (MessagingAnalytics.getComposerLabel(intent) != null) {
                objectEncoderContext.add("composerLabel", (Object)MessagingAnalytics.getComposerLabel(intent));
            }
            if ((string = MessagingAnalytics.getProjectNumber()) != null) {
                objectEncoderContext.add("projectNumber", (Object)string);
            }
        }
    }
}

