/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.PowerManager;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.iid.Metadata;
import com.google.firebase.messaging.Constants;
import com.google.firebase.messaging.TopicsSubscriber;
import java.io.IOException;

class TopicsSyncTask
implements Runnable {
    private final Context context;
    private final Metadata metadata;
    private final PowerManager.WakeLock syncWakeLock;
    private final TopicsSubscriber topicsSubscriber;
    private final long nextDelaySeconds;
    private static final Object TOPIC_SYNC_TASK_LOCK = new Object();
    @GuardedBy(value="TOPIC_SYNC_TASK_LOCK")
    private static Boolean hasWakeLockPermission = null;
    @GuardedBy(value="TOPIC_SYNC_TASK_LOCK")
    private static Boolean hasAccessNetworkStatePermission = null;

    TopicsSyncTask(TopicsSubscriber topicsSubscriber, Context context, Metadata metadata, long l) {
        this.topicsSubscriber = topicsSubscriber;
        this.context = context;
        this.nextDelaySeconds = l;
        this.metadata = metadata;
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.syncWakeLock = powerManager.newWakeLock(1, "wake:com.google.firebase.messaging");
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @SuppressLint(value={"Wakelock"})
    public void run() {
        block20: {
            block19: {
                block18: {
                    if (TopicsSyncTask.hasWakeLockPermission(this.context)) {
                        this.syncWakeLock.acquire(Constants.WAKE_LOCK_ACQUIRE_TIMEOUT_MILLIS);
                    }
                    this.topicsSubscriber.setSyncScheduledOrRunning(true);
                    if (this.metadata.isGmscorePresent()) break block18;
                    this.topicsSubscriber.setSyncScheduledOrRunning(false);
                    if (!TopicsSyncTask.hasWakeLockPermission(this.context)) return;
                    try {
                        this.syncWakeLock.release();
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        Log.i((String)"FirebaseMessaging", (String)"TopicsSyncTask's wakelock was already released due to timeout.");
                    }
                    return;
                }
                if (!TopicsSyncTask.hasAccessNetworkStatePermission(this.context) || this.isDeviceConnected()) break block19;
                new ConnectivityChangeReceiver(this).registerReceiver();
                if (!TopicsSyncTask.hasWakeLockPermission(this.context)) return;
                try {
                    this.syncWakeLock.release();
                    return;
                }
                catch (RuntimeException runtimeException) {
                    Log.i((String)"FirebaseMessaging", (String)"TopicsSyncTask's wakelock was already released due to timeout.");
                }
                return;
            }
            if (this.topicsSubscriber.syncTopics()) {
                this.topicsSubscriber.setSyncScheduledOrRunning(false);
                break block20;
            }
            this.topicsSubscriber.syncWithDelaySecondsInternal(this.nextDelaySeconds);
        }
        if (!TopicsSyncTask.hasWakeLockPermission(this.context)) return;
        try {
            this.syncWakeLock.release();
            return;
        }
        catch (RuntimeException runtimeException) {
            Log.i((String)"FirebaseMessaging", (String)"TopicsSyncTask's wakelock was already released due to timeout.");
            return;
        }
        catch (IOException iOException) {
            try {
                String string = String.valueOf(iOException.getMessage());
                Log.e((String)"FirebaseMessaging", (String)(string.length() != 0 ? "Failed to sync topics. Won't retry sync. ".concat(string) : new String("Failed to sync topics. Won't retry sync. ")));
                this.topicsSubscriber.setSyncScheduledOrRunning(false);
            }
            catch (Throwable throwable) {
                if (!TopicsSyncTask.hasWakeLockPermission(this.context)) throw throwable;
                try {
                    this.syncWakeLock.release();
                    throw throwable;
                }
                catch (RuntimeException runtimeException) {
                    Log.i((String)"FirebaseMessaging", (String)"TopicsSyncTask's wakelock was already released due to timeout.");
                }
                throw throwable;
            }
            if (!TopicsSyncTask.hasWakeLockPermission(this.context)) return;
            try {
                this.syncWakeLock.release();
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.i((String)"FirebaseMessaging", (String)"TopicsSyncTask's wakelock was already released due to timeout.");
                return;
            }
        }
    }

    private synchronized boolean isDeviceConnected() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager != null ? connectivityManager.getActiveNetworkInfo() : null;
        return networkInfo != null && networkInfo.isConnected();
    }

    private static boolean isLoggable() {
        return Log.isLoggable((String)"FirebaseMessaging", (int)3) || Build.VERSION.SDK_INT == 23 && Log.isLoggable((String)"FirebaseMessaging", (int)3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasWakeLockPermission(Context context) {
        Object object = TOPIC_SYNC_TASK_LOCK;
        synchronized (object) {
            hasWakeLockPermission = hasWakeLockPermission == null ? TopicsSyncTask.hasPermission(context, "android.permission.WAKE_LOCK", hasWakeLockPermission) : hasWakeLockPermission;
            return hasWakeLockPermission;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasAccessNetworkStatePermission(Context context) {
        Object object = TOPIC_SYNC_TASK_LOCK;
        synchronized (object) {
            hasAccessNetworkStatePermission = hasAccessNetworkStatePermission == null ? TopicsSyncTask.hasPermission(context, "android.permission.ACCESS_NETWORK_STATE", hasAccessNetworkStatePermission) : hasAccessNetworkStatePermission;
            return hasAccessNetworkStatePermission;
        }
    }

    private static boolean hasPermission(Context context, String string, Boolean bl) {
        if (bl != null) {
            return bl;
        }
        boolean bl2 = context.checkCallingOrSelfPermission(string) == 0;
        if (!bl2 && Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)TopicsSyncTask.createPermissionMissingLog(string));
        }
        return bl2;
    }

    private static String createPermissionMissingLog(String string) {
        return new StringBuilder(142 + String.valueOf(string).length()).append("Missing Permission: ").append(string).append(". This permission should normally be included by the manifest merger, but may needed to be manually added to your manifest").toString();
    }

    @VisibleForTesting
    class ConnectivityChangeReceiver
    extends BroadcastReceiver {
        @GuardedBy(value="this")
        @Nullable
        private TopicsSyncTask task;

        public ConnectivityChangeReceiver(TopicsSyncTask topicsSyncTask2) {
            this.task = topicsSyncTask2;
        }

        public synchronized void onReceive(Context context, Intent intent) {
            if (this.task == null) {
                return;
            }
            if (!this.task.isDeviceConnected()) {
                return;
            }
            if (TopicsSyncTask.isLoggable()) {
                Log.d((String)"FirebaseMessaging", (String)"Connectivity changed. Starting background sync.");
            }
            this.task.topicsSubscriber.scheduleSyncTaskWithDelaySeconds(this.task, 0L);
            context.unregisterReceiver((BroadcastReceiver)this);
            this.task = null;
        }

        public void registerReceiver() {
            if (TopicsSyncTask.isLoggable()) {
                Log.d((String)"FirebaseMessaging", (String)"Connectivity change received registered");
            }
            TopicsSyncTask.this.context.registerReceiver((BroadcastReceiver)this, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }
}

