/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.PowerManager;
import android.util.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.GmsRpc;
import com.google.firebase.messaging.ServiceStarter;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class SyncTask
implements Runnable {
    private final long nextDelaySeconds;
    private final PowerManager.WakeLock syncWakeLock;
    private final FirebaseMessaging firebaseMessaging;
    @VisibleForTesting
    ExecutorService processorExecutor;

    Context getContext() {
        return this.firebaseMessaging.getApplicationContext();
    }

    @VisibleForTesting
    @SuppressLint(value={"InvalidWakeLockTag"})
    public SyncTask(FirebaseMessaging firebaseMessaging, long l) {
        TimeUnit timeUnit = TimeUnit.SECONDS;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        NamedThreadFactory namedThreadFactory = new NamedThreadFactory("firebase-iid-executor");
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(0, 1, 30L, timeUnit, linkedBlockingQueue, (ThreadFactory)namedThreadFactory);
        this.processorExecutor = threadPoolExecutor;
        this.firebaseMessaging = firebaseMessaging;
        this.nextDelaySeconds = l;
        this.syncWakeLock = ((PowerManager)this.getContext().getSystemService("power")).newWakeLock(1, "fiid-sync");
        this.syncWakeLock.setReferenceCounted(false);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @SuppressLint(value={"WakelockTimeout"})
    public void run() {
        block22: {
            block20: {
                block21: {
                    block18: {
                        block19: {
                            if (ServiceStarter.getInstance().hasWakeLockPermission(this.getContext())) {
                                this.syncWakeLock.acquire();
                            }
                            this.firebaseMessaging.setSyncScheduledOrRunning(true);
                            var1_1 = this.firebaseMessaging.isGmsCorePresent();
                            if (var1_1) break block18;
                            this.firebaseMessaging.setSyncScheduledOrRunning(false);
                            if (!ServiceStarter.getInstance().hasWakeLockPermission(this.getContext())) break block19;
                            this.syncWakeLock.release();
                            return;
                        }
                        return;
                    }
                    var1_1 = ServiceStarter.getInstance().hasAccessNetworkStatePermission(this.getContext());
                    if (!var1_1) break block20;
                    var1_1 = this.isDeviceConnected();
                    if (var1_1) break block20;
                    var1_2 = new ConnectivityChangeReceiver(this);
                    var1_2.registerReceiver();
                    if (!ServiceStarter.getInstance().hasWakeLockPermission(this.getContext())) break block21;
                    this.syncWakeLock.release();
                    return;
                }
                return;
            }
            var1_1 = this.maybeRefreshToken();
            if (!var1_1) break block22;
            this.firebaseMessaging.setSyncScheduledOrRunning(false);
lbl35:
            // 2 sources

            while (true) {
                if (ServiceStarter.getInstance().hasWakeLockPermission(this.getContext())) {
                    this.syncWakeLock.release();
                    return;
                }
                return;
            }
        }
        try {
            this.firebaseMessaging.syncWithDelaySecondsInternal(this.nextDelaySeconds);
            ** continue;
        }
        catch (IOException var1_3) {
            try {
                var2_6 = "FirebaseMessaging";
                var1_4 = var1_3.getMessage();
                var3_7 = String.valueOf(var1_4).length();
                var3_7 += 93;
            }
            catch (Throwable var1_5) {
                if (!ServiceStarter.getInstance().hasWakeLockPermission(this.getContext())) lbl-1000:
                // 2 sources

                {
                    throw var1_5;
                }
                this.syncWakeLock.release();
                ** continue;
            }
            var4_8 = new StringBuilder(var3_7);
            var4_8.append("Topic sync or token retrieval failed on hard failure exceptions: ");
            var4_8.append(var1_4);
            var4_8.append(". Won't retry the operation.");
            Log.e((String)var2_6, (String)var4_8.toString());
            this.firebaseMessaging.setSyncScheduledOrRunning(false);
            if (!ServiceStarter.getInstance().hasWakeLockPermission(this.getContext())) ** continue;
            this.syncWakeLock.release();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isDebugLogEnabled() {
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) return true;
        if (Build.VERSION.SDK_INT != 23) return false;
        if (!Log.isLoggable((String)"FirebaseMessaging", (int)3)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isDeviceConnected() {
        if ((syncTask = (ConnectivityManager)syncTask.getContext().getSystemService("connectivity")) == null) return false;
        SyncTask syncTask = syncTask.getActiveNetworkInfo();
        if (syncTask == null) return false;
        if (!syncTask.isConnected()) return false;
        return true;
    }

    @VisibleForTesting
    boolean maybeRefreshToken() throws IOException {
        IOException iOException2;
        block10: {
            block9: {
                block8: {
                    String string = ((SyncTask)((Object)string)).firebaseMessaging.blockingGetToken();
                    if (string != null) break block8;
                    Log.e((String)"FirebaseMessaging", (String)"Token retrieval failed: null");
                    return false;
                }
                boolean bl = Log.isLoggable((String)"FirebaseMessaging", (int)3);
                if (!bl) break block9;
                try {
                    Log.d((String)"FirebaseMessaging", (String)"Token successfully retrieved");
                }
                catch (IOException iOException2) {
                    if (GmsRpc.isErrorMessageForRetryableError(iOException2.getMessage())) {
                        String string = iOException2.getMessage();
                        String string2 = String.valueOf(string);
                        int n = string2.length();
                        StringBuilder stringBuilder = new StringBuilder(n + 52);
                        stringBuilder.append("Token retrieval failed: ");
                        stringBuilder.append(string);
                        stringBuilder.append(". Will retry token retrieval");
                        Log.w((String)"FirebaseMessaging", (String)stringBuilder.toString());
                        return false;
                    }
                    break block10;
                }
                catch (SecurityException securityException) {
                    Log.w((String)"FirebaseMessaging", (String)"Token retrieval failed with SecurityException. Will retry token retrieval");
                    return false;
                }
            }
            return true;
        }
        if (iOException2.getMessage() != null) {
            throw iOException2;
        }
        Log.w((String)"FirebaseMessaging", (String)"Token retrieval failed without exception message. Will retry token retrieval");
        return false;
    }

    @VisibleForTesting
    static class ConnectivityChangeReceiver
    extends BroadcastReceiver {
        @Nullable
        private SyncTask task;

        public ConnectivityChangeReceiver(SyncTask syncTask) {
            this.task = syncTask;
        }

        public void onReceive(Context object, Intent intent) {
            object = this.task;
            if (object == null) {
                return;
            }
            if (!((SyncTask)object).isDeviceConnected()) {
                return;
            }
            if (SyncTask.isDebugLogEnabled()) {
                Log.d((String)"FirebaseMessaging", (String)"Connectivity changed. Starting background sync.");
            }
            this.task.firebaseMessaging.enqueueTaskWithDelaySeconds(this.task, 0L);
            this.task.getContext().unregisterReceiver((BroadcastReceiver)this);
            this.task = null;
        }

        public void registerReceiver() {
            if (SyncTask.isDebugLogEnabled()) {
                Log.d((String)"FirebaseMessaging", (String)"Connectivity change received registered");
            }
            IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            this.task.getContext().registerReceiver((BroadcastReceiver)this, intentFilter);
        }
    }
}

