/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.stats.WakeLock;
import com.google.errorprone.annotations.RestrictedApi;
import com.google.firebase.messaging.WithinAppServiceConnection;
import java.util.concurrent.TimeUnit;

final class WakeLockHolder {
    private static final String EXTRA_WAKEFUL_INTENT = "com.google.firebase.iid.WakeLockHolder.wakefulintent";
    static final long WAKE_LOCK_ACQUIRE_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(1L);
    private static final Object syncObject = new Object();
    @GuardedBy(value="WakeLockHolder.syncObject")
    private static WakeLock wakeLock;

    WakeLockHolder() {
    }

    @GuardedBy(value="WakeLockHolder.syncObject")
    private static void checkAndInitWakeLock(Context context) {
        if (wakeLock == null) {
            wakeLock = new WakeLock(context, 1, "wake:com.google.firebase.iid.WakeLockHolder");
            wakeLock.setReferenceCounted(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ComponentName startWakefulService(@NonNull Context context, @NonNull Intent intent) {
        Object object = syncObject;
        synchronized (object) {
            WakeLockHolder.checkAndInitWakeLock(context);
            boolean isWakeLockAlreadyAcquired = WakeLockHolder.isWakefulIntent(intent);
            WakeLockHolder.setAsWakefulIntent(intent, true);
            ComponentName comp = context.startService(intent);
            if (comp == null) {
                return null;
            }
            if (!isWakeLockAlreadyAcquired) {
                wakeLock.acquire(WAKE_LOCK_ACQUIRE_TIMEOUT_MILLIS);
            }
            return comp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sendWakefulServiceIntent(Context context, WithinAppServiceConnection connection, Intent intent) {
        Object object = syncObject;
        synchronized (object) {
            WakeLockHolder.checkAndInitWakeLock(context);
            boolean isWakeLockAlreadyAcquired = WakeLockHolder.isWakefulIntent(intent);
            WakeLockHolder.setAsWakefulIntent(intent, true);
            if (!isWakeLockAlreadyAcquired) {
                wakeLock.acquire(WAKE_LOCK_ACQUIRE_TIMEOUT_MILLIS);
            }
            connection.sendIntent(intent).addOnCompleteListener(Runnable::run, t -> WakeLockHolder.completeWakefulIntent(intent));
        }
    }

    private static void setAsWakefulIntent(@NonNull Intent intent, boolean isWakeful) {
        intent.putExtra(EXTRA_WAKEFUL_INTENT, isWakeful);
    }

    @VisibleForTesting
    static boolean isWakefulIntent(@NonNull Intent intent) {
        return intent.getBooleanExtra(EXTRA_WAKEFUL_INTENT, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void completeWakefulIntent(@NonNull Intent intent) {
        Object object = syncObject;
        synchronized (object) {
            if (wakeLock != null && WakeLockHolder.isWakefulIntent(intent)) {
                WakeLockHolder.setAsWakefulIntent(intent, false);
                wakeLock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictedApi(explanation="To be used for testing purpose only", link="", allowedOnPath=".*firebase(-|_)(iid|messaging)/.*")
    static void acquireWakeLock(Intent intent, long millis) {
        Object object = syncObject;
        synchronized (object) {
            if (wakeLock != null) {
                WakeLockHolder.setAsWakefulIntent(intent, true);
                wakeLock.acquire(millis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictedApi(explanation="To be used for testing purpose only", link="", allowedOnPath=".*firebase(-|_)(iid|messaging)/.*")
    static void initWakeLock(Context context) {
        Object object = syncObject;
        synchronized (object) {
            WakeLockHolder.checkAndInitWakeLock(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictedApi(explanation="To be used for testing purpose only", link="", allowedOnPath=".*firebase(-|_)(iid|messaging)/.*")
    static void reset() {
        Object object = syncObject;
        synchronized (object) {
            wakeLock = null;
        }
    }
}

