/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.PowerManager;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.messaging.Constants;
import com.google.firebase.messaging.Metadata;
import com.google.firebase.messaging.TopicsSubscriber;
import java.io.IOException;

class TopicsSyncTask
implements Runnable {
    private final Context context;
    private final Metadata metadata;
    private final PowerManager.WakeLock syncWakeLock;
    private final TopicsSubscriber topicsSubscriber;
    private final long nextDelaySeconds;
    private static final Object TOPIC_SYNC_TASK_LOCK = new Object();
    @GuardedBy(value="TOPIC_SYNC_TASK_LOCK")
    private static Boolean hasWakeLockPermission = null;
    @GuardedBy(value="TOPIC_SYNC_TASK_LOCK")
    private static Boolean hasAccessNetworkStatePermission = null;

    TopicsSyncTask(TopicsSubscriber topicsSubscriber, Context context, Metadata metadata, long nextDelaySeconds) {
        this.topicsSubscriber = topicsSubscriber;
        this.context = context;
        this.nextDelaySeconds = nextDelaySeconds;
        this.metadata = metadata;
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.syncWakeLock = powerManager.newWakeLock(1, "wake:com.google.firebase.messaging");
    }

    @Override
    @SuppressLint(value={"Wakelock"})
    public void run() {
        if (TopicsSyncTask.hasWakeLockPermission(this.context)) {
            this.syncWakeLock.acquire(Constants.WAKE_LOCK_ACQUIRE_TIMEOUT_MILLIS);
        }
        try {
            this.topicsSubscriber.setSyncScheduledOrRunning(true);
            if (!this.metadata.isGmscorePresent()) {
                this.topicsSubscriber.setSyncScheduledOrRunning(false);
                return;
            }
            if (TopicsSyncTask.hasAccessNetworkStatePermission(this.context) && !this.isDeviceConnected()) {
                ConnectivityChangeReceiver receiver = new ConnectivityChangeReceiver(this);
                receiver.registerReceiver();
                return;
            }
            if (this.topicsSubscriber.syncTopics()) {
                this.topicsSubscriber.setSyncScheduledOrRunning(false);
            } else {
                this.topicsSubscriber.syncWithDelaySecondsInternal(this.nextDelaySeconds);
            }
        }
        catch (IOException e) {
            Log.e((String)"FirebaseMessaging", (String)("Failed to sync topics. Won't retry sync. " + e.getMessage()));
            this.topicsSubscriber.setSyncScheduledOrRunning(false);
        }
        finally {
            if (TopicsSyncTask.hasWakeLockPermission(this.context)) {
                try {
                    this.syncWakeLock.release();
                }
                catch (RuntimeException unused) {
                    Log.i((String)"FirebaseMessaging", (String)"TopicsSyncTask's wakelock was already released due to timeout.");
                }
            }
        }
    }

    private synchronized boolean isDeviceConnected() {
        ConnectivityManager cm = (ConnectivityManager)this.context.getSystemService("connectivity");
        NetworkInfo networkInfo = cm != null ? cm.getActiveNetworkInfo() : null;
        return networkInfo != null && networkInfo.isConnected();
    }

    private static boolean isLoggable() {
        return Log.isLoggable((String)"FirebaseMessaging", (int)3) || Build.VERSION.SDK_INT == 23 && Log.isLoggable((String)"FirebaseMessaging", (int)3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasWakeLockPermission(Context context) {
        Object object = TOPIC_SYNC_TASK_LOCK;
        synchronized (object) {
            hasWakeLockPermission = hasWakeLockPermission == null ? TopicsSyncTask.hasPermission(context, "android.permission.WAKE_LOCK", hasWakeLockPermission) : hasWakeLockPermission;
            return hasWakeLockPermission;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasAccessNetworkStatePermission(Context context) {
        Object object = TOPIC_SYNC_TASK_LOCK;
        synchronized (object) {
            hasAccessNetworkStatePermission = hasAccessNetworkStatePermission == null ? TopicsSyncTask.hasPermission(context, "android.permission.ACCESS_NETWORK_STATE", hasAccessNetworkStatePermission) : hasAccessNetworkStatePermission;
            return hasAccessNetworkStatePermission;
        }
    }

    private static boolean hasPermission(Context context, String permission2, Boolean cachedState) {
        boolean granted;
        if (cachedState != null) {
            return cachedState;
        }
        boolean bl = granted = context.checkCallingOrSelfPermission(permission2) == 0;
        if (!granted && Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)TopicsSyncTask.createPermissionMissingLog(permission2));
        }
        return granted;
    }

    private static String createPermissionMissingLog(String permission2) {
        return "Missing Permission: " + permission2 + ". This permission should normally be included by the manifest merger, but may needed to be manually added to your manifest";
    }

    @VisibleForTesting
    class ConnectivityChangeReceiver
    extends BroadcastReceiver {
        @GuardedBy(value="this")
        @Nullable
        private TopicsSyncTask task;

        public ConnectivityChangeReceiver(TopicsSyncTask task) {
            this.task = task;
        }

        public synchronized void onReceive(Context context, Intent intent) {
            if (this.task == null) {
                return;
            }
            if (!this.task.isDeviceConnected()) {
                return;
            }
            if (TopicsSyncTask.isLoggable()) {
                Log.d((String)"FirebaseMessaging", (String)"Connectivity changed. Starting background sync.");
            }
            this.task.topicsSubscriber.scheduleSyncTaskWithDelaySeconds(this.task, 0L);
            context.unregisterReceiver((BroadcastReceiver)this);
            this.task = null;
        }

        public void registerReceiver() {
            if (TopicsSyncTask.isLoggable()) {
                Log.d((String)"FirebaseMessaging", (String)"Connectivity change received registered");
            }
            TopicsSyncTask.this.context.registerReceiver((BroadcastReceiver)this, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }
}

