/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.google.firebase.messaging.MessagingAnalytics;
import java.util.ArrayDeque;
import java.util.Queue;

class FcmLifecycleCallbacks
implements Application.ActivityLifecycleCallbacks {
    private static final int RECENTLY_LOGGED_MESSAGE_IDS_MAX_SIZE = 10;
    private final Queue<String> recentlyLoggedMessageIds = new ArrayDeque<String>(10);

    FcmLifecycleCallbacks() {
    }

    @SuppressLint(value={"ThreadPoolCreation"})
    public void onActivityCreated(Activity createdActivity, Bundle instanceState) {
        Intent startingIntent = createdActivity.getIntent();
        if (startingIntent == null) {
            return;
        }
        if (Build.VERSION.SDK_INT <= 25) {
            new Handler(Looper.getMainLooper()).post(() -> this.logNotificationOpen(startingIntent));
        } else {
            this.logNotificationOpen(startingIntent);
        }
    }

    public void onActivityPaused(Activity pausedActivity) {
    }

    public void onActivityDestroyed(Activity destroyedActivity) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    private void logNotificationOpen(Intent startingIntent) {
        Bundle analyticsData = null;
        try {
            Bundle extras = startingIntent.getExtras();
            if (extras != null) {
                String messageId = MessagingAnalytics.getMessageId(extras);
                if (!TextUtils.isEmpty((CharSequence)messageId)) {
                    if (this.recentlyLoggedMessageIds.contains(messageId)) {
                        return;
                    }
                    this.recentlyLoggedMessageIds.add(messageId);
                }
                analyticsData = extras.getBundle("gcm.n.analytics_data");
            }
        }
        catch (RuntimeException e) {
            Log.w((String)"FirebaseMessaging", (String)"Failed trying to get analytics data from Intent extras.", (Throwable)e);
        }
        if (MessagingAnalytics.shouldUploadScionMetrics(analyticsData)) {
            MessagingAnalytics.logNotificationOpen(analyticsData);
        }
    }
}

