/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.messaging.zza;
import com.google.firebase.messaging.zzc;
import java.util.Map;

public final class RemoteMessage
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<RemoteMessage> CREATOR = new zzc();
    final int mVersionCode;
    Bundle eZ;
    private Map<String, String> zzczu;
    private Notification bhM;

    RemoteMessage(int n, Bundle bundle) {
        this.mVersionCode = n;
        this.eZ = bundle;
    }

    RemoteMessage(Bundle bundle) {
        this(1, bundle);
    }

    void zzak(Intent intent) {
        intent.putExtras(this.eZ);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzc.zza(this, parcel, n);
    }

    public String getFrom() {
        return this.eZ.getString("from");
    }

    public String getTo() {
        return this.eZ.getString("google.to");
    }

    public Map<String, String> getData() {
        if (this.zzczu == null) {
            this.zzczu = new ArrayMap();
            for (String string : this.eZ.keySet()) {
                Object object = this.eZ.get(string);
                if (!(object instanceof String)) continue;
                String string2 = (String)object;
                if (string.startsWith("google.") || string.startsWith("gcm.") || string.equals("from") || string.equals("message_type") || string.equals("collapse_key")) continue;
                this.zzczu.put(string, string2);
            }
        }
        return this.zzczu;
    }

    public String getCollapseKey() {
        return this.eZ.getString("collapse_key");
    }

    public String getMessageId() {
        String string = this.eZ.getString("google.message_id");
        if (string == null) {
            string = this.eZ.getString("message_id");
        }
        return string;
    }

    public String getMessageType() {
        return this.eZ.getString("message_type");
    }

    public long getSentTime() {
        return this.eZ.getLong("google.sent_time");
    }

    public int getTtl() {
        Object object = this.eZ.get("google.ttl");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(13 + String.valueOf(string).length()).append("Invalid TTL: ").append(string).toString());
            }
        }
        return 0;
    }

    public Notification getNotification() {
        if (this.bhM == null && zza.zzad(this.eZ)) {
            this.bhM = new Notification(this.eZ);
        }
        return this.bhM;
    }

    public static class Notification {
        private final String HP;
        private final String bhN;
        private final String[] bhO;
        private final String zzbjs;
        private final String bhP;
        private final String[] bhQ;
        private final String bhR;
        private final String bhS;
        private final String mTag;
        private final String Nu;
        private final String bhT;

        private Notification(Bundle bundle) {
            this.HP = zza.zzf(bundle, "gcm.n.title");
            this.bhN = zza.zzh(bundle, "gcm.n.title");
            this.bhO = this.zzj(bundle, "gcm.n.title");
            this.zzbjs = zza.zzf(bundle, "gcm.n.body");
            this.bhP = zza.zzh(bundle, "gcm.n.body");
            this.bhQ = this.zzj(bundle, "gcm.n.body");
            this.bhR = zza.zzf(bundle, "gcm.n.icon");
            this.bhS = zza.zzat(bundle);
            this.mTag = zza.zzf(bundle, "gcm.n.tag");
            this.Nu = zza.zzf(bundle, "gcm.n.color");
            this.bhT = zza.zzf(bundle, "gcm.n.click_action");
        }

        private String[] zzj(Bundle bundle, String string) {
            Object[] objectArray = zza.zzi(bundle, string);
            if (objectArray == null) {
                return null;
            }
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = String.valueOf(objectArray[i]);
            }
            return stringArray;
        }

        public String getTitle() {
            return this.HP;
        }

        public String getTitleLocalizationKey() {
            return this.bhN;
        }

        public String[] getTitleLocalizationArgs() {
            return this.bhO;
        }

        public String getBody() {
            return this.zzbjs;
        }

        public String getBodyLocalizationKey() {
            return this.bhP;
        }

        public String[] getBodyLocalizationArgs() {
            return this.bhQ;
        }

        public String getIcon() {
            return this.bhR;
        }

        public String getSound() {
            return this.bhS;
        }

        public String getTag() {
            return this.mTag;
        }

        public String getColor() {
            return this.Nu;
        }

        public String getClickAction() {
            return this.bhT;
        }
    }

    public static class Builder {
        private final Bundle eZ = new Bundle();
        private final Map<String, String> zzczu = new ArrayMap();

        public Builder(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                String string2 = String.valueOf(string);
                throw new IllegalArgumentException(string2.length() != 0 ? "Invalid to: ".concat(string2) : new String("Invalid to: "));
            }
            this.eZ.putString("google.to", string);
        }

        public RemoteMessage build() {
            Bundle bundle = new Bundle();
            for (Map.Entry<String, String> entry : this.zzczu.entrySet()) {
                bundle.putString(entry.getKey(), entry.getValue());
            }
            bundle.putAll(this.eZ);
            String string = FirebaseInstanceId.getInstance().getToken();
            if (string != null) {
                this.eZ.putString("from", string);
            } else {
                this.eZ.remove("from");
            }
            return new RemoteMessage(bundle);
        }

        public Builder addData(String string, String string2) {
            this.zzczu.put(string, string2);
            return this;
        }

        public Builder setData(Map<String, String> map) {
            this.zzczu.clear();
            this.zzczu.putAll(map);
            return this;
        }

        public Builder clearData() {
            this.zzczu.clear();
            return this;
        }

        public Builder setMessageId(String string) {
            this.eZ.putString("google.message_id", string);
            return this;
        }

        public Builder setMessageType(String string) {
            this.eZ.putString("message_type", string);
            return this;
        }

        public Builder setTtl(int n) {
            this.eZ.putString("google.ttl", String.valueOf(n));
            return this;
        }

        public Builder setCollapseKey(String string) {
            this.eZ.putString("collapse_key", string);
            return this;
        }
    }
}

