/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.messaging.zza;
import com.google.firebase.messaging.zzc;
import java.util.Map;

public final class RemoteMessage
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<RemoteMessage> CREATOR = new zzc();
    final int mVersionCode;
    Bundle hf;
    private Map<String, String> be;
    private Notification bkZ;

    RemoteMessage(int n, Bundle bundle) {
        this.mVersionCode = n;
        this.hf = bundle;
    }

    RemoteMessage(Bundle bundle) {
        this(1, bundle);
    }

    void zzak(Intent intent) {
        intent.putExtras(this.hf);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzc.zza(this, parcel, n);
    }

    public String getFrom() {
        return this.hf.getString("from");
    }

    public String getTo() {
        return this.hf.getString("google.to");
    }

    public Map<String, String> getData() {
        if (this.be == null) {
            this.be = new ArrayMap();
            for (String string : this.hf.keySet()) {
                Object object = this.hf.get(string);
                if (!(object instanceof String)) continue;
                String string2 = (String)object;
                if (string.startsWith("google.") || string.startsWith("gcm.") || string.equals("from") || string.equals("message_type") || string.equals("collapse_key")) continue;
                this.be.put(string, string2);
            }
        }
        return this.be;
    }

    public String getCollapseKey() {
        return this.hf.getString("collapse_key");
    }

    public String getMessageId() {
        String string = this.hf.getString("google.message_id");
        if (string == null) {
            string = this.hf.getString("message_id");
        }
        return string;
    }

    public String getMessageType() {
        return this.hf.getString("message_type");
    }

    public long getSentTime() {
        return this.hf.getLong("google.sent_time");
    }

    public int getTtl() {
        Object object = this.hf.get("google.ttl");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(13 + String.valueOf(string).length()).append("Invalid TTL: ").append(string).toString());
            }
        }
        return 0;
    }

    public Notification getNotification() {
        if (this.bkZ == null && zza.zzad(this.hf)) {
            this.bkZ = new Notification(this.hf);
        }
        return this.bkZ;
    }

    public static class Notification {
        private final String JB;
        private final String bla;
        private final String[] blb;
        private final String zzbna;
        private final String blc;
        private final String[] bld;
        private final String ble;
        private final String blf;
        private final String mTag;
        private final String Pf;
        private final String blg;

        private Notification(Bundle bundle) {
            this.JB = zza.zzf(bundle, "gcm.n.title");
            this.bla = zza.zzh(bundle, "gcm.n.title");
            this.blb = this.zzj(bundle, "gcm.n.title");
            this.zzbna = zza.zzf(bundle, "gcm.n.body");
            this.blc = zza.zzh(bundle, "gcm.n.body");
            this.bld = this.zzj(bundle, "gcm.n.body");
            this.ble = zza.zzf(bundle, "gcm.n.icon");
            this.blf = zza.zzat(bundle);
            this.mTag = zza.zzf(bundle, "gcm.n.tag");
            this.Pf = zza.zzf(bundle, "gcm.n.color");
            this.blg = zza.zzf(bundle, "gcm.n.click_action");
        }

        private String[] zzj(Bundle bundle, String string) {
            Object[] objectArray = zza.zzi(bundle, string);
            if (objectArray == null) {
                return null;
            }
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = String.valueOf(objectArray[i]);
            }
            return stringArray;
        }

        public String getTitle() {
            return this.JB;
        }

        public String getTitleLocalizationKey() {
            return this.bla;
        }

        public String[] getTitleLocalizationArgs() {
            return this.blb;
        }

        public String getBody() {
            return this.zzbna;
        }

        public String getBodyLocalizationKey() {
            return this.blc;
        }

        public String[] getBodyLocalizationArgs() {
            return this.bld;
        }

        public String getIcon() {
            return this.ble;
        }

        public String getSound() {
            return this.blf;
        }

        public String getTag() {
            return this.mTag;
        }

        public String getColor() {
            return this.Pf;
        }

        public String getClickAction() {
            return this.blg;
        }
    }

    public static class Builder {
        private final Bundle hf = new Bundle();
        private final Map<String, String> be = new ArrayMap();

        public Builder(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                String string2 = String.valueOf(string);
                throw new IllegalArgumentException(string2.length() != 0 ? "Invalid to: ".concat(string2) : new String("Invalid to: "));
            }
            this.hf.putString("google.to", string);
        }

        public RemoteMessage build() {
            Bundle bundle = new Bundle();
            for (Map.Entry<String, String> entry : this.be.entrySet()) {
                bundle.putString(entry.getKey(), entry.getValue());
            }
            bundle.putAll(this.hf);
            String string = FirebaseInstanceId.getInstance().getToken();
            if (string != null) {
                this.hf.putString("from", string);
            } else {
                this.hf.remove("from");
            }
            return new RemoteMessage(bundle);
        }

        public Builder addData(String string, String string2) {
            this.be.put(string, string2);
            return this;
        }

        public Builder setData(Map<String, String> map) {
            this.be.clear();
            this.be.putAll(map);
            return this;
        }

        public Builder clearData() {
            this.be.clear();
            return this;
        }

        public Builder setMessageId(String string) {
            this.hf.putString("google.message_id", string);
            return this;
        }

        public Builder setMessageType(String string) {
            this.hf.putString("message_type", string);
            return this;
        }

        public Builder setTtl(int n) {
            this.hf.putString("google.ttl", String.valueOf(n));
            return this;
        }

        public Builder setCollapseKey(String string) {
            this.hf.putString("collapse_key", string);
            return this;
        }
    }
}

