/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.config;

import android.content.Context;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.perf.BuildConfig;
import com.google.firebase.perf.config.ConfigurationConstants;
import com.google.firebase.perf.config.ConfigurationFlag;
import com.google.firebase.perf.config.DeviceCacheManager;
import com.google.firebase.perf.config.RemoteConfigManager;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.util.ImmutableBundle;
import com.google.firebase.perf.util.Optional;
import com.google.firebase.perf.util.Utils;

public class ConfigResolver {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    private static volatile ConfigResolver instance;
    private final RemoteConfigManager remoteConfigManager;
    private ImmutableBundle metadataBundle;
    private DeviceCacheManager deviceCacheManager;

    @VisibleForTesting
    public ConfigResolver(@Nullable RemoteConfigManager remoteConfigManager, @Nullable ImmutableBundle metadataBundle, @Nullable DeviceCacheManager deviceCacheManager) {
        this.remoteConfigManager = remoteConfigManager == null ? RemoteConfigManager.getInstance() : remoteConfigManager;
        this.metadataBundle = metadataBundle == null ? new ImmutableBundle() : metadataBundle;
        this.deviceCacheManager = deviceCacheManager == null ? DeviceCacheManager.getInstance() : deviceCacheManager;
    }

    public static synchronized ConfigResolver getInstance() {
        if (instance == null) {
            instance = new ConfigResolver(null, null, null);
        }
        return instance;
    }

    @VisibleForTesting
    public static void clearInstance() {
        instance = null;
    }

    @VisibleForTesting
    public void setDeviceCacheManager(DeviceCacheManager deviceCacheManager) {
        this.deviceCacheManager = deviceCacheManager;
    }

    public void setContentProviderContext(Context context) {
        this.setApplicationContext(context.getApplicationContext());
    }

    public void setApplicationContext(Context appContext) {
        logger.setLogcatEnabled(Utils.isDebugLoggingEnabled(appContext));
        this.deviceCacheManager.setContext(appContext);
    }

    public void setMetadataBundle(ImmutableBundle bundle) {
        this.metadataBundle = bundle;
    }

    public boolean isPerformanceMonitoringEnabled() {
        Boolean isPerformanceCollectionEnabled = this.getIsPerformanceCollectionEnabled();
        return (isPerformanceCollectionEnabled == null || isPerformanceCollectionEnabled == true) && this.getIsServiceCollectionEnabled();
    }

    @Nullable
    public Boolean getIsPerformanceCollectionEnabled() {
        if (this.getIsPerformanceCollectionDeactivated().booleanValue()) {
            return false;
        }
        ConfigurationConstants.CollectionEnabled collectionEnabled = ConfigurationConstants.CollectionEnabled.getInstance();
        Optional<Boolean> deviceCacheValue = this.getDeviceCacheBoolean(collectionEnabled);
        if (deviceCacheValue.isAvailable()) {
            return deviceCacheValue.get();
        }
        Optional<Boolean> metadataValue = this.getMetadataBoolean(collectionEnabled);
        if (metadataValue.isAvailable()) {
            return metadataValue.get();
        }
        return null;
    }

    @Nullable
    public Boolean getIsPerformanceCollectionDeactivated() {
        ConfigurationConstants.CollectionDeactivated deactivated = ConfigurationConstants.CollectionDeactivated.getInstance();
        Optional<Boolean> metadataValue = this.getMetadataBoolean(deactivated);
        if (metadataValue.isAvailable()) {
            return metadataValue.get();
        }
        return deactivated.getDefault();
    }

    public void setIsPerformanceCollectionEnabled(Boolean isEnabled) {
        if (this.getIsPerformanceCollectionDeactivated().booleanValue()) {
            return;
        }
        ConfigurationConstants.CollectionEnabled collectionEnabled = ConfigurationConstants.CollectionEnabled.getInstance();
        String collectionEnabledCachingFlagName = collectionEnabled.getDeviceCacheFlag();
        if (collectionEnabledCachingFlagName != null) {
            if (isEnabled != null) {
                this.deviceCacheManager.setValue(collectionEnabledCachingFlagName, Boolean.TRUE.equals(isEnabled));
            } else {
                this.deviceCacheManager.clear(collectionEnabledCachingFlagName);
            }
        }
    }

    public boolean getIsServiceCollectionEnabled() {
        return this.getIsSdkEnabled() && !this.getIsSdkVersionDisabled();
    }

    private boolean getIsSdkEnabled() {
        ConfigurationConstants.SdkEnabled config = ConfigurationConstants.SdkEnabled.getInstance();
        Optional<Boolean> rcValue = this.getRemoteConfigBoolean(config);
        if (rcValue.isAvailable()) {
            if (this.remoteConfigManager.isLastFetchFailed()) {
                return false;
            }
            this.deviceCacheManager.setValue(config.getDeviceCacheFlag(), rcValue.get());
            return rcValue.get();
        }
        Optional<Boolean> deviceCacheValue = this.getDeviceCacheBoolean(config);
        if (deviceCacheValue.isAvailable()) {
            return deviceCacheValue.get();
        }
        return config.getDefault();
    }

    private boolean getIsSdkVersionDisabled() {
        ConfigurationConstants.SdkDisabledVersions config = ConfigurationConstants.SdkDisabledVersions.getInstance();
        Optional<String> rcValue = this.getRemoteConfigString(config);
        if (rcValue.isAvailable()) {
            this.deviceCacheManager.setValue(config.getDeviceCacheFlag(), rcValue.get());
            return this.isFireperfSdkVersionInList(rcValue.get());
        }
        Optional<String> deviceCacheValue = this.getDeviceCacheString(config);
        if (deviceCacheValue.isAvailable()) {
            return this.isFireperfSdkVersionInList(deviceCacheValue.get());
        }
        return this.isFireperfSdkVersionInList(config.getDefault());
    }

    private boolean isFireperfSdkVersionInList(String versions) {
        if (versions.trim().isEmpty()) {
            return false;
        }
        for (String version : versions.split(";")) {
            if (!version.trim().equals(BuildConfig.FIREPERF_VERSION_NAME)) continue;
            return true;
        }
        return false;
    }

    public float getTraceSamplingRate() {
        ConfigurationConstants.TraceSamplingRate config = ConfigurationConstants.TraceSamplingRate.getInstance();
        Optional<Float> rcValue = this.getRemoteConfigFloat(config);
        if (rcValue.isAvailable() && this.isSamplingRateValid(rcValue.get().floatValue())) {
            this.deviceCacheManager.setValue(config.getDeviceCacheFlag(), rcValue.get().floatValue());
            return rcValue.get().floatValue();
        }
        Optional<Float> deviceCacheValue = this.getDeviceCacheFloat(config);
        if (deviceCacheValue.isAvailable() && this.isSamplingRateValid(deviceCacheValue.get().floatValue())) {
            return deviceCacheValue.get().floatValue();
        }
        return config.getDefault().floatValue();
    }

    public float getNetworkRequestSamplingRate() {
        ConfigurationConstants.NetworkRequestSamplingRate config = ConfigurationConstants.NetworkRequestSamplingRate.getInstance();
        Optional<Float> rcValue = this.getRemoteConfigFloat(config);
        if (rcValue.isAvailable() && this.isSamplingRateValid(rcValue.get().floatValue())) {
            this.deviceCacheManager.setValue(config.getDeviceCacheFlag(), rcValue.get().floatValue());
            return rcValue.get().floatValue();
        }
        Optional<Float> deviceCacheValue = this.getDeviceCacheFloat(config);
        if (deviceCacheValue.isAvailable() && this.isSamplingRateValid(deviceCacheValue.get().floatValue())) {
            return deviceCacheValue.get().floatValue();
        }
        return config.getDefault().floatValue();
    }

    public float getSessionsSamplingRate() {
        float samplingRate;
        ConfigurationConstants.SessionsSamplingRate config = ConfigurationConstants.SessionsSamplingRate.getInstance();
        Optional<Float> metadataValue = this.getMetadataFloat(config);
        if (metadataValue.isAvailable() && this.isSamplingRateValid(samplingRate = metadataValue.get().floatValue() / 100.0f)) {
            return samplingRate;
        }
        Optional<Float> rcValue = this.getRemoteConfigFloat(config);
        if (rcValue.isAvailable() && this.isSamplingRateValid(rcValue.get().floatValue())) {
            this.deviceCacheManager.setValue(config.getDeviceCacheFlag(), rcValue.get().floatValue());
            return rcValue.get().floatValue();
        }
        Optional<Float> deviceCacheValue = this.getDeviceCacheFloat(config);
        if (deviceCacheValue.isAvailable() && this.isSamplingRateValid(deviceCacheValue.get().floatValue())) {
            return deviceCacheValue.get().floatValue();
        }
        return config.getDefault().floatValue();
    }

    public long getSessionsCpuCaptureFrequencyForegroundMs() {
        ConfigurationConstants.SessionsCpuCaptureFrequencyForegroundMs config = ConfigurationConstants.SessionsCpuCaptureFrequencyForegroundMs.getInstance();
        Optional<Long> metadataValue = this.getMetadataLong(config);
        if (metadataValue.isAvailable() && this.isGaugeCaptureFrequencyMsValid(metadataValue.get())) {
            return metadataValue.get();
        }
        Optional<Long> rcValue = this.getRemoteConfigLong(config);
        if (rcValue.isAvailable() && this.isGaugeCaptureFrequencyMsValid(rcValue.get())) {
            this.deviceCacheManager.setValue(config.getDeviceCacheFlag(), rcValue.get());
            return rcValue.get();
        }
        Optional<Long> deviceCacheValue = this.getDeviceCacheLong(config);
        if (deviceCacheValue.isAvailable() && this.isGaugeCaptureFrequencyMsValid(deviceCacheValue.get())) {
            return deviceCacheValue.get();
        }
        return config.getDefault();
    }

    public long getSessionsCpuCaptureFrequencyBackgroundMs() {
        ConfigurationConstants.SessionsCpuCaptureFrequencyBackgroundMs config = ConfigurationConstants.SessionsCpuCaptureFrequencyBackgroundMs.getInstance();
        Optional<Long> metadataValue = this.getMetadataLong(config);
        if (metadataValue.isAvailable() && this.isGaugeCaptureFrequencyMsValid(metadataValue.get())) {
            return metadataValue.get();
        }
        Optional<Long> rcValue = this.getRemoteConfigLong(config);
        if (rcValue.isAvailable() && this.isGaugeCaptureFrequencyMsValid(rcValue.get())) {
            this.deviceCacheManager.setValue(config.getDeviceCacheFlag(), rcValue.get());
            return rcValue.get();
        }
        Optional<Long> deviceCacheValue = this.getDeviceCacheLong(config);
        if (deviceCacheValue.isAvailable() && this.isGaugeCaptureFrequencyMsValid(deviceCacheValue.get())) {
            return deviceCacheValue.get();
        }
        return config.getDefault();
    }

    public long getSessionsMemoryCaptureFrequencyForegroundMs() {
        ConfigurationConstants.SessionsMemoryCaptureFrequencyForegroundMs config = ConfigurationConstants.SessionsMemoryCaptureFrequencyForegroundMs.getInstance();
        Optional<Long> metadataValue = this.getMetadataLong(config);
        if (metadataValue.isAvailable() && this.isGaugeCaptureFrequencyMsValid(metadataValue.get())) {
            return metadataValue.get();
        }
        Optional<Long> rcValue = this.getRemoteConfigLong(config);
        if (rcValue.isAvailable() && this.isGaugeCaptureFrequencyMsValid(rcValue.get())) {
            this.deviceCacheManager.setValue(config.getDeviceCacheFlag(), rcValue.get());
            return rcValue.get();
        }
        Optional<Long> deviceCacheValue = this.getDeviceCacheLong(config);
        if (deviceCacheValue.isAvailable() && this.isGaugeCaptureFrequencyMsValid(deviceCacheValue.get())) {
            return deviceCacheValue.get();
        }
        return config.getDefault();
    }

    public long getSessionsMemoryCaptureFrequencyBackgroundMs() {
        ConfigurationConstants.SessionsMemoryCaptureFrequencyBackgroundMs config = ConfigurationConstants.SessionsMemoryCaptureFrequencyBackgroundMs.getInstance();
        Optional<Long> metadataValue = this.getMetadataLong(config);
        if (metadataValue.isAvailable() && this.isGaugeCaptureFrequencyMsValid(metadataValue.get())) {
            return metadataValue.get();
        }
        Optional<Long> rcValue = this.getRemoteConfigLong(config);
        if (rcValue.isAvailable() && this.isGaugeCaptureFrequencyMsValid(rcValue.get())) {
            this.deviceCacheManager.setValue(config.getDeviceCacheFlag(), rcValue.get());
            return rcValue.get();
        }
        Optional<Long> deviceCacheValue = this.getDeviceCacheLong(config);
        if (deviceCacheValue.isAvailable() && this.isGaugeCaptureFrequencyMsValid(deviceCacheValue.get())) {
            return deviceCacheValue.get();
        }
        return config.getDefault();
    }

    public long getSessionsMaxDurationMinutes() {
        ConfigurationConstants.SessionsMaxDurationMinutes config = ConfigurationConstants.SessionsMaxDurationMinutes.getInstance();
        Optional<Long> metadataValue = this.getMetadataLong(config);
        if (metadataValue.isAvailable() && this.isSessionsMaxDurationMinutesValid(metadataValue.get())) {
            return metadataValue.get();
        }
        Optional<Long> rcValue = this.getRemoteConfigLong(config);
        if (rcValue.isAvailable() && this.isSessionsMaxDurationMinutesValid(rcValue.get())) {
            this.deviceCacheManager.setValue(config.getDeviceCacheFlag(), rcValue.get());
            return rcValue.get();
        }
        Optional<Long> deviceCacheValue = this.getDeviceCacheLong(config);
        if (deviceCacheValue.isAvailable() && this.isSessionsMaxDurationMinutesValid(deviceCacheValue.get())) {
            return deviceCacheValue.get();
        }
        return config.getDefault();
    }

    public long getTraceEventCountForeground() {
        ConfigurationConstants.TraceEventCountForeground config = ConfigurationConstants.TraceEventCountForeground.getInstance();
        Optional<Long> rcValue = this.getRemoteConfigLong(config);
        if (rcValue.isAvailable() && this.isEventCountValid(rcValue.get())) {
            this.deviceCacheManager.setValue(config.getDeviceCacheFlag(), rcValue.get());
            return rcValue.get();
        }
        Optional<Long> deviceCacheValue = this.getDeviceCacheLong(config);
        if (deviceCacheValue.isAvailable() && this.isEventCountValid(deviceCacheValue.get())) {
            return deviceCacheValue.get();
        }
        return config.getDefault();
    }

    public long getTraceEventCountBackground() {
        ConfigurationConstants.TraceEventCountBackground config = ConfigurationConstants.TraceEventCountBackground.getInstance();
        Optional<Long> rcValue = this.getRemoteConfigLong(config);
        if (rcValue.isAvailable() && this.isEventCountValid(rcValue.get())) {
            this.deviceCacheManager.setValue(config.getDeviceCacheFlag(), rcValue.get());
            return rcValue.get();
        }
        Optional<Long> deviceCacheValue = this.getDeviceCacheLong(config);
        if (deviceCacheValue.isAvailable() && this.isEventCountValid(deviceCacheValue.get())) {
            return deviceCacheValue.get();
        }
        return config.getDefault();
    }

    public long getNetworkEventCountForeground() {
        ConfigurationConstants.NetworkEventCountForeground config = ConfigurationConstants.NetworkEventCountForeground.getInstance();
        Optional<Long> rcValue = this.getRemoteConfigLong(config);
        if (rcValue.isAvailable() && this.isEventCountValid(rcValue.get())) {
            this.deviceCacheManager.setValue(config.getDeviceCacheFlag(), rcValue.get());
            return rcValue.get();
        }
        Optional<Long> deviceCacheValue = this.getDeviceCacheLong(config);
        if (deviceCacheValue.isAvailable() && this.isEventCountValid(deviceCacheValue.get())) {
            return deviceCacheValue.get();
        }
        return config.getDefault();
    }

    public long getNetworkEventCountBackground() {
        ConfigurationConstants.NetworkEventCountBackground config = ConfigurationConstants.NetworkEventCountBackground.getInstance();
        Optional<Long> rcValue = this.getRemoteConfigLong(config);
        if (rcValue.isAvailable() && this.isEventCountValid(rcValue.get())) {
            this.deviceCacheManager.setValue(config.getDeviceCacheFlag(), rcValue.get());
            return rcValue.get();
        }
        Optional<Long> deviceCacheValue = this.getDeviceCacheLong(config);
        if (deviceCacheValue.isAvailable() && this.isEventCountValid(deviceCacheValue.get())) {
            return deviceCacheValue.get();
        }
        return config.getDefault();
    }

    public long getRateLimitSec() {
        ConfigurationConstants.RateLimitSec config = ConfigurationConstants.RateLimitSec.getInstance();
        Optional<Long> rcValue = this.getRemoteConfigLong(config);
        if (rcValue.isAvailable() && this.isTimeRangeSecValid(rcValue.get())) {
            this.deviceCacheManager.setValue(config.getDeviceCacheFlag(), rcValue.get());
            return rcValue.get();
        }
        Optional<Long> deviceCacheValue = this.getDeviceCacheLong(config);
        if (deviceCacheValue.isAvailable() && this.isTimeRangeSecValid(deviceCacheValue.get())) {
            return deviceCacheValue.get();
        }
        return config.getDefault();
    }

    public String getAndCacheLogSourceName() {
        String logSourceName;
        ConfigurationConstants.LogSourceName configFlag = ConfigurationConstants.LogSourceName.getInstance();
        if (BuildConfig.ENFORCE_DEFAULT_LOG_SRC.booleanValue()) {
            return configFlag.getDefault();
        }
        String remoteConfigFlag = configFlag.getRemoteConfigFlag();
        long remoteConfigValue = remoteConfigFlag == null ? -1L : this.remoteConfigManager.getRemoteConfigValueOrDefault(remoteConfigFlag, -1L);
        String deviceCacheFlag = configFlag.getDeviceCacheFlag();
        if (ConfigurationConstants.LogSourceName.isLogSourceKnown(remoteConfigValue) && (logSourceName = ConfigurationConstants.LogSourceName.getLogSourceName(remoteConfigValue)) != null) {
            this.deviceCacheManager.setValue(deviceCacheFlag, logSourceName);
            return logSourceName;
        }
        Optional<String> deviceCacheValue = this.getDeviceCacheString(configFlag);
        if (deviceCacheValue.isAvailable()) {
            return deviceCacheValue.get();
        }
        return configFlag.getDefault();
    }

    public float getFragmentSamplingRate() {
        float samplingRate;
        ConfigurationConstants.FragmentSamplingRate config = ConfigurationConstants.FragmentSamplingRate.getInstance();
        Optional<Float> metadataValue = this.getMetadataFloat(config);
        if (metadataValue.isAvailable() && this.isSamplingRateValid(samplingRate = metadataValue.get().floatValue() / 100.0f)) {
            return samplingRate;
        }
        Optional<Float> rcValue = this.getRemoteConfigFloat(config);
        if (rcValue.isAvailable() && this.isSamplingRateValid(rcValue.get().floatValue())) {
            this.deviceCacheManager.setValue(config.getDeviceCacheFlag(), rcValue.get().floatValue());
            return rcValue.get().floatValue();
        }
        Optional<Float> deviceCacheValue = this.getDeviceCacheFloat(config);
        if (deviceCacheValue.isAvailable() && this.isSamplingRateValid(deviceCacheValue.get().floatValue())) {
            return deviceCacheValue.get().floatValue();
        }
        return config.getDefault().floatValue();
    }

    public boolean getIsExperimentTTIDEnabled() {
        ConfigurationConstants.ExperimentTTID config = ConfigurationConstants.ExperimentTTID.getInstance();
        Optional<Boolean> metadataValue = this.getMetadataBoolean(config);
        if (metadataValue.isAvailable()) {
            return metadataValue.get();
        }
        Optional<Boolean> rcValue = this.getRemoteConfigBoolean(config);
        if (rcValue.isAvailable()) {
            this.deviceCacheManager.setValue(config.getDeviceCacheFlag(), rcValue.get());
            return rcValue.get();
        }
        Optional<Boolean> deviceCacheValue = this.getDeviceCacheBoolean(config);
        if (deviceCacheValue.isAvailable()) {
            return deviceCacheValue.get();
        }
        return config.getDefault();
    }

    private Optional<Boolean> getMetadataBoolean(ConfigurationFlag<Boolean> config) {
        return this.metadataBundle.getBoolean(config.getMetadataFlag());
    }

    private Optional<Float> getMetadataFloat(ConfigurationFlag<Float> config) {
        return this.metadataBundle.getFloat(config.getMetadataFlag());
    }

    private Optional<Long> getMetadataLong(ConfigurationFlag<Long> config) {
        return this.metadataBundle.getLong(config.getMetadataFlag());
    }

    private Optional<Float> getRemoteConfigFloat(ConfigurationFlag<Float> config) {
        return this.remoteConfigManager.getFloat(config.getRemoteConfigFlag());
    }

    private Optional<Long> getRemoteConfigLong(ConfigurationFlag<Long> config) {
        return this.remoteConfigManager.getLong(config.getRemoteConfigFlag());
    }

    private Optional<Boolean> getRemoteConfigBoolean(ConfigurationFlag<Boolean> config) {
        return this.remoteConfigManager.getBoolean(config.getRemoteConfigFlag());
    }

    private Optional<String> getRemoteConfigString(ConfigurationFlag<String> config) {
        return this.remoteConfigManager.getString(config.getRemoteConfigFlag());
    }

    private Long getRemoteConfigValue(ConfigurationFlag<Long> configFlag) {
        String remoteConfigFlag = configFlag.getRemoteConfigFlag();
        return remoteConfigFlag == null ? configFlag.getDefault() : this.remoteConfigManager.getRemoteConfigValueOrDefault(remoteConfigFlag, configFlag.getDefault());
    }

    private Optional<Float> getDeviceCacheFloat(ConfigurationFlag<Float> config) {
        return this.deviceCacheManager.getFloat(config.getDeviceCacheFlag());
    }

    private Optional<Long> getDeviceCacheLong(ConfigurationFlag<Long> config) {
        return this.deviceCacheManager.getLong(config.getDeviceCacheFlag());
    }

    private Optional<Boolean> getDeviceCacheBoolean(ConfigurationFlag<Boolean> config) {
        return this.deviceCacheManager.getBoolean(config.getDeviceCacheFlag());
    }

    private Optional<String> getDeviceCacheString(ConfigurationFlag<String> config) {
        return this.deviceCacheManager.getString(config.getDeviceCacheFlag());
    }

    private boolean isSamplingRateValid(float samplingRate) {
        return 0.0f <= samplingRate && samplingRate <= 1.0f;
    }

    private boolean isEventCountValid(long eventCount) {
        return eventCount >= 0L;
    }

    private boolean isTimeRangeSecValid(long timeRangeSec) {
        return timeRangeSec > 0L;
    }

    private boolean isGaugeCaptureFrequencyMsValid(long frequencyMilliseconds) {
        return frequencyMilliseconds >= 0L;
    }

    private boolean isSessionsMaxDurationMinutesValid(long maxDurationMin) {
        return maxDurationMin > 0L;
    }
}

