/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.metrics;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import android.view.View;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.perf.config.ConfigResolver;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.provider.FirebasePerfProvider;
import com.google.firebase.perf.session.PerfSession;
import com.google.firebase.perf.session.SessionManager;
import com.google.firebase.perf.transport.TransportManager;
import com.google.firebase.perf.util.Clock;
import com.google.firebase.perf.util.Constants;
import com.google.firebase.perf.util.FirstDrawDoneListener;
import com.google.firebase.perf.util.PreDrawListener;
import com.google.firebase.perf.util.Timer;
import com.google.firebase.perf.v1.ApplicationProcessState;
import com.google.firebase.perf.v1.TraceMetric;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AppStartTrace
implements Application.ActivityLifecycleCallbacks {
    private static final long MAX_LATENCY_BEFORE_UI_INIT = TimeUnit.MINUTES.toMicros(1L);
    private static final int CORE_POOL_SIZE = 0;
    private static final int MAX_POOL_SIZE = 1;
    private static volatile AppStartTrace instance;
    private static ExecutorService executorService;
    private boolean isRegisteredForLifecycleCallbacks = false;
    private final TransportManager transportManager;
    private final Clock clock;
    private final ConfigResolver configResolver;
    private final TraceMetric.Builder experimentTtid;
    private Context appContext;
    private WeakReference<Activity> launchActivity;
    private WeakReference<Activity> appStartActivity;
    private boolean isTooLateToInitUI = false;
    private Timer appStartTime = null;
    private Timer onCreateTime = null;
    private Timer onStartTime = null;
    private Timer onResumeTime = null;
    private Timer firstDrawDone = null;
    private Timer preDraw = null;
    private PerfSession startSession;
    private boolean isStartedFromBackground = false;

    @Keep
    public static void setLauncherActivityOnCreateTime(String activity) {
    }

    @Keep
    public static void setLauncherActivityOnStartTime(String activity) {
    }

    @Keep
    public static void setLauncherActivityOnResumeTime(String activity) {
    }

    public static AppStartTrace getInstance() {
        return instance != null ? instance : AppStartTrace.getInstance(TransportManager.getInstance(), new Clock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static AppStartTrace getInstance(TransportManager transportManager, Clock clock) {
        if (instance != null) return instance;
        Class<AppStartTrace> clazz = AppStartTrace.class;
        synchronized (AppStartTrace.class) {
            if (instance != null) return instance;
            instance = new AppStartTrace(transportManager, clock, ConfigResolver.getInstance(), new ThreadPoolExecutor(0, 1, MAX_LATENCY_BEFORE_UI_INIT + 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    AppStartTrace(@NonNull TransportManager transportManager, @NonNull Clock clock, @NonNull ConfigResolver configResolver, @NonNull ExecutorService executorService) {
        this.transportManager = transportManager;
        this.clock = clock;
        this.configResolver = configResolver;
        AppStartTrace.executorService = executorService;
        this.experimentTtid = TraceMetric.newBuilder().setName("_experiment_app_start_ttid");
    }

    public synchronized void registerActivityLifecycleCallbacks(@NonNull Context context) {
        if (this.isRegisteredForLifecycleCallbacks) {
            return;
        }
        Context appContext = context.getApplicationContext();
        if (appContext instanceof Application) {
            ((Application)appContext).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.isRegisteredForLifecycleCallbacks = true;
            this.appContext = appContext;
        }
    }

    public synchronized void unregisterActivityLifecycleCallbacks() {
        if (!this.isRegisteredForLifecycleCallbacks) {
            return;
        }
        ((Application)this.appContext).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.isRegisteredForLifecycleCallbacks = false;
    }

    private static Timer getStartTimer() {
        if (Build.VERSION.SDK_INT >= 24) {
            return Timer.ofElapsedRealtime(Process.getStartElapsedRealtime(), Process.getStartUptimeMillis());
        }
        return FirebasePerfProvider.getAppStartTime();
    }

    private void recordFirstDrawDone() {
        if (this.firstDrawDone != null) {
            return;
        }
        Timer start = AppStartTrace.getStartTimer();
        this.firstDrawDone = this.clock.getTime();
        this.experimentTtid.setClientStartTimeUs(start.getMicros()).setDurationUs(start.getDurationMicros(this.firstDrawDone));
        TraceMetric.Builder subtrace = TraceMetric.newBuilder().setName("_experiment_classLoadTime").setClientStartTimeUs(FirebasePerfProvider.getAppStartTime().getMicros()).setDurationUs(FirebasePerfProvider.getAppStartTime().getDurationMicros(this.firstDrawDone));
        this.experimentTtid.addSubtraces((TraceMetric)subtrace.build());
        subtrace = TraceMetric.newBuilder();
        subtrace.setName("_experiment_uptimeMillis").setClientStartTimeUs(start.getMicros()).setDurationUs(start.getDurationUptimeMicros(this.firstDrawDone));
        this.experimentTtid.addSubtraces((TraceMetric)subtrace.build());
        this.experimentTtid.addPerfSessions(this.startSession.build());
        if (this.isExperimentTraceDone()) {
            executorService.execute(() -> this.logExperimentTtid(this.experimentTtid));
            if (this.isRegisteredForLifecycleCallbacks) {
                this.unregisterActivityLifecycleCallbacks();
            }
        }
    }

    private void recordFirstDrawDonePreDraw() {
        if (this.preDraw != null) {
            return;
        }
        Timer start = AppStartTrace.getStartTimer();
        this.preDraw = this.clock.getTime();
        TraceMetric.Builder subtrace = TraceMetric.newBuilder().setName("_experiment_preDraw").setClientStartTimeUs(start.getMicros()).setDurationUs(start.getDurationMicros(this.preDraw));
        this.experimentTtid.addSubtraces((TraceMetric)subtrace.build());
        subtrace = TraceMetric.newBuilder();
        subtrace.setName("_experiment_preDraw_uptimeMillis").setClientStartTimeUs(start.getMicros()).setDurationUs(start.getDurationUptimeMicros(this.preDraw));
        this.experimentTtid.addSubtraces((TraceMetric)subtrace.build());
        if (this.isExperimentTraceDone()) {
            executorService.execute(() -> this.logExperimentTtid(this.experimentTtid));
            if (this.isRegisteredForLifecycleCallbacks) {
                this.unregisterActivityLifecycleCallbacks();
            }
        }
    }

    private boolean isExperimentTraceDone() {
        return this.preDraw != null && this.firstDrawDone != null;
    }

    public synchronized void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        if (this.isStartedFromBackground || this.onCreateTime != null) {
            return;
        }
        this.launchActivity = new WeakReference<Activity>(activity);
        this.onCreateTime = this.clock.getTime();
        if (FirebasePerfProvider.getAppStartTime().getDurationMicros(this.onCreateTime) > MAX_LATENCY_BEFORE_UI_INIT) {
            this.isTooLateToInitUI = true;
        }
    }

    public synchronized void onActivityStarted(Activity activity) {
        if (this.isStartedFromBackground || this.onStartTime != null || this.isTooLateToInitUI) {
            return;
        }
        this.onStartTime = this.clock.getTime();
    }

    public synchronized void onActivityResumed(Activity activity) {
        if (this.isStartedFromBackground || this.isTooLateToInitUI) {
            return;
        }
        boolean isExperimentTTIDEnabled = this.configResolver.getIsExperimentTTIDEnabled();
        if (isExperimentTTIDEnabled) {
            View rootView = activity.findViewById(0x1020002);
            FirstDrawDoneListener.registerForNextDraw(rootView, this::recordFirstDrawDone);
            PreDrawListener.registerForNextDraw(rootView, this::recordFirstDrawDonePreDraw);
        }
        if (this.onResumeTime != null) {
            return;
        }
        this.appStartActivity = new WeakReference<Activity>(activity);
        this.onResumeTime = this.clock.getTime();
        this.appStartTime = FirebasePerfProvider.getAppStartTime();
        this.startSession = SessionManager.getInstance().perfSession();
        AndroidLogger.getInstance().debug("onResume(): " + activity.getClass().getName() + ": " + this.appStartTime.getDurationMicros(this.onResumeTime) + " microseconds");
        executorService.execute(this::logAppStartTrace);
        if (!isExperimentTTIDEnabled && this.isRegisteredForLifecycleCallbacks) {
            this.unregisterActivityLifecycleCallbacks();
        }
    }

    private void logExperimentTtid(TraceMetric.Builder metric) {
        this.transportManager.log((TraceMetric)metric.build(), ApplicationProcessState.FOREGROUND_BACKGROUND);
    }

    private void logAppStartTrace() {
        TraceMetric.Builder metric = TraceMetric.newBuilder().setName(Constants.TraceNames.APP_START_TRACE_NAME.toString()).setClientStartTimeUs(this.getappStartTime().getMicros()).setDurationUs(this.getappStartTime().getDurationMicros(this.onResumeTime));
        ArrayList<TraceMetric> subtraces = new ArrayList<TraceMetric>(3);
        TraceMetric.Builder traceMetricBuilder = TraceMetric.newBuilder().setName(Constants.TraceNames.ON_CREATE_TRACE_NAME.toString()).setClientStartTimeUs(this.getappStartTime().getMicros()).setDurationUs(this.getappStartTime().getDurationMicros(this.onCreateTime));
        subtraces.add((TraceMetric)traceMetricBuilder.build());
        traceMetricBuilder = TraceMetric.newBuilder();
        traceMetricBuilder.setName(Constants.TraceNames.ON_START_TRACE_NAME.toString()).setClientStartTimeUs(this.onCreateTime.getMicros()).setDurationUs(this.onCreateTime.getDurationMicros(this.onStartTime));
        subtraces.add((TraceMetric)traceMetricBuilder.build());
        traceMetricBuilder = TraceMetric.newBuilder();
        traceMetricBuilder.setName(Constants.TraceNames.ON_RESUME_TRACE_NAME.toString()).setClientStartTimeUs(this.onStartTime.getMicros()).setDurationUs(this.onStartTime.getDurationMicros(this.onResumeTime));
        subtraces.add((TraceMetric)traceMetricBuilder.build());
        metric.addAllSubtraces(subtraces).addPerfSessions(this.startSession.build());
        this.transportManager.log((TraceMetric)metric.build(), ApplicationProcessState.FOREGROUND_BACKGROUND);
    }

    public void onActivityPaused(Activity activity) {
        if (this.isExperimentTraceDone()) {
            return;
        }
        Timer onPauseTime = this.clock.getTime();
        TraceMetric.Builder subtrace = TraceMetric.newBuilder().setName("_experiment_onPause").setClientStartTimeUs(onPauseTime.getMicros()).setDurationUs(AppStartTrace.getStartTimer().getDurationMicros(onPauseTime));
        this.experimentTtid.addSubtraces((TraceMetric)subtrace.build());
    }

    public void onActivityStopped(Activity activity) {
        if (this.isExperimentTraceDone()) {
            return;
        }
        Timer onStopTime = this.clock.getTime();
        TraceMetric.Builder subtrace = TraceMetric.newBuilder().setName("_experiment_onStop").setClientStartTimeUs(onStopTime.getMicros()).setDurationUs(AppStartTrace.getStartTimer().getDurationMicros(onStopTime));
        this.experimentTtid.addSubtraces((TraceMetric)subtrace.build());
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    @VisibleForTesting
    @Nullable
    Activity getLaunchActivity() {
        return (Activity)this.launchActivity.get();
    }

    @VisibleForTesting
    @Nullable
    Activity getAppStartActivity() {
        return (Activity)this.appStartActivity.get();
    }

    @VisibleForTesting
    Timer getappStartTime() {
        return this.appStartTime;
    }

    @VisibleForTesting
    Timer getOnCreateTime() {
        return this.onCreateTime;
    }

    @VisibleForTesting
    Timer getOnStartTime() {
        return this.onStartTime;
    }

    @VisibleForTesting
    Timer getOnResumeTime() {
        return this.onResumeTime;
    }

    @VisibleForTesting
    void setIsStartFromBackground() {
        this.isStartedFromBackground = true;
    }

    public static class StartFromBackgroundRunnable
    implements Runnable {
        private final AppStartTrace trace;

        public StartFromBackgroundRunnable(AppStartTrace trace) {
            this.trace = trace;
        }

        @Override
        public void run() {
            if (this.trace.onCreateTime == null) {
                this.trace.isStartedFromBackground = true;
            }
        }
    }
}

