/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.util;

import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewTreeObserver;
import java.util.concurrent.atomic.AtomicReference;

public class PreDrawListener
implements ViewTreeObserver.OnPreDrawListener {
    private final Handler mainThreadHandler = new Handler(Looper.getMainLooper());
    private final AtomicReference<View> viewReference;
    private final Runnable callback;

    public static void registerForNextDraw(View view, Runnable drawDoneCallback) {
        PreDrawListener listener = new PreDrawListener(view, drawDoneCallback);
        view.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)listener);
    }

    private PreDrawListener(View view, Runnable callback) {
        this.viewReference = new AtomicReference<View>(view);
        this.callback = callback;
    }

    public boolean onPreDraw() {
        View view = this.viewReference.getAndSet(null);
        if (view == null) {
            return true;
        }
        view.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        this.mainThreadHandler.post(this.callback);
        return true;
    }
}

