/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.util;

import java.util.concurrent.TimeUnit;

public class Rate {
    private long numTokensPerTotalTimeUnit;
    private long numTimeUnits;
    private TimeUnit timeUnit;

    public Rate(long numTokensPerTotalTimeUnit, long numTimeUnits, TimeUnit timeUnit) {
        assert (numTimeUnits > 0L);
        this.numTokensPerTotalTimeUnit = numTokensPerTotalTimeUnit;
        this.numTimeUnits = numTimeUnits;
        this.timeUnit = timeUnit;
    }

    public double getTokensPerSeconds() {
        switch (this.timeUnit) {
            case NANOSECONDS: {
                return (double)this.numTokensPerTotalTimeUnit / (double)this.numTimeUnits * (double)TimeUnit.SECONDS.toNanos(1L);
            }
            case MICROSECONDS: {
                return (double)this.numTokensPerTotalTimeUnit / (double)this.numTimeUnits * (double)TimeUnit.SECONDS.toMicros(1L);
            }
            case MILLISECONDS: {
                return (double)this.numTokensPerTotalTimeUnit / (double)this.numTimeUnits * (double)TimeUnit.SECONDS.toMillis(1L);
            }
        }
        return (double)this.numTokensPerTotalTimeUnit / (double)this.timeUnit.toSeconds(this.numTimeUnits);
    }
}

