/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import androidx.annotation.NonNull;
import com.google.firebase.perf.logging.AndroidLogger;
import okhttp3.HttpUrl;

public class Utils {
    private static Boolean isDebugLoggingEnabled = null;

    public static String stripSensitiveInfo(@NonNull String urlString) {
        HttpUrl url = HttpUrl.parse((String)urlString);
        if (url != null) {
            return url.newBuilder().username("").password("").query(null).fragment(null).toString();
        }
        return urlString;
    }

    public static String truncateURL(String urlString, int maxLength) {
        int lastSlash;
        if (urlString.length() <= maxLength) {
            return urlString;
        }
        if (urlString.charAt(maxLength) == '/') {
            return urlString.substring(0, maxLength);
        }
        HttpUrl url = HttpUrl.parse((String)urlString);
        if (url == null) {
            return urlString.substring(0, maxLength);
        }
        String path = url.encodedPath();
        if (path.lastIndexOf(47) >= 0 && (lastSlash = urlString.lastIndexOf(47, maxLength - 1)) >= 0) {
            return urlString.substring(0, lastSlash);
        }
        return urlString.substring(0, maxLength);
    }

    public static int bufferToInt(@NonNull byte[] buffer) {
        int ret = 0;
        for (int i = 0; i < 4 && i < buffer.length; ++i) {
            ret |= (buffer[i] & 0xFF) << i * 8;
        }
        return ret;
    }

    public static boolean isDebugLoggingEnabled(@NonNull Context appContext) {
        if (isDebugLoggingEnabled != null) {
            return isDebugLoggingEnabled;
        }
        try {
            ApplicationInfo ai = appContext.getPackageManager().getApplicationInfo(appContext.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            isDebugLoggingEnabled = bundle.getBoolean("firebase_performance_logcat_enabled", false);
            return isDebugLoggingEnabled;
        }
        catch (PackageManager.NameNotFoundException | NullPointerException e) {
            AndroidLogger.getInstance().debug("No perf logcat meta data found " + e.getMessage());
            return false;
        }
    }

    public static int saturatedIntCast(long value) {
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)value;
    }

    public static void checkArgument(boolean expression, String errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

