/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.sessions;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import com.google.firebase.FirebaseApp;
import com.google.firebase.encoders.DataEncoder;
import com.google.firebase.encoders.json.JsonDataEncoderBuilder;
import com.google.firebase.sessions.AndroidApplicationInfo;
import com.google.firebase.sessions.ApplicationInfo;
import com.google.firebase.sessions.AutoSessionEventEncoder;
import com.google.firebase.sessions.DataCollectionState;
import com.google.firebase.sessions.DataCollectionStatus;
import com.google.firebase.sessions.EventType;
import com.google.firebase.sessions.LogEnvironment;
import com.google.firebase.sessions.ProcessDetails;
import com.google.firebase.sessions.ProcessDetailsProvider;
import com.google.firebase.sessions.SessionDetails;
import com.google.firebase.sessions.SessionEvent;
import com.google.firebase.sessions.SessionInfo;
import com.google.firebase.sessions.api.SessionSubscriber;
import com.google.firebase.sessions.settings.SessionsSettings;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JT\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\b\b\u0002\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0016H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lcom/google/firebase/sessions/SessionEvents;", "", "()V", "SESSION_EVENT_ENCODER", "Lcom/google/firebase/encoders/DataEncoder;", "getSESSION_EVENT_ENCODER$com_google_firebase_firebase_sessions", "()Lcom/google/firebase/encoders/DataEncoder;", "buildSession", "Lcom/google/firebase/sessions/SessionEvent;", "firebaseApp", "Lcom/google/firebase/FirebaseApp;", "sessionDetails", "Lcom/google/firebase/sessions/SessionDetails;", "sessionsSettings", "Lcom/google/firebase/sessions/settings/SessionsSettings;", "currentProcessDetails", "Lcom/google/firebase/sessions/ProcessDetails;", "appProcessDetails", "", "subscribers", "", "Lcom/google/firebase/sessions/api/SessionSubscriber$Name;", "Lcom/google/firebase/sessions/api/SessionSubscriber;", "firebaseInstallationId", "", "getApplicationInfo", "Lcom/google/firebase/sessions/ApplicationInfo;", "toDataCollectionState", "Lcom/google/firebase/sessions/DataCollectionState;", "subscriber", "com.google.firebase-firebase-sessions"})
public final class SessionEvents {
    @NotNull
    public static final SessionEvents INSTANCE = new SessionEvents();
    @NotNull
    private static final DataEncoder SESSION_EVENT_ENCODER;

    private SessionEvents() {
    }

    @NotNull
    public final DataEncoder getSESSION_EVENT_ENCODER$com_google_firebase_firebase_sessions() {
        return SESSION_EVENT_ENCODER;
    }

    @NotNull
    public final SessionEvent buildSession(@NotNull FirebaseApp firebaseApp, @NotNull SessionDetails sessionDetails, @NotNull SessionsSettings sessionsSettings, @NotNull ProcessDetails currentProcessDetails, @NotNull List<ProcessDetails> appProcessDetails, @NotNull Map<SessionSubscriber.Name, ? extends SessionSubscriber> subscribers, @NotNull String firebaseInstallationId) {
        Intrinsics.checkNotNullParameter((Object)firebaseApp, (String)"firebaseApp");
        Intrinsics.checkNotNullParameter((Object)sessionDetails, (String)"sessionDetails");
        Intrinsics.checkNotNullParameter((Object)sessionsSettings, (String)"sessionsSettings");
        Intrinsics.checkNotNullParameter((Object)currentProcessDetails, (String)"currentProcessDetails");
        Intrinsics.checkNotNullParameter(appProcessDetails, (String)"appProcessDetails");
        Intrinsics.checkNotNullParameter(subscribers, (String)"subscribers");
        Intrinsics.checkNotNullParameter((Object)firebaseInstallationId, (String)"firebaseInstallationId");
        return new SessionEvent(EventType.SESSION_START, new SessionInfo(sessionDetails.getSessionId(), sessionDetails.getFirstSessionId(), sessionDetails.getSessionIndex(), sessionDetails.getSessionStartTimestampUs(), new DataCollectionStatus(this.toDataCollectionState(subscribers.get((Object)SessionSubscriber.Name.PERFORMANCE)), this.toDataCollectionState(subscribers.get((Object)SessionSubscriber.Name.CRASHLYTICS)), sessionsSettings.getSamplingRate()), firebaseInstallationId), this.getApplicationInfo(firebaseApp));
    }

    public static /* synthetic */ SessionEvent buildSession$default(SessionEvents sessionEvents, FirebaseApp firebaseApp, SessionDetails sessionDetails, SessionsSettings sessionsSettings, ProcessDetails processDetails, List list, Map map2, String string, int n, Object object) {
        if ((n & 0x20) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 0x40) != 0) {
            string = "";
        }
        return sessionEvents.buildSession(firebaseApp, sessionDetails, sessionsSettings, processDetails, list, map2, string);
    }

    @NotNull
    public final ApplicationInfo getApplicationInfo(@NotNull FirebaseApp firebaseApp) {
        Intrinsics.checkNotNullParameter((Object)firebaseApp, (String)"firebaseApp");
        Context context = firebaseApp.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"firebaseApp.applicationContext");
        Context context2 = context;
        String packageName = context2.getPackageName();
        PackageInfo packageInfo = context2.getPackageManager().getPackageInfo(packageName, 0);
        String buildVersion = Build.VERSION.SDK_INT >= 28 ? String.valueOf(packageInfo.getLongVersionCode()) : String.valueOf(packageInfo.versionCode);
        String string = firebaseApp.getOptions().getApplicationId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"firebaseApp.options.applicationId");
        String string2 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MODEL");
        String string3 = Build.VERSION.RELEASE;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"RELEASE");
        Intrinsics.checkNotNullExpressionValue((Object)packageName, (String)"packageName");
        String string4 = packageInfo.versionName;
        if (string4 == null) {
            string4 = buildVersion;
        }
        String string5 = Build.MANUFACTURER;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"MANUFACTURER");
        Context context3 = firebaseApp.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"firebaseApp.applicationContext");
        ProcessDetails processDetails = ProcessDetailsProvider.INSTANCE.getCurrentProcessDetails(context3);
        Context context4 = firebaseApp.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context4, (String)"firebaseApp.applicationContext");
        return new ApplicationInfo(string, string2, "1.2.0", string3, LogEnvironment.LOG_ENVIRONMENT_PROD, new AndroidApplicationInfo(packageName, string4, buildVersion, string5, processDetails, ProcessDetailsProvider.INSTANCE.getAppProcessDetails(context4)));
    }

    private final DataCollectionState toDataCollectionState(SessionSubscriber subscriber) {
        return subscriber == null ? DataCollectionState.COLLECTION_SDK_NOT_INSTALLED : (subscriber.isDataCollectionEnabled() ? DataCollectionState.COLLECTION_ENABLED : DataCollectionState.COLLECTION_DISABLED);
    }

    static {
        DataEncoder dataEncoder = new JsonDataEncoderBuilder().configureWith(AutoSessionEventEncoder.CONFIG).ignoreNullValues(true).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataEncoder, (String)"JsonDataEncoderBuilder()\u2026lues(true)\n      .build()");
        SESSION_EVENT_ENCODER = dataEncoder;
    }
}

