/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.plugin;

import com.android.build.api.transform.Transform;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.LibraryExtension;
import com.google.firebase.perf.plugin.FirebasePerfExtension;
import com.google.firebase.perf.plugin.FirebaseTransform;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.attributes.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirebasePerfPlugin
implements Plugin<Project> {
    private static final String FIREBASE_PERF_TAG = "Firebase Performance Plugin";
    private final Logger mLogger = LoggerFactory.getLogger((String)"Firebase Performance Plugin");
    private static final String FIREPERF_SDK_GROUP = "com.google.firebase";
    private static final String FIREPERF_SDK_MODULE = "firebase-perf";
    private static final String FIREPERF_SDK_VERSION_WANTED = "11.0.4";
    private static final String DEPENDENCY_LINE = "compile 'com.google.firebase:firebase-perf:VERSION_NUMBER_GREATER_THAN_OR_EQUAL_TO_11.0.4'";

    public void apply(Project project) {
        Object ext = project.getExtensions().findByName("android");
        if (ext == null || !(ext instanceof AppExtension)) {
            if (ext instanceof LibraryExtension) {
                throw new RuntimeException("Firebase Performance Plugin cannot be applied to a library project.  It must only be used with an Android application project.");
            }
            throw new RuntimeException("Firebase Performance Plugin may only be applied to Android projects");
        }
        AppExtension androidExt = (AppExtension)ext;
        androidExt.registerTransform((Transform)new FirebaseTransform(project), new Object[0]);
        project.getExtensions().create("FirebasePerformance", FirebasePerfExtension.class, new Object[0]);
    }

    private void verifySdkVersion(final Project project) throws ResolveException {
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project p) {
                boolean perfDependencyIsPresent = false;
                ConfigurationContainer configs = project.getConfigurations();
                for (Configuration configuration : configs) {
                    if (!configuration.getName().equals("compile")) continue;
                    ArtifactView artifactView = configuration.getIncoming().artifactView(config -> config.attributes(container -> container.attribute(Attribute.of((String)"artifactType", String.class), (Object)"aar")));
                    Set artifacts = artifactView.getArtifacts().getArtifacts();
                    for (ResolvedArtifactResult artifact : artifacts) {
                        ComponentIdentifier id = artifact.getId().getComponentIdentifier();
                        if (!(id instanceof ModuleComponentIdentifier)) continue;
                        ModuleComponentIdentifier moduleComponentId = (ModuleComponentIdentifier)id;
                        String group = moduleComponentId.getGroup();
                        String module = moduleComponentId.getModule();
                        String version = moduleComponentId.getVersion();
                        if (!FirebasePerfPlugin.FIREPERF_SDK_GROUP.equalsIgnoreCase(group) || !FirebasePerfPlugin.FIREPERF_SDK_MODULE.equalsIgnoreCase(module)) continue;
                        perfDependencyIsPresent = true;
                        String string = String.valueOf(version);
                        FirebasePerfPlugin.this.mLogger.debug(string.length() != 0 ? "FirebasePerformance SDK version is:".concat(string) : new String("FirebasePerformance SDK version is:"));
                        if (FirebasePerfPlugin.compareVersionString(version, FirebasePerfPlugin.FIREPERF_SDK_VERSION_WANTED) >= 0) {
                            return;
                        }
                        throw new RuntimeException("Firebase Performance SDK version must be greater than or equal to 11.0.4\nPlease upgrade the dependency for the Firebase Performance SDK to a newer version.");
                    }
                }
                if (!perfDependencyIsPresent) {
                    throw new RuntimeException("To use the Firebase Performance Plugin, the Firebase Performance Monitoring SDK must be added to the app's build.gradle. Please add compile 'com.google.firebase:firebase-perf:VERSION_NUMBER_GREATER_THAN_OR_EQUAL_TO_11.0.4' to the app's build.gradle.");
                }
            }
        });
    }

    static int compareVersionString(String s1, String s2) {
        int idx = 0;
        idx = s1.indexOf("-");
        if (idx != -1) {
            s1 = s1.substring(0, idx);
        }
        if ((idx = s2.indexOf("-")) != -1) {
            s2 = s2.substring(0, idx);
        }
        String regex = "\\.";
        String[] a1 = s1.split(regex);
        String[] a2 = s2.split(regex);
        for (int i = 0; i < a1.length && i < a2.length; ++i) {
            Integer v1 = null;
            Integer v2 = null;
            try {
                v1 = Integer.parseInt(a1[i]);
            }
            catch (NumberFormatException e) {
                v1 = null;
            }
            try {
                v2 = Integer.parseInt(a2[i]);
            }
            catch (NumberFormatException e) {
                v2 = null;
            }
            if (v1 == null && v2 != null) {
                return -1;
            }
            if (v1 != null && v2 == null) {
                return 1;
            }
            if (v1 == null && v2 == null) {
                return 0;
            }
            if (v1.intValue() == v2.intValue()) continue;
            return v1 - v2;
        }
        return a1.length - a2.length;
    }
}

