/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.plugin.instrumentation;

import com.google.firebase.perf.plugin.instrumentation.InstrumentationConfig;
import com.google.firebase.perf.plugin.instrumentation.annotation.AnnotatedMethodInstrumentationConfig;
import com.google.firebase.perf.plugin.instrumentation.annotation.AnnotatedMethodInstrumentationFactory;
import com.google.firebase.perf.plugin.instrumentation.network.NetworkObjectInstrumentationConfig;
import com.google.firebase.perf.plugin.instrumentation.network.NetworkObjectInstrumentationFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentationConfigImpl
implements InstrumentationConfig {
    private final List<AnnotatedMethodInstrumentationConfig> mAnnotationInstrumentationConfigs;
    private final List<NetworkObjectInstrumentationConfig> mNetworkObjectInstrumentationConfigs;
    private final ClassLoader mClassLoader;
    Logger mLogger = LoggerFactory.getLogger((String)"FirebasePerformancePlugin");
    private final HashSet<String> missingClasses = new HashSet();

    public InstrumentationConfigImpl(List<AnnotatedMethodInstrumentationConfig> annotationInstrumentationConfigs, List<NetworkObjectInstrumentationConfig> objectInstrumentationConfigs, ClassLoader classLoader) {
        this.mAnnotationInstrumentationConfigs = Collections.unmodifiableList(annotationInstrumentationConfigs);
        this.mNetworkObjectInstrumentationConfigs = Collections.unmodifiableList(objectInstrumentationConfigs);
        this.mClassLoader = classLoader != null ? classLoader : this.getClass().getClassLoader();
    }

    @Override
    @Nullable
    public NetworkObjectInstrumentationFactory getNetworkObjectInstrumentationFactory(String className, String methodName, String methodDesc) {
        Type classType = Type.getObjectType((String)className);
        if (classType.getSort() != 10) {
            return null;
        }
        Class<?> qcl = null;
        try {
            qcl = Class.forName(classType.getClassName(), false, this.mClassLoader);
        }
        catch (Exception | LinkageError e) {
            return null;
        }
        for (NetworkObjectInstrumentationConfig networkObjConfig : this.mNetworkObjectInstrumentationConfigs) {
            Type t = Type.getObjectType((String)networkObjConfig.getClassName());
            String cn = t.getClassName();
            if (this.missingClasses.contains(cn)) continue;
            try {
                Class<?> cl = Class.forName(cn, false, this.mClassLoader);
                boolean isInst = cl.isAssignableFrom(qcl);
                boolean methodMatch = networkObjConfig.getMethodName().equals(methodName);
                boolean descMatch = networkObjConfig.getMethodDesc().equals(methodDesc);
                if (!isInst || !methodMatch || !descMatch) continue;
                return networkObjConfig.getFactory();
            }
            catch (Exception | LinkageError e) {
                this.missingClasses.add(cn);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public List<AnnotatedMethodInstrumentationFactory> getAnnotatedMethodInstrumentationFactories(String classDesc) {
        ArrayList<AnnotatedMethodInstrumentationFactory> list = null;
        for (AnnotatedMethodInstrumentationConfig config : this.mAnnotationInstrumentationConfigs) {
            if (!config.getClassDesc().equals(classDesc)) continue;
            if (list == null) {
                list = new ArrayList<AnnotatedMethodInstrumentationFactory>();
            }
            list.add(config.getFactory());
        }
        return list;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.mClassLoader;
    }
}

