/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.plugin;

import com.android.build.api.transform.Transform;
import com.android.build.gradle.AppExtension;
import com.google.common.base.Ascii;
import com.google.firebase.perf.plugin.FirebasePerfExtension;
import com.google.firebase.perf.plugin.FirebasePerfTransform;
import java.util.Optional;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirebasePerfPlugin
implements Plugin<Project> {
    static final String FIREBASE_PERF_TAG = "FirebasePerformancePlugin";
    static final String FIREBASE_PERF_EXTENSION_NAME = "FirebasePerformance";
    static final String FIREBASE_PERF_INSTRUMENTATION_ENABLED_KEY = "firebasePerformanceInstrumentationEnabled";
    private static final Logger logger = LoggerFactory.getLogger((String)"FirebasePerformancePlugin");
    private boolean foundAppPlugin = false;

    public void apply(Project project) {
        this.performDeprecation(project);
        project.getPluginManager().withPlugin("com.android.application", androidPlugin -> {
            this.foundAppPlugin = true;
            project.getExtensions().create(FIREBASE_PERF_EXTENSION_NAME, FirebasePerfExtension.class, new Object[0]);
            if (FirebasePerfPlugin.isPluginDisabledByProjectPropertyValue(project)) {
                logger.info(String.format("%s is disabled globally for the project by specifying '%s=false' flag in the 'gradle.properties' file.", FIREBASE_PERF_TAG, FIREBASE_PERF_INSTRUMENTATION_ENABLED_KEY));
            } else {
                this.perform(project);
            }
        });
        project.afterEvaluate(project2 -> {
            if (!this.foundAppPlugin) {
                throw new IllegalStateException("FirebasePerformancePlugin must only be used with Android application projects. Need to apply the 'com.android.application' plugin with this plugin.");
            }
        });
    }

    private void perform(Project project) {
        AppExtension androidExt = (AppExtension)project.getExtensions().getByType(AppExtension.class);
        androidExt.registerTransform((Transform)new FirebasePerfTransform(project), new Object[0]);
    }

    private static boolean isPluginDisabledByProjectPropertyValue(Project project) {
        Optional<Boolean> parsedPropVal = FirebasePerfPlugin.getProjectPropertyValue(project);
        return parsedPropVal.isPresent() && Boolean.FALSE.equals(parsedPropVal.get());
    }

    static Optional<Boolean> getProjectPropertyValue(Project project) {
        if (!project.hasProperty(FIREBASE_PERF_INSTRUMENTATION_ENABLED_KEY)) {
            return Optional.empty();
        }
        String propVal = project.property(FIREBASE_PERF_INSTRUMENTATION_ENABLED_KEY).toString();
        Optional<Boolean> parsedPropVal = FirebasePerfPlugin.parseBoolean(propVal);
        if (parsedPropVal.isPresent()) {
            return parsedPropVal;
        }
        throw new IllegalStateException(String.format("Could not get unknown value '%s' for the project property '%s' defined in the 'gradle.properties' file. Correct format is either '%s=false' or '%s=true'.", propVal, FIREBASE_PERF_INSTRUMENTATION_ENABLED_KEY, FIREBASE_PERF_INSTRUMENTATION_ENABLED_KEY, FIREBASE_PERF_INSTRUMENTATION_ENABLED_KEY));
    }

    private static Optional<Boolean> parseBoolean(String s) {
        if (s != null && (Ascii.equalsIgnoreCase((CharSequence)s, (CharSequence)"true") || Ascii.equalsIgnoreCase((CharSequence)s, (CharSequence)"false"))) {
            return Optional.of(Boolean.parseBoolean(s));
        }
        return Optional.empty();
    }

    public static Logger getLogger() {
        return logger;
    }

    private void performDeprecation(Project project) {
        project.afterEvaluate(project2 -> {
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader != null && classLoader.getResource("FirebasePluginsMarker.txt") != null) {
                throw new GradleException(FirebasePerfPlugin.getDeprecationMsg(project.getPluginManager().hasPlugin("com.google.firebase.firebase-crash")));
            }
        });
    }

    private static String getDeprecationMsg(boolean hasCrashPlugin) {
        String string;
        String perfMsg = String.format("'firebase-plugins' v2.0.0 is deprecated.\n Replace '%s' with '%s' in your project-level 'build.gradle' file\n Refer Firebase Performance documentation at %s for details.", "com.google.firebase:firebase-plugins:2.0.0", "com.google.firebase:perf-plugin:1.2.1", "https://firebase.google.com/docs/perf-mon/get-started-android#add-performance-monitoring-to-your-app");
        String crashMsg = String.format("\n\n'Firebase Crash Reporting' is deprecated.\n Please migrate to 'Firebase Crashlytics' instead.\n Refer migration steps at %s for details.", "https://firebase.google.com/docs/crashlytics/upgrade-from-crash-reporting#android");
        if (hasCrashPlugin) {
            String string2 = String.valueOf(perfMsg);
            String string3 = String.valueOf(crashMsg);
            string = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        } else {
            string = perfMsg;
        }
        return string;
    }
}

